/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web.assembler;

import java.util.Map;
import javax.servlet.FilterRegistration;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.apache.geronimo.web.info.FilterInfo;
import org.apache.geronimo.web.info.FilterMappingInfo;
import org.apache.geronimo.web.info.ServletInfo;
import org.apache.geronimo.web.info.WebAppInfo;

public class Assembler {
    public void assemble(ServletContext servletContext, WebAppInfo webAppInfo) {
        for (Map.Entry<String, String> entry : webAppInfo.contextParams.entrySet()) {
            servletContext.setInitParameter(entry.getKey(), entry.getValue());
        }
        for (ServletInfo servletInfo : webAppInfo.servlets) {
            this.addServlet(servletContext, servletInfo);
        }
        for (FilterInfo filterInfo : webAppInfo.filters) {
            this.addFilter(servletContext, filterInfo);
        }
        for (String listener : webAppInfo.listeners) {
            this.addListener(servletContext, listener);
        }
    }

    private void addListener(ServletContext servletContext, String listener) {
        servletContext.addListener(listener);
    }

    private FilterRegistration.Dynamic addFilter(ServletContext servletContext, FilterInfo filterInfo) {
        FilterRegistration.Dynamic filterRegistration = servletContext.addFilter(filterInfo.filterName, filterInfo.filterClass);
        filterRegistration.setAsyncSupported(filterInfo.asyncSupported);
        filterRegistration.setInitParameters(filterInfo.initParams);
        for (FilterMappingInfo servletMapping : filterInfo.servletMappings) {
            filterRegistration.addMappingForServletNames(servletMapping.dispatchers, true, servletMapping.mapping.toArray(new String[servletMapping.mapping.size()]));
        }
        for (FilterMappingInfo urlMapping : filterInfo.urlMappings) {
            filterRegistration.addMappingForUrlPatterns(urlMapping.dispatchers, true, urlMapping.mapping.toArray(new String[urlMapping.mapping.size()]));
        }
        return filterRegistration;
    }

    protected ServletRegistration.Dynamic addServlet(ServletContext servletContext, ServletInfo servletInfo) {
        ServletRegistration.Dynamic servletRegistration = servletContext.addServlet(servletInfo.servletName, servletInfo.servletClass);
        servletRegistration.setInitParameters(servletInfo.initParams);
        servletRegistration.setAsyncSupported(servletInfo.asyncSupported);
        if (servletInfo.loadOnStartup != null) {
            servletRegistration.setLoadOnStartup(servletInfo.loadOnStartup.intValue());
        }
        if (servletInfo.multipartConfigInfo != null) {
            servletRegistration.setMultipartConfig(new MultipartConfigElement(servletInfo.multipartConfigInfo.location, servletInfo.multipartConfigInfo.maxFileSize, servletInfo.multipartConfigInfo.maxRequestSize, servletInfo.multipartConfigInfo.fileSizeThreshold));
        }
        servletRegistration.setRunAsRole(servletInfo.runAsRole);
        servletRegistration.addMapping(servletInfo.servletMappings.toArray(new String[servletInfo.servletMappings.size()]));
        return servletRegistration;
    }
}

