/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilderCollection;
import org.apache.geronimo.deployment.service.GBeanBuilder;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.deployment.xbeans.ServiceDocument;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.ImportType;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentSetter;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.geronimo.security.util.URLPattern;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerSecurityDocument;
import org.apache.geronimo.xbeans.j2ee.FilterMappingType;
import org.apache.geronimo.xbeans.j2ee.HttpMethodType;
import org.apache.geronimo.xbeans.j2ee.RoleNameType;
import org.apache.geronimo.xbeans.j2ee.SecurityConstraintType;
import org.apache.geronimo.xbeans.j2ee.SecurityRoleRefType;
import org.apache.geronimo.xbeans.j2ee.SecurityRoleType;
import org.apache.geronimo.xbeans.j2ee.ServletMappingType;
import org.apache.geronimo.xbeans.j2ee.ServletType;
import org.apache.geronimo.xbeans.j2ee.UrlPatternType;
import org.apache.geronimo.xbeans.j2ee.WebAppDocument;
import org.apache.geronimo.xbeans.j2ee.WebAppType;
import org.apache.geronimo.xbeans.j2ee.WebResourceCollectionType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlDocumentProperties;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public abstract class AbstractWebModuleBuilder
implements ModuleBuilder {
    private static final Log log = LogFactory.getLog((Class)AbstractWebModuleBuilder.class);
    private static final QName TAGLIB = new QName("http://java.sun.com/xml/ns/j2ee", "taglib");
    private static final String LINE_SEP = System.getProperty("line.separator");
    protected static final AbstractNameQuery MANAGED_CONNECTION_FACTORY_PATTERN;
    private static final AbstractNameQuery ADMIN_OBJECT_PATTERN;
    protected static final AbstractNameQuery STATELESS_SESSION_BEAN_PATTERN;
    protected static final AbstractNameQuery STATEFUL_SESSION_BEAN_PATTERN;
    protected static final AbstractNameQuery ENTITY_BEAN_PATTERN;
    protected final Kernel kernel;
    protected final NamespaceDrivenBuilderCollection securityBuilders;
    protected final NamespaceDrivenBuilderCollection serviceBuilders;
    protected final ResourceEnvironmentSetter resourceEnvironmentSetter;
    protected final NamingBuilder namingBuilders;
    private static final QName SECURITY_QNAME;
    private static final QName SERVICE_QNAME;
    private static final URI RELATIVE_MODULE_BASE_URI;

    protected AbstractWebModuleBuilder(Kernel kernel, Collection securityBuilders, Collection serviceBuilders, NamingBuilder namingBuilders, ResourceEnvironmentSetter resourceEnvironmentSetter) {
        this.kernel = kernel;
        this.securityBuilders = new NamespaceDrivenBuilderCollection(securityBuilders, GerSecurityDocument.type.getDocumentElementName());
        this.serviceBuilders = new NamespaceDrivenBuilderCollection(serviceBuilders, GBeanBuilder.SERVICE_QNAME);
        this.namingBuilders = namingBuilders;
        this.resourceEnvironmentSetter = resourceEnvironmentSetter;
    }

    public NamingBuilder getNamingBuilders() {
        return this.namingBuilders;
    }

    protected Set findGBeanDependencies(EARContext earContext) {
        HashSet dependencies = new HashSet();
        dependencies.addAll(earContext.listGBeans(MANAGED_CONNECTION_FACTORY_PATTERN));
        dependencies.addAll(earContext.listGBeans(ADMIN_OBJECT_PATTERN));
        dependencies.addAll(earContext.listGBeans(STATELESS_SESSION_BEAN_PATTERN));
        dependencies.addAll(earContext.listGBeans(STATEFUL_SESSION_BEAN_PATTERN));
        dependencies.addAll(earContext.listGBeans(ENTITY_BEAN_PATTERN));
        return dependencies;
    }

    public Module createModule(File plan, JarFile moduleFile, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        return this.createModule((Object)plan, moduleFile, ".", null, true, null, null, naming, idBuilder);
    }

    public Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment environment, Object moduleContextInfo, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        return this.createModule(plan, moduleFile, targetPath, specDDUrl, false, (String)moduleContextInfo, earName, naming, idBuilder);
    }

    protected abstract Module createModule(Object var1, JarFile var2, String var3, URL var4, boolean var5, String var6, AbstractName var7, Naming var8, ModuleIDBuilder var9) throws DeploymentException;

    protected Map buildServletNameToPathMap(WebAppType webApp, String contextRoot) {
        contextRoot = "/" + contextRoot;
        HashMap<String, String> map = new HashMap<String, String>();
        ServletMappingType[] servletMappings = webApp.getServletMappingArray();
        for (int j = 0; j < servletMappings.length; ++j) {
            ServletMappingType servletMapping = servletMappings[j];
            String servletName = servletMapping.getServletName().getStringValue().trim();
            map.put(servletName, contextRoot + servletMapping.getUrlPattern().getStringValue().trim());
        }
        return map;
    }

    protected String determineDefaultContextRoot(WebAppType webApp, boolean isStandAlone, JarFile moduleFile, String targetPath) {
        if (webApp != null && webApp.getId() != null) {
            return webApp.getId();
        }
        if (isStandAlone) {
            return this.trimPath(new File(moduleFile.getName()).getName());
        }
        return this.trimPath(targetPath);
    }

    private String trimPath(String path) {
        if (path == null) {
            return null;
        }
        if (path.endsWith(".war")) {
            path = path.substring(0, path.length() - 4);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module, Collection configurationStores, ConfigurationStore targetConfigurationStore, Collection repositories) throws DeploymentException {
        EARContext moduleContext;
        if (module.isStandAlone()) {
            moduleContext = earContext;
        } else {
            Environment environment = module.getEnvironment();
            Artifact earConfigId = earContext.getConfigID();
            Artifact configId = new Artifact(earConfigId.getGroupId(), earConfigId.getArtifactId() + "_" + module.getTargetPath(), earConfigId.getVersion(), "car");
            environment.setConfigId(configId);
            environment.addDependency(earConfigId, ImportType.ALL);
            File configurationDir = new File(earContext.getBaseDir(), module.getTargetPath());
            configurationDir.mkdirs();
            try {
                File inPlaceConfigurationDir = null;
                if (null != earContext.getInPlaceConfigurationDir()) {
                    inPlaceConfigurationDir = new File(earContext.getInPlaceConfigurationDir(), module.getTargetPath());
                }
                moduleContext = new EARContext(configurationDir, inPlaceConfigurationDir, environment, ConfigurationModuleType.WAR, module.getModuleName(), earContext);
            }
            catch (DeploymentException e) {
                this.cleanupConfigurationDir(configurationDir);
                throw e;
            }
        }
        module.setEarContext(moduleContext);
        module.setRootEarContext(earContext);
        try {
            JarFile warFile = module.getModuleFile();
            Enumeration<JarEntry> entries = warFile.entries();
            ArrayList<ZipEntry> libs = new ArrayList<ZipEntry>();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                URI targetPath = new URI(null, entry.getName(), null);
                if (entry.getName().equals("WEB-INF/web.xml")) {
                    moduleContext.addFile(targetPath, module.getOriginalSpecDD());
                    continue;
                }
                if (entry.getName().startsWith("WEB-INF/lib") && entry.getName().endsWith(".jar")) {
                    libs.add(entry);
                    continue;
                }
                moduleContext.addFile(targetPath, (ZipFile)warFile, entry);
            }
            moduleContext.getConfiguration().addToClassPath("WEB-INF/classes/");
            Iterator iterator = libs.iterator();
            while (iterator.hasNext()) {
                ZipEntry entry = (ZipEntry)iterator.next();
                URI targetPath = new URI(null, entry.getName(), null);
                moduleContext.addInclude(targetPath, (ZipFile)warFile, entry);
            }
            moduleContext.addManifestClassPath(warFile, RELATIVE_MODULE_BASE_URI);
        }
        catch (IOException e) {
            throw new DeploymentException("Problem deploying war", (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Could not construct URI for location of war entry", (Throwable)e);
        }
        finally {
            if (!module.isStandAlone()) {
                try {
                    moduleContext.flush();
                }
                catch (IOException e) {
                    throw new DeploymentException("Problem closing war context", (Throwable)e);
                }
            }
        }
    }

    protected void addUnmappedJSPPermissions(Set securityRoles, Map rolePermissions) {
        Iterator iter = securityRoles.iterator();
        while (iter.hasNext()) {
            String roleName = (String)iter.next();
            this.addPermissionToRole(roleName, (Permission)new WebRoleRefPermission("", roleName), rolePermissions);
        }
    }

    protected ComponentPermissions buildSpecSecurityConfig(WebAppType webApp, Set securityRoles, Map rolePermissions) {
        UncheckedItem item;
        String name;
        URLPattern pattern;
        HashMap<String, URLPattern> uncheckedPatterns = new HashMap<String, URLPattern>();
        HashMap uncheckedResourcePatterns = new HashMap();
        HashMap uncheckedUserPatterns = new HashMap();
        HashMap excludedPatterns = new HashMap();
        HashMap rolesPatterns = new HashMap();
        HashSet<URLPattern> allSet = new HashSet<URLPattern>();
        HashMap<String, URLPattern> allMap = new HashMap<String, URLPattern>();
        SecurityConstraintType[] securityConstraintArray = webApp.getSecurityConstraintArray();
        for (int i = 0; i < securityConstraintArray.length; ++i) {
            SecurityConstraintType securityConstraintType = securityConstraintArray[i];
            HashMap<String, Object> currentPatterns = securityConstraintType.isSetAuthConstraint() ? (securityConstraintType.getAuthConstraint().getRoleNameArray().length == 0 ? excludedPatterns : rolesPatterns) : uncheckedPatterns;
            String transport = "";
            if (securityConstraintType.isSetUserDataConstraint()) {
                transport = securityConstraintType.getUserDataConstraint().getTransportGuarantee().getStringValue().trim().toUpperCase();
            }
            WebResourceCollectionType[] webResourceCollectionTypeArray = securityConstraintType.getWebResourceCollectionArray();
            for (int j = 0; j < webResourceCollectionTypeArray.length; ++j) {
                WebResourceCollectionType webResourceCollectionType = webResourceCollectionTypeArray[j];
                UrlPatternType[] urlPatternTypeArray = webResourceCollectionType.getUrlPatternArray();
                for (int k = 0; k < urlPatternTypeArray.length; ++k) {
                    HttpMethodType[] httpMethodTypeArray;
                    URLPattern allPattern;
                    UrlPatternType urlPatternType = urlPatternTypeArray[k];
                    String url = urlPatternType.getStringValue().trim();
                    URLPattern pattern2 = (URLPattern)currentPatterns.get(url);
                    if (pattern2 == null) {
                        pattern2 = new URLPattern(url);
                        currentPatterns.put(url, pattern2);
                    }
                    if ((allPattern = (URLPattern)allMap.get(url)) == null) {
                        allPattern = new URLPattern(url);
                        allSet.add(allPattern);
                        allMap.put(url, allPattern);
                    }
                    if ((httpMethodTypeArray = webResourceCollectionType.getHttpMethodArray()).length == 0) {
                        pattern2.addMethod("");
                        allPattern.addMethod("");
                    } else {
                        for (int l = 0; l < httpMethodTypeArray.length; ++l) {
                            HttpMethodType httpMethodType = httpMethodTypeArray[l];
                            String method = httpMethodType.getStringValue().trim();
                            pattern2.addMethod(method);
                            allPattern.addMethod(method);
                        }
                    }
                    if (currentPatterns == rolesPatterns) {
                        RoleNameType[] roleNameTypeArray = securityConstraintType.getAuthConstraint().getRoleNameArray();
                        for (int l = 0; l < roleNameTypeArray.length; ++l) {
                            RoleNameType roleNameType = roleNameTypeArray[l];
                            String role = roleNameType.getStringValue().trim();
                            if (role.equals("*")) {
                                pattern2.addAllRoles((Collection)securityRoles);
                                continue;
                            }
                            pattern2.addRole(role);
                        }
                    }
                    pattern2.setTransport(transport);
                }
            }
        }
        Permissions excludedPermissions = new Permissions();
        Permissions uncheckedPermissions = new Permissions();
        Iterator<Object> iter = excludedPatterns.keySet().iterator();
        while (iter.hasNext()) {
            pattern = (URLPattern)excludedPatterns.get(iter.next());
            name = pattern.getQualifiedPattern(allSet);
            String actions = pattern.getMethods();
            ((PermissionCollection)excludedPermissions).add((Permission)new WebResourcePermission(name, actions));
            ((PermissionCollection)excludedPermissions).add((Permission)new WebUserDataPermission(name, actions));
        }
        iter = rolesPatterns.keySet().iterator();
        while (iter.hasNext()) {
            pattern = (URLPattern)rolesPatterns.get(iter.next());
            name = pattern.getQualifiedPattern(allSet);
            String actions = pattern.getMethods();
            WebResourcePermission permission = new WebResourcePermission(name, actions);
            Iterator names = pattern.getRoles().iterator();
            while (names.hasNext()) {
                String roleName = (String)names.next();
                this.addPermissionToRole(roleName, (Permission)permission, rolePermissions);
            }
        }
        iter = uncheckedPatterns.keySet().iterator();
        while (iter.hasNext()) {
            pattern = (URLPattern)uncheckedPatterns.get(iter.next());
            name = pattern.getQualifiedPattern(allSet);
            String actions = pattern.getMethods();
            this.addOrUpdatePattern(uncheckedResourcePatterns, name, actions);
        }
        iter = rolesPatterns.keySet().iterator();
        while (iter.hasNext()) {
            pattern = (URLPattern)rolesPatterns.get(iter.next());
            name = pattern.getQualifiedPattern(allSet);
            String actions = pattern.getMethodsWithTransport();
            this.addOrUpdatePattern(uncheckedUserPatterns, name, actions);
        }
        iter = uncheckedPatterns.keySet().iterator();
        while (iter.hasNext()) {
            pattern = (URLPattern)uncheckedPatterns.get(iter.next());
            name = pattern.getQualifiedPattern(allSet);
            String actions = pattern.getMethodsWithTransport();
            this.addOrUpdatePattern(uncheckedUserPatterns, name, actions);
        }
        iter = allSet.iterator();
        while (iter.hasNext()) {
            pattern = (URLPattern)iter.next();
            name = pattern.getQualifiedPattern(allSet);
            String actions = pattern.getComplementedMethods();
            if (actions.length() == 0) continue;
            this.addOrUpdatePattern(uncheckedResourcePatterns, name, actions);
            this.addOrUpdatePattern(uncheckedUserPatterns, name, actions);
        }
        pattern = new URLPattern("/");
        if (!allSet.contains(pattern)) {
            name = pattern.getQualifiedPattern(allSet);
            String actions = pattern.getComplementedMethods();
            this.addOrUpdatePattern(uncheckedResourcePatterns, name, actions);
            this.addOrUpdatePattern(uncheckedUserPatterns, name, actions);
        }
        iter = uncheckedResourcePatterns.keySet().iterator();
        while (iter.hasNext()) {
            item = (UncheckedItem)iter.next();
            String actions = (String)uncheckedResourcePatterns.get(item);
            ((PermissionCollection)uncheckedPermissions).add((Permission)new WebResourcePermission(item.getName(), actions));
        }
        iter = uncheckedUserPatterns.keySet().iterator();
        while (iter.hasNext()) {
            item = (UncheckedItem)iter.next();
            String actions = (String)uncheckedUserPatterns.get(item);
            ((PermissionCollection)uncheckedPermissions).add((Permission)new WebUserDataPermission(item.getName(), actions));
        }
        return new ComponentPermissions((PermissionCollection)excludedPermissions, (PermissionCollection)uncheckedPermissions, rolePermissions);
    }

    protected void addPermissionToRole(String roleName, Permission permission, Map rolePermissions) {
        PermissionCollection permissionsForRole = (PermissionCollection)rolePermissions.get(roleName);
        if (permissionsForRole == null) {
            permissionsForRole = new Permissions();
            rolePermissions.put(roleName, permissionsForRole);
        }
        permissionsForRole.add(permission);
    }

    private void addOrUpdatePattern(Map patternMap, String name, String actions) {
        UncheckedItem item = new UncheckedItem(name, actions);
        String existingActions = (String)patternMap.get(item);
        if (existingActions != null) {
            patternMap.put(item, actions + "," + existingActions);
            return;
        }
        patternMap.put(item, actions);
    }

    protected static Set collectRoleNames(WebAppType webApp) {
        HashSet<String> roleNames = new HashSet<String>();
        SecurityRoleType[] securityRoles = webApp.getSecurityRoleArray();
        for (int i = 0; i < securityRoles.length; ++i) {
            roleNames.add(securityRoles[i].getRoleName().getStringValue().trim());
        }
        return roleNames;
    }

    protected static void check(WebAppType webApp) throws DeploymentException {
        AbstractWebModuleBuilder.checkURLPattern(webApp);
        AbstractWebModuleBuilder.checkMultiplicities(webApp);
    }

    private static void checkURLPattern(WebAppType webApp) throws DeploymentException {
        FilterMappingType[] filterMappings = webApp.getFilterMappingArray();
        for (int i = 0; i < filterMappings.length; ++i) {
            if (!filterMappings[i].isSetUrlPattern()) continue;
            AbstractWebModuleBuilder.checkString(filterMappings[i].getUrlPattern().getStringValue().trim());
        }
        ServletMappingType[] servletMappings = webApp.getServletMappingArray();
        for (int i = 0; i < servletMappings.length; ++i) {
            AbstractWebModuleBuilder.checkString(servletMappings[i].getUrlPattern().getStringValue().trim());
        }
        SecurityConstraintType[] constraints = webApp.getSecurityConstraintArray();
        for (int i = 0; i < constraints.length; ++i) {
            WebResourceCollectionType[] collections = constraints[i].getWebResourceCollectionArray();
            for (int j = 0; j < collections.length; ++j) {
                UrlPatternType[] patterns = collections[j].getUrlPatternArray();
                for (int k = 0; k < patterns.length; ++k) {
                    AbstractWebModuleBuilder.checkString(patterns[k].getStringValue().trim());
                }
            }
        }
    }

    protected static void checkString(String pattern) throws DeploymentException {
        if (pattern.indexOf(13) >= 0) {
            throw new DeploymentException("<url-pattern> must not contain CR(#xD)");
        }
        if (pattern.indexOf(10) >= 0) {
            throw new DeploymentException("<url-pattern> must not contain LF(#xA)");
        }
    }

    private static void checkMultiplicities(WebAppType webApp) throws DeploymentException {
        if (webApp.getSessionConfigArray().length > 1) {
            throw new DeploymentException("Multiple <session-config> elements found");
        }
        if (webApp.getJspConfigArray().length > 1) {
            throw new DeploymentException("Multiple <jsp-config> elements found");
        }
        if (webApp.getLoginConfigArray().length > 1) {
            throw new DeploymentException("Multiple <login-config> elements found");
        }
    }

    private boolean cleanupConfigurationDir(File configurationDir) {
        LinkedList cannotBeDeletedList = new LinkedList();
        if (!DeploymentUtil.recursiveDelete((File)configurationDir, cannotBeDeletedList)) {
            log.warn((Object)("Unable to delete " + cannotBeDeletedList.size() + " files while recursively deleting directory " + configurationDir + LINE_SEP + "The first file that could not be deleted was:" + LINE_SEP + "  " + (!cannotBeDeletedList.isEmpty() ? cannotBeDeletedList.getFirst() : "")));
            return false;
        }
        return true;
    }

    protected void processRoleRefPermissions(ServletType servletType, Set securityRoles, Map rolePermissions) {
        String servletName = servletType.getServletName().getStringValue().trim();
        SecurityRoleRefType[] securityRoleRefTypeArray = servletType.getSecurityRoleRefArray();
        HashSet unmappedRoles = new HashSet(securityRoles);
        for (int j = 0; j < securityRoleRefTypeArray.length; ++j) {
            SecurityRoleRefType securityRoleRefType = securityRoleRefTypeArray[j];
            String roleName = securityRoleRefType.getRoleName().getStringValue().trim();
            String roleLink = securityRoleRefType.getRoleLink().getStringValue().trim();
            this.addPermissionToRole(roleLink, (Permission)new WebRoleRefPermission(servletName, roleName), rolePermissions);
            unmappedRoles.remove(roleName);
        }
        Iterator iterator = unmappedRoles.iterator();
        while (iterator.hasNext()) {
            String roleName = (String)iterator.next();
            this.addPermissionToRole(roleName, (Permission)new WebRoleRefPermission(servletName, roleName), rolePermissions);
        }
    }

    protected void buildSubstitutionGroups(XmlObject gerWebApp, boolean hasSecurityRealmName, Module module, EARContext earContext) throws DeploymentException {
        XmlObject[] securityElements = XmlBeansUtil.selectSubstitutionGroupElements((QName)SECURITY_QNAME, (XmlObject)gerWebApp);
        if (securityElements.length > 0 && !hasSecurityRealmName) {
            throw new DeploymentException("You have supplied a security configuration for web app " + module.getName() + " but no security-realm-name to allow login");
        }
        this.securityBuilders.build(gerWebApp, (DeploymentContext)earContext, (DeploymentContext)module.getEarContext());
        this.serviceBuilders.build(gerWebApp, (DeploymentContext)earContext, (DeploymentContext)module.getEarContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static WebAppDocument convertToServletSchema(XmlObject xmlObject) throws XmlException {
        block14: {
            if (WebAppDocument.type.equals(xmlObject.schemaType())) {
                XmlBeansUtil.validateDD((XmlObject)xmlObject);
                return (WebAppDocument)xmlObject;
            }
            XmlCursor cursor = xmlObject.newCursor();
            try {
                cursor.toStartDoc();
                cursor.toFirstChild();
                if ("http://java.sun.com/xml/ns/j2ee".equals(cursor.getName().getNamespaceURI())) {
                    XmlObject result = xmlObject.changeType(WebAppDocument.type);
                    XmlBeansUtil.validateDD((XmlObject)result);
                    WebAppDocument webAppDocument = (WebAppDocument)result;
                    return webAppDocument;
                }
                XmlDocumentProperties xmlDocumentProperties = cursor.documentProperties();
                String publicId = xmlDocumentProperties.getDoctypePublicId();
                if (!"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN".equals(publicId) && !"-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN".equals(publicId)) break block14;
                XmlCursor moveable = xmlObject.newCursor();
                try {
                    moveable.toStartDoc();
                    moveable.toFirstChild();
                    String schemaLocationURL = "http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd";
                    String version = "2.4";
                    SchemaConversionUtils.convertToSchema((XmlCursor)cursor, (String)"http://java.sun.com/xml/ns/j2ee", (String)schemaLocationURL, (String)version);
                    cursor.toStartDoc();
                    cursor.toChild("http://java.sun.com/xml/ns/j2ee", "web-app");
                    cursor.toFirstChild();
                    SchemaConversionUtils.convertToDescriptionGroup((String)"http://java.sun.com/xml/ns/j2ee", (XmlCursor)cursor, (XmlCursor)moveable);
                    SchemaConversionUtils.convertToJNDIEnvironmentRefsGroup((String)"http://java.sun.com/xml/ns/j2ee", (XmlCursor)cursor, (XmlCursor)moveable);
                    cursor.push();
                    if (cursor.toNextSibling(TAGLIB)) {
                        cursor.toPrevSibling();
                        moveable.toCursor(cursor);
                        cursor.beginElement("jsp-config", "http://java.sun.com/xml/ns/j2ee");
                        while (moveable.toNextSibling(TAGLIB)) {
                            moveable.moveXml(cursor);
                        }
                    }
                    cursor.pop();
                    do {
                        String name;
                        if (!"filter".equals(name = cursor.getName().getLocalPart()) && !"servlet".equals(name) && !"context-param".equals(name)) continue;
                        cursor.push();
                        cursor.toFirstChild();
                        SchemaConversionUtils.convertToDescriptionGroup((String)"http://java.sun.com/xml/ns/j2ee", (XmlCursor)cursor, (XmlCursor)moveable);
                        while (cursor.toNextSibling("http://java.sun.com/xml/ns/j2ee", "init-param")) {
                            cursor.push();
                            cursor.toFirstChild();
                            SchemaConversionUtils.convertToDescriptionGroup((String)"http://java.sun.com/xml/ns/j2ee", (XmlCursor)cursor, (XmlCursor)moveable);
                            cursor.pop();
                        }
                        cursor.pop();
                    } while (cursor.toNextSibling());
                }
                finally {
                    moveable.dispose();
                }
            }
            finally {
                cursor.dispose();
            }
        }
        XmlObject result = xmlObject.changeType(WebAppDocument.type);
        if (result != null) {
            XmlBeansUtil.validateDD((XmlObject)result);
            return (WebAppDocument)result;
        }
        XmlBeansUtil.validateDD((XmlObject)xmlObject);
        return (WebAppDocument)xmlObject;
    }

    static {
        SECURITY_QNAME = GerSecurityDocument.type.getDocumentElementName();
        SERVICE_QNAME = ServiceDocument.type.getDocumentElementName();
        RELATIVE_MODULE_BASE_URI = URI.create("../");
        MANAGED_CONNECTION_FACTORY_PATTERN = new AbstractNameQuery(null, Collections.singletonMap("j2eeType", "JCAManagedConnectionFactory"));
        ADMIN_OBJECT_PATTERN = new AbstractNameQuery(null, Collections.singletonMap("j2eeType", "JCAAdminObject"));
        STATELESS_SESSION_BEAN_PATTERN = new AbstractNameQuery(null, Collections.singletonMap("j2eeType", "StatelessSessionBean"));
        STATEFUL_SESSION_BEAN_PATTERN = new AbstractNameQuery(null, Collections.singletonMap("j2eeType", "StatefulSessionBean"));
        ENTITY_BEAN_PATTERN = new AbstractNameQuery(null, Collections.singletonMap("j2eeType", "EntityBean"));
    }

    class UncheckedItem {
        static final int NA = 0;
        static final int INTEGRAL = 1;
        static final int CONFIDENTIAL = 2;
        private int transportType = 0;
        private String name;

        public UncheckedItem(String name, String actions) {
            this.setName(name);
            this.setTransportType(actions);
        }

        public boolean equals(Object o) {
            UncheckedItem item = (UncheckedItem)o;
            return item.getKey().equals(this.getKey());
        }

        public String getKey() {
            return this.name + this.transportType;
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getTransportType() {
            return this.transportType;
        }

        public void setTransportType(String actions) {
            String[] tokens = actions.split(":", 2);
            if (tokens.length == 2) {
                if (tokens[1].equals("INTEGRAL")) {
                    this.transportType = 1;
                } else if (tokens[1].equals("CONFIDENTIAL")) {
                    this.transportType = 2;
                }
            }
        }
    }
}

