/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.utils;

import java.beans.PropertyEditorSupport;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.service.XmlAttributeBuilder;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.web.info.WebAppInfo;
import org.apache.geronimo.web25.deployment.DefaultWebAppInfoFactory;
import org.apache.geronimo.web25.deployment.WebAppInfoBuilder;
import org.apache.openejb.jee.JAXBContextFactory;
import org.apache.openejb.jee.WebApp;
import org.apache.xmlbeans.XmlObject;
import org.osgi.framework.Bundle;

@GBean(j2eeType="XmlAttributeBuilder")
public class WebAppXmlAttributeBuilder
extends PropertyEditorSupport
implements XmlAttributeBuilder {
    public String getNamespace() {
        return "http://java.sun.com/xml/ns/javaee";
    }

    public Object getValue(XmlObject xmlObject, XmlObject enclosing, String s, Bundle bundle) throws DeploymentException {
        try {
            XMLStreamReader reader = enclosing.newXMLStreamReader();
            while (reader.hasNext() && reader.next() != 1) {
            }
            if (s.endsWith("WebAppInfo")) {
                WebApp webApp = (WebApp)WebAppXmlAttributeBuilder.unmarshalJavaee(WebApp.class, reader);
                return new WebAppInfoBuilder(webApp, new DefaultWebAppInfoFactory()).build();
            }
            throw new DeploymentException("Unrecognized xml: " + enclosing.xmlText());
        }
        catch (XMLStreamException e) {
            throw new DeploymentException("xml problem", (Throwable)e);
        }
    }

    public static <T> Object unmarshalJavaee(Class<T> type, XMLStreamReader in) throws DeploymentException {
        try {
            JAXBContext ctx = JAXBContextFactory.newInstance((Class[])new Class[]{type});
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            unmarshaller.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent validationEvent) {
                    return false;
                }
            });
            JAXBElement element = unmarshaller.unmarshal(in, type);
            return element.getValue();
        }
        catch (JAXBException e) {
            throw new DeploymentException("parsing problem", (Throwable)e);
        }
    }

    @Override
    public void setAsText(String text) {
        try {
            JAXBContext ctx = JAXBContextFactory.newInstance((Class[])new Class[]{WebApp.class});
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            unmarshaller.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent validationEvent) {
                    return false;
                }
            });
            JAXBElement element = unmarshaller.unmarshal((Source)new StreamSource(new StringReader(text)), WebApp.class);
            WebAppInfo webAppInfo = new WebAppInfoBuilder((WebApp)element.getValue(), new DefaultWebAppInfoFactory()).build();
            this.setValue(webAppInfo);
        }
        catch (JAXBException e) {
            throw new RuntimeException("parsing problem", e);
        }
        catch (DeploymentException e) {
            throw new RuntimeException("conversion problem", e);
        }
    }
}

