/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;
import org.apache.openejb.jee.WelcomeFileList;

public class WelcomeFileListMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        WelcomeFileList targetWelcomeFileList = webApp.getWelcomeFileList().isEmpty() ? null : (WelcomeFileList)webApp.getWelcomeFileList().get(0);
        for (WelcomeFileList welcomeFileList : webFragment.getWelcomeFileList()) {
            for (String welcomeFile : welcomeFileList.getWelcomeFile()) {
                String welcomeFileKey = WelcomeFileListMergeHandler.createWelcomeFileKey(welcomeFile);
                if (mergeContext.containsAttribute(welcomeFileKey)) continue;
                if (targetWelcomeFileList == null) {
                    targetWelcomeFileList = new WelcomeFileList();
                    webApp.getWelcomeFileList().add(targetWelcomeFileList);
                }
                targetWelcomeFileList.getWelcomeFile().add(welcomeFile);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp parentElement, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
        WelcomeFileList welcomeFileList = null;
        for (WelcomeFileList list : webApp.getWelcomeFileList()) {
            if (welcomeFileList == null) {
                welcomeFileList = list;
                continue;
            }
            welcomeFileList.getWelcomeFile().addAll(list.getWelcomeFile());
        }
        webApp.getWelcomeFileList();
        if (welcomeFileList != null) {
            for (String welcomeFile : welcomeFileList.getWelcomeFile()) {
                context.setAttribute(WelcomeFileListMergeHandler.createWelcomeFileKey(welcomeFile), Boolean.TRUE);
            }
        }
    }

    public static String createWelcomeFileKey(String welcomeFile) {
        return "welcome-file-list.welcome-file." + welcomeFile;
    }

    public static boolean isWelcomeFileConfigured(String welcomeFile, MergeContext mergeContext) {
        return mergeContext.containsAttribute(WelcomeFileListMergeHandler.createWelcomeFileKey(welcomeFile));
    }
}

