/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.SubMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.openejb.jee.ParamValue;
import org.apache.openejb.jee.Servlet;
import org.apache.openejb.jee.WebApp;

public class ServletInitParamMergeHandler
implements SubMergeHandler<Servlet, Servlet> {
    @Override
    public void add(Servlet servlet, MergeContext mergeContext) throws DeploymentException {
        String servletName = servlet.getServletName();
        for (ParamValue paramValue : servlet.getInitParam()) {
            ServletInitParamMergeHandler.addServletInitParam(servletName, paramValue, ElementSource.WEB_FRAGMENT, mergeContext.getCurrentJarUrl(), mergeContext);
        }
    }

    @Override
    public void merge(Servlet srcServlet, Servlet targetServlet, MergeContext mergeContext) throws DeploymentException {
        String servletName = srcServlet.getServletName();
        for (ParamValue paramValue : srcServlet.getInitParam()) {
            MergeItem existedMergeItem = (MergeItem)mergeContext.getAttribute(ServletInitParamMergeHandler.createServletInitParamKey(servletName, paramValue.getParamName()));
            if (existedMergeItem == null) {
                targetServlet.getInitParam().add(paramValue);
                ServletInitParamMergeHandler.addServletInitParam(servletName, paramValue, ElementSource.WEB_FRAGMENT, mergeContext.getCurrentJarUrl(), mergeContext);
            } else {
                ParamValue existedParamValue = (ParamValue)existedMergeItem.getValue();
                switch (existedMergeItem.getSourceType()) {
                    case WEB_XML: {
                        break;
                    }
                    case WEB_FRAGMENT: {
                        if (existedParamValue.getParamValue().equals(paramValue.getParamValue()) || existedMergeItem.getBelongedURL().equals(mergeContext.getCurrentJarUrl())) break;
                        throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateKeyValueMessage("servlet " + servletName, "param-name", paramValue.getParamName(), "param-value", existedParamValue.getParamValue(), existedMergeItem.getBelongedURL(), paramValue.getParamValue(), mergeContext.getCurrentJarUrl()));
                    }
                    case ANNOTATION: {
                        existedParamValue.setParamValue(paramValue.getParamValue());
                        existedMergeItem.setBelongedURL(mergeContext.getCurrentJarUrl());
                        existedMergeItem.setSourceType(ElementSource.WEB_FRAGMENT);
                    }
                }
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
        for (Servlet servlet : webApp.getServlet()) {
            String servletName = servlet.getServletName();
            for (ParamValue paramValue : servlet.getInitParam()) {
                ServletInitParamMergeHandler.addServletInitParam(servletName, paramValue, ElementSource.WEB_XML, null, context);
            }
        }
    }

    public static String createServletInitParamKey(String servletName, String paramName) {
        return "servlet." + servletName + ".init-param.param-name." + paramName;
    }

    public static boolean isServletInitParamConfigured(String servletName, String paramName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(ServletInitParamMergeHandler.createServletInitParamKey(servletName, paramName));
    }

    public static void addServletInitParam(String servletName, ParamValue paramValue, ElementSource source, String relativeUrl, MergeContext mergeContext) {
        mergeContext.setAttribute(ServletInitParamMergeHandler.createServletInitParamKey(servletName, paramValue.getParamName()), new MergeItem(paramValue, relativeUrl, source));
    }
}

