/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.SubMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentValidationUtils;
import org.apache.openejb.jee.FilterMapping;
import org.apache.openejb.jee.WebApp;

public class FilterMappingUrlPatternMergeHandler
implements SubMergeHandler<FilterMapping, FilterMapping> {
    @Override
    public void add(FilterMapping filterMapping, MergeContext mergeContext) throws DeploymentException {
        String filterName = filterMapping.getFilterName();
        for (String urlPattern : filterMapping.getUrlPattern()) {
            if (!WebDeploymentValidationUtils.isValidUrlPattern(urlPattern)) {
                throw new DeploymentException(WebDeploymentMessageUtils.createInvalidUrlPatternErrorMessage("filter-mapping", filterName, urlPattern, "web-fragment.xml located in " + mergeContext.getCurrentJarUrl()));
            }
            mergeContext.setAttribute(FilterMappingUrlPatternMergeHandler.createFilterMappingUrlPatternKey(filterName, urlPattern), urlPattern);
        }
    }

    @Override
    public void merge(FilterMapping srcFilterMapping, FilterMapping targetFilterMapping, MergeContext mergeContext) throws DeploymentException {
        String filterName = srcFilterMapping.getFilterName();
        for (String urlPattern : srcFilterMapping.getUrlPattern()) {
            String filterMappingUrlPatternKey = FilterMappingUrlPatternMergeHandler.createFilterMappingUrlPatternKey(filterName, urlPattern);
            if (mergeContext.containsAttribute(filterMappingUrlPatternKey)) continue;
            targetFilterMapping.getUrlPattern().add(urlPattern);
            if (!WebDeploymentValidationUtils.isValidUrlPattern(urlPattern)) {
                throw new DeploymentException(WebDeploymentMessageUtils.createInvalidUrlPatternErrorMessage("filter-mapping", filterName, urlPattern, "web-fragment.xml located in " + mergeContext.getCurrentJarUrl()));
            }
            mergeContext.setAttribute(filterMappingUrlPatternKey, urlPattern);
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
        for (FilterMapping filterMapping : webApp.getFilterMapping()) {
            String filterName = filterMapping.getFilterName();
            for (String urlPattern : filterMapping.getUrlPattern()) {
                if (!WebDeploymentValidationUtils.isValidUrlPattern(urlPattern)) {
                    throw new DeploymentException(WebDeploymentMessageUtils.createInvalidUrlPatternErrorMessage("filter-mapping", filterName, urlPattern, "web.xml"));
                }
                context.setAttribute(FilterMappingUrlPatternMergeHandler.createFilterMappingUrlPatternKey(filterName, urlPattern), urlPattern);
            }
        }
    }

    public static String createFilterMappingUrlPatternKey(String filterName, String urlPattern) {
        return "filter-mapping.filter-name." + filterName + ".url-pattern." + urlPattern;
    }
}

