/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.SubMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.openejb.jee.Filter;
import org.apache.openejb.jee.ParamValue;
import org.apache.openejb.jee.WebApp;

public class FilterInitParamMergeHandler
implements SubMergeHandler<Filter, Filter> {
    @Override
    public void add(Filter servlet, MergeContext mergeContext) throws DeploymentException {
        String servletName = servlet.getFilterName();
        for (ParamValue paramValue : servlet.getInitParam()) {
            FilterInitParamMergeHandler.addFilterInitParam(servletName, paramValue, ElementSource.WEB_FRAGMENT, mergeContext.getCurrentJarUrl(), mergeContext);
        }
    }

    @Override
    public void merge(Filter srcFilter, Filter targetFilter, MergeContext mergeContext) throws DeploymentException {
        String filterName = srcFilter.getFilterName();
        for (ParamValue paramValue : srcFilter.getInitParam()) {
            MergeItem existedMergeItem = (MergeItem)mergeContext.getAttribute(FilterInitParamMergeHandler.createFilterInitParamKey(filterName, paramValue.getParamName()));
            if (existedMergeItem == null) {
                targetFilter.getInitParam().add(paramValue);
                FilterInitParamMergeHandler.addFilterInitParam(filterName, paramValue, ElementSource.WEB_FRAGMENT, mergeContext.getCurrentJarUrl(), mergeContext);
            } else {
                ParamValue existedParamValue = (ParamValue)existedMergeItem.getValue();
                switch (existedMergeItem.getSourceType()) {
                    case WEB_XML: {
                        break;
                    }
                    case WEB_FRAGMENT: {
                        if (existedParamValue.getParamValue().equals(paramValue.getParamValue()) || existedMergeItem.getBelongedURL().equals(mergeContext.getCurrentJarUrl())) break;
                        throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateKeyValueMessage("filter " + filterName, "param-name", paramValue.getParamName(), "param-value", existedParamValue.getParamValue(), existedMergeItem.getBelongedURL(), paramValue.getParamValue(), mergeContext.getCurrentJarUrl()));
                    }
                    case ANNOTATION: {
                        existedParamValue.setParamValue(paramValue.getParamValue());
                        existedMergeItem.setBelongedURL(mergeContext.getCurrentJarUrl());
                        existedMergeItem.setSourceType(ElementSource.WEB_FRAGMENT);
                    }
                }
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
        for (Filter filter : webApp.getFilter()) {
            String filterName = filter.getFilterName();
            for (ParamValue paramValue : filter.getInitParam()) {
                FilterInitParamMergeHandler.addFilterInitParam(filterName, paramValue, ElementSource.WEB_XML, null, context);
            }
        }
    }

    public static String createFilterInitParamKey(String filterName, String paramName) {
        return "filter." + filterName + ".init-param.param-name." + paramName;
    }

    public static boolean isFilterInitParamConfigured(String filterName, String paramName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(FilterInitParamMergeHandler.createFilterInitParamKey(filterName, paramName));
    }

    public static void addFilterInitParam(String filterName, ParamValue paramValue, ElementSource source, String relativeUrl, MergeContext mergeContext) {
        mergeContext.setAttribute(FilterInitParamMergeHandler.createFilterInitParamKey(filterName, paramValue.getParamName()), new MergeItem(paramValue, relativeUrl, source));
    }
}

