/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.ResourceEnvRef;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;

public class ResourceEnvRefMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    public static final String RESOURCE_ENV_REF_NAME_PREFIX = "resource-env-ref.resource-env-ref-name.";

    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (ResourceEnvRef srcResourceEnvRef : webFragment.getResourceEnvRef()) {
            String resourceEnvRefName = srcResourceEnvRef.getResourceEnvRefName();
            String resourceEnvRefKey = ResourceEnvRefMergeHandler.createResourceEnvRefKey(resourceEnvRefName);
            MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(resourceEnvRefKey);
            if (mergeItem != null) {
                if (mergeItem.isFromWebFragment()) {
                    throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateJNDIRefMessage("resource-env-ref", resourceEnvRefName, mergeItem.getBelongedURL(), mergeContext.getCurrentJarUrl()));
                }
                if (!mergeItem.isFromWebXml() || ResourceEnvRefMergeHandler.isResourceEnvRefInjectTargetsConfiguredInInitialWebXML(resourceEnvRefName, mergeContext)) continue;
                ResourceEnvRef resourceEnvRef = (ResourceEnvRef)mergeItem.getValue();
                for (InjectionTarget injectTarget : srcResourceEnvRef.getInjectionTarget()) {
                    String resourceEnvRefInjectTargetKey = ResourceEnvRefMergeHandler.createResourceEnvRefInjectTargetKey(resourceEnvRefName, injectTarget.getInjectionTargetClass(), injectTarget.getInjectionTargetName());
                    if (mergeContext.containsAttribute(resourceEnvRefInjectTargetKey)) continue;
                    resourceEnvRef.getInjectionTarget().add(injectTarget);
                    mergeContext.setAttribute(resourceEnvRefInjectTargetKey, Boolean.TRUE);
                }
                continue;
            }
            webApp.getResourceEnvRef().add(srcResourceEnvRef);
            mergeContext.setAttribute(resourceEnvRefKey, new MergeItem(srcResourceEnvRef, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
            for (InjectionTarget injectionTarget : srcResourceEnvRef.getInjectionTarget()) {
                mergeContext.setAttribute(ResourceEnvRefMergeHandler.createResourceEnvRefInjectTargetKey(resourceEnvRefName, injectionTarget.getInjectionTargetClass(), injectionTarget.getInjectionTargetName()), Boolean.TRUE);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (ResourceEnvRef resourceEnvRef : webApp.getResourceEnvRef()) {
            String resourceEnvRefName = resourceEnvRef.getResourceEnvRefName();
            mergeContext.setAttribute(ResourceEnvRefMergeHandler.createResourceEnvRefKey(resourceEnvRefName), new MergeItem(resourceEnvRef, null, ElementSource.WEB_XML));
            if (!resourceEnvRef.getInjectionTarget().isEmpty()) {
                mergeContext.setAttribute(ResourceEnvRefMergeHandler.createResourceEnvRefInjectTargetConfiguredInWebXMLKey(resourceEnvRefName), Boolean.TRUE);
            }
            for (InjectionTarget injectionTarget : resourceEnvRef.getInjectionTarget()) {
                mergeContext.setAttribute(ResourceEnvRefMergeHandler.createResourceEnvRefInjectTargetKey(resourceEnvRefName, injectionTarget.getInjectionTargetClass(), injectionTarget.getInjectionTargetName()), Boolean.TRUE);
            }
        }
    }

    public static String createResourceEnvRefInjectTargetConfiguredInWebXMLKey(String resourceEnvRefName) {
        return RESOURCE_ENV_REF_NAME_PREFIX + resourceEnvRefName + ".inject_target_configured_in_web_xml";
    }

    public static String createResourceEnvRefInjectTargetKey(String resourceEnvRefName, String injectTargetClassName, String injectTargetName) {
        return RESOURCE_ENV_REF_NAME_PREFIX + resourceEnvRefName + "." + injectTargetClassName + "." + injectTargetName;
    }

    public static String createResourceEnvRefKey(String resourceEnvRefName) {
        return RESOURCE_ENV_REF_NAME_PREFIX + resourceEnvRefName;
    }

    public static boolean isResourceEnvRefInjectTargetConfigured(String resourceEnvRefName, String injectTargetClassName, String injectTargetName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(ResourceEnvRefMergeHandler.createResourceEnvRefInjectTargetKey(resourceEnvRefName, injectTargetClassName, injectTargetName));
    }

    public static boolean isResourceEnvRefInjectTargetsConfiguredInInitialWebXML(String resourceEnvRefName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(ResourceEnvRefMergeHandler.createResourceEnvRefInjectTargetConfiguredInWebXMLKey(resourceEnvRefName));
    }
}

