/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.openejb.jee.MimeMapping;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;

public class MimeMappingMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (MimeMapping mimeMapping : webFragment.getMimeMapping()) {
            String extension = mimeMapping.getExtension();
            if (MimeMappingMergeHandler.isMimeMappingConfiguredInWebXML(extension, mergeContext)) continue;
            String jarUrl = mergeContext.getCurrentJarUrl();
            String qualifedMimeMappingName = MimeMappingMergeHandler.createMimeMappingConfiguredInWebFragmentXMLKey(extension);
            MergeItem existedMimeMapping = (MergeItem)mergeContext.getAttribute(qualifedMimeMappingName);
            if (existedMimeMapping == null) {
                mergeContext.setAttribute(qualifedMimeMappingName, new MergeItem(mimeMapping.getMimeType(), jarUrl, ElementSource.WEB_FRAGMENT));
                webApp.getMimeMapping().add(mimeMapping);
                continue;
            }
            if (mimeMapping.getMimeType().equals(existedMimeMapping.getValue())) continue;
            throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateKeyValueMessage("mime-mapping", "extension", extension, "mime-type", (String)existedMimeMapping.getValue(), existedMimeMapping.getBelongedURL(), mimeMapping.getMimeType(), jarUrl));
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
        for (MimeMapping mimeMapping : webApp.getMimeMapping()) {
            context.setAttribute(MimeMappingMergeHandler.createMimeMappingConfiguredInWebXMLKey(mimeMapping.getExtension()), Boolean.TRUE);
        }
    }

    public static String createMimeMappingConfiguredInWebFragmentXMLKey(String extension) {
        return "mime-mapping.extension." + extension + ".configured_in_web_fragment_xml";
    }

    public static String createMimeMappingConfiguredInWebXMLKey(String extension) {
        return "mime-mapping.extension." + extension + ".configured_in_web_xml";
    }

    public static boolean isMimeMappingConfiguredInWebFragmentXML(String extension, MergeContext mergeContext) {
        return mergeContext.containsAttribute(MimeMappingMergeHandler.createMimeMappingConfiguredInWebFragmentXMLKey(extension));
    }

    public static boolean isMimeMappingConfiguredInWebXML(String extension, MergeContext mergeContext) {
        return mergeContext.containsAttribute(MimeMappingMergeHandler.createMimeMappingConfiguredInWebXMLKey(extension));
    }
}

