/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.openejb.jee.MessageDestination;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;

public class MessageDestinationMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (MessageDestination messageDestination : webApp.getMessageDestination()) {
            String messageDestinationName = messageDestination.getMessageDestinationName();
            if (mergeContext.containsAttribute(MessageDestinationMergeHandler.createMessageDestinationConfiguredInWebXMLKey(messageDestination.getMessageDestinationName()))) continue;
            if (mergeContext.containsAttribute(MessageDestinationMergeHandler.createMessageDestinationConfiguredInWebFragmentXMLKey(messageDestinationName))) {
                MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(MessageDestinationMergeHandler.createMessageDestinationConfiguredInWebFragmentXMLKey(messageDestinationName));
                throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateJNDIRefMessage("message-destination", messageDestinationName, mergeItem.getBelongedURL(), mergeContext.getCurrentJarUrl()));
            }
            webApp.getMessageDestination().add(messageDestination);
            mergeContext.setAttribute(MessageDestinationMergeHandler.createMessageDestinationConfiguredInWebFragmentXMLKey(messageDestinationName), new MergeItem(messageDestination, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
        for (MessageDestination messageDestination : webApp.getMessageDestination()) {
            context.setAttribute(MessageDestinationMergeHandler.createMessageDestinationConfiguredInWebXMLKey(messageDestination.getMessageDestinationName()), Boolean.TRUE);
        }
    }

    public static String createMessageDestinationConfiguredInWebFragmentXMLKey(String messageDestinationName) {
        return "message-destination.message-destination-name." + messageDestinationName + ".configured_in_web_fragment_xml";
    }

    public static String createMessageDestinationConfiguredInWebXMLKey(String messageDestinationName) {
        return "message-destination.message-destination-name." + messageDestinationName + ".configured_in_web_xml";
    }
}

