/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.openejb.jee.LocaleEncodingMapping;
import org.apache.openejb.jee.LocaleEncodingMappingList;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;

public class LocaleEncodingMappingListMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        LocaleEncodingMappingList targetLocaleEncodingMappingList = webApp.getLocaleEncodingMappingList().isEmpty() ? null : (LocaleEncodingMappingList)webApp.getLocaleEncodingMappingList().get(0);
        for (LocaleEncodingMappingList localeEncodingMappingList : webFragment.getLocaleEncodingMappingList()) {
            for (LocaleEncodingMapping localeEncodingMapping : localeEncodingMappingList.getLocaleEncodingMapping()) {
                String localeEncodingMappingKey = LocaleEncodingMappingListMergeHandler.createLocaleEncodingMappingKey(localeEncodingMapping.getLocale());
                MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(localeEncodingMappingKey);
                if (mergeItem != null && mergeItem.isFromWebFragment() && !mergeItem.getValue().equals(localeEncodingMapping.getEncoding())) {
                    throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateKeyValueMessage("locale-encoding-mapping", "locale", localeEncodingMapping.getLocale(), "encoding", (String)mergeItem.getValue(), mergeItem.getBelongedURL(), localeEncodingMapping.getLocale(), mergeContext.getCurrentJarUrl()));
                }
                if (targetLocaleEncodingMappingList == null) {
                    targetLocaleEncodingMappingList = new LocaleEncodingMappingList();
                    webApp.getLocaleEncodingMappingList().add(targetLocaleEncodingMappingList);
                }
                targetLocaleEncodingMappingList.getLocaleEncodingMapping().add(localeEncodingMapping);
                mergeContext.setAttribute(localeEncodingMappingKey, new MergeItem(localeEncodingMapping.getEncoding(), mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
        LocaleEncodingMappingList targetLocaleEncodingMappingList = null;
        for (LocaleEncodingMappingList list : webApp.getLocaleEncodingMappingList()) {
            if (targetLocaleEncodingMappingList == null) {
                targetLocaleEncodingMappingList = list;
                continue;
            }
            targetLocaleEncodingMappingList.getLocaleEncodingMapping().addAll(list.getLocaleEncodingMapping());
        }
        if (targetLocaleEncodingMappingList != null) {
            webApp.getLocaleEncodingMappingList().clear();
            webApp.getLocaleEncodingMappingList().add(targetLocaleEncodingMappingList);
            for (LocaleEncodingMapping localeEncodingMapping : targetLocaleEncodingMappingList.getLocaleEncodingMapping()) {
                context.setAttribute(LocaleEncodingMappingListMergeHandler.createLocaleEncodingMappingKey(localeEncodingMapping.getLocale()), new MergeItem(localeEncodingMapping.getEncoding(), null, ElementSource.WEB_XML));
            }
        }
    }

    public static String createLocaleEncodingMappingKey(String locale) {
        return "locale-encoding-mapping-list.locale-encoding-mapping.locale." + locale;
    }
}

