/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.SubMergeHandler;
import org.apache.openejb.jee.Dispatcher;
import org.apache.openejb.jee.FilterMapping;
import org.apache.openejb.jee.WebApp;

public class FilterMappingDispatcherMergeHandler
implements SubMergeHandler<FilterMapping, FilterMapping> {
    @Override
    public void add(FilterMapping filterMapping, MergeContext mergeContext) throws DeploymentException {
        String filterName = filterMapping.getFilterName();
        for (Dispatcher dispatcher : filterMapping.getDispatcher()) {
            mergeContext.setAttribute(FilterMappingDispatcherMergeHandler.createFilterMappingDispatcherKey(filterName, dispatcher, mergeContext), Boolean.TRUE);
        }
    }

    @Override
    public void merge(FilterMapping srcFilterMapping, FilterMapping targetFilterMapping, MergeContext mergeContext) throws DeploymentException {
        String filterName = srcFilterMapping.getFilterName();
        for (Dispatcher dispatcher : srcFilterMapping.getDispatcher()) {
            if (FilterMappingDispatcherMergeHandler.isFilterMappingDispatcherConfigured(filterName, dispatcher, mergeContext)) continue;
            mergeContext.setAttribute(FilterMappingDispatcherMergeHandler.createFilterMappingDispatcherKey(filterName, dispatcher, mergeContext), Boolean.TRUE);
            targetFilterMapping.getDispatcher().add(dispatcher);
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
        for (FilterMapping filterMapping : webApp.getFilterMapping()) {
            String filterName = filterMapping.getFilterName();
            for (Dispatcher dispatcher : filterMapping.getDispatcher()) {
                context.setAttribute(FilterMappingDispatcherMergeHandler.createFilterMappingDispatcherKey(filterName, dispatcher, context), Boolean.TRUE);
            }
        }
    }

    public static String createFilterMappingDispatcherKey(String filterName, Dispatcher dispatcherValue, MergeContext mergeContext) {
        return "filter-mapping.filter-name." + filterName + ".dispatcher." + dispatcherValue;
    }

    public static boolean isFilterMappingDispatcherConfigured(String filterName, Dispatcher dispatcherValue, MergeContext mergeContext) {
        return mergeContext.containsAttribute(FilterMappingDispatcherMergeHandler.createFilterMappingDispatcherKey(filterName, dispatcherValue, mergeContext));
    }
}

