/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.openejb.jee.ErrorPage;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;

public class ErrorPageMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (ErrorPage errorPage : webFragment.getErrorPage()) {
            MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(ErrorPageMergeHandler.createErrorPageKey(errorPage));
            if (mergeItem != null) {
                if (mergeItem.getSourceType().equals((Object)ElementSource.WEB_XML) || !mergeItem.getValue().equals(errorPage.getLocation())) continue;
                boolean isErrorCodeConfigured = errorPage.getErrorCode() != null;
                throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateKeyValueMessage("error-page", isErrorCodeConfigured ? "error-code" : "exception-type", isErrorCodeConfigured ? "" + errorPage.getErrorCode() : errorPage.getExceptionType(), "location", (String)mergeItem.getValue(), mergeItem.getBelongedURL(), errorPage.getLocation(), mergeContext.getCurrentJarUrl()));
            }
            webApp.getErrorPage().add(errorPage);
            mergeContext.setAttribute(ErrorPageMergeHandler.createErrorPageKey(errorPage), new MergeItem(errorPage.getLocation(), mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
        for (ErrorPage errorPage : webApp.getErrorPage()) {
            context.setAttribute(ErrorPageMergeHandler.createErrorPageKey(errorPage), new MergeItem(errorPage.getLocation(), null, ElementSource.WEB_XML));
        }
    }

    public static final String createErrorCodeKey(String errorCode) {
        return "error-page.error-code." + errorCode;
    }

    public static final String createExceptionTypeKey(String exceptionType) {
        return "error-page.exception-type." + exceptionType;
    }

    public static final String createErrorPageKey(ErrorPage errorPage) {
        return errorPage.getErrorCode() == null ? ErrorPageMergeHandler.createExceptionTypeKey(errorPage.getExceptionType()) : ErrorPageMergeHandler.createErrorCodeKey("" + errorPage.getErrorCode());
    }
}

