/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.openejb.jee.Empty;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;

public class DistributableMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    public static final String APPLICATION_DISTRIBUTABLE_VALUE = "distributable";

    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        boolean currentMergedDistributableValue = (Boolean)mergeContext.getAttribute(APPLICATION_DISTRIBUTABLE_VALUE);
        if (currentMergedDistributableValue) {
            mergeContext.setAttribute(APPLICATION_DISTRIBUTABLE_VALUE, webFragment.getDistributable().size() > 0);
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        boolean distributableInWebXml;
        boolean currentMergedDistributableValue = (Boolean)mergeContext.getAttribute(APPLICATION_DISTRIBUTABLE_VALUE);
        boolean bl = distributableInWebXml = webApp.getDistributable().size() > 0;
        if (currentMergedDistributableValue) {
            if (!distributableInWebXml) {
                webApp.getDistributable().add(new Empty());
            }
        } else if (distributableInWebXml) {
            int iLoopSize = webApp.getDistributable().size();
            for (int i = 0; i < iLoopSize; ++i) {
                webApp.getDistributable().clear();
            }
        }
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
        context.setAttribute(APPLICATION_DISTRIBUTABLE_VALUE, webApp.getDistributable().size() > 0);
    }
}

