/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ClassPathList;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.ModuleList;
import org.apache.geronimo.deployment.NamespaceDrivenBuilderCollection;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.deployment.xbeans.ServiceDocument;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.ModuleBuilderExtension;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.j2ee.deployment.WebServiceBuilder;
import org.apache.geronimo.j2ee.deployment.annotation.SecurityAnnotationHelper;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.ImportType;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentSetter;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.geronimo.security.util.HTTPMethods;
import org.apache.geronimo.security.util.URLPattern;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerSecurityDocument;
import org.apache.geronimo.xbeans.javaee.FilterMappingType;
import org.apache.geronimo.xbeans.javaee.FilterType;
import org.apache.geronimo.xbeans.javaee.FullyQualifiedClassType;
import org.apache.geronimo.xbeans.javaee.ListenerType;
import org.apache.geronimo.xbeans.javaee.RoleNameType;
import org.apache.geronimo.xbeans.javaee.SecurityConstraintType;
import org.apache.geronimo.xbeans.javaee.SecurityRoleRefType;
import org.apache.geronimo.xbeans.javaee.SecurityRoleType;
import org.apache.geronimo.xbeans.javaee.ServletMappingType;
import org.apache.geronimo.xbeans.javaee.ServletType;
import org.apache.geronimo.xbeans.javaee.UrlPatternType;
import org.apache.geronimo.xbeans.javaee.WebAppDocument;
import org.apache.geronimo.xbeans.javaee.WebAppType;
import org.apache.geronimo.xbeans.javaee.WebResourceCollectionType;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlDocumentProperties;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWebModuleBuilder
implements ModuleBuilder {
    private static final Log log = LogFactory.getLog(AbstractWebModuleBuilder.class);
    private static final QName TAGLIB = new QName("http://java.sun.com/xml/ns/javaee", "taglib");
    private static final String LINE_SEP = System.getProperty("line.separator");
    protected static final AbstractNameQuery MANAGED_CONNECTION_FACTORY_PATTERN;
    private static final AbstractNameQuery ADMIN_OBJECT_PATTERN;
    protected static final AbstractNameQuery STATELESS_SESSION_BEAN_PATTERN;
    protected static final AbstractNameQuery STATEFUL_SESSION_BEAN_PATTERN;
    protected static final AbstractNameQuery ENTITY_BEAN_PATTERN;
    protected final Kernel kernel;
    protected final NamespaceDrivenBuilderCollection securityBuilders;
    protected final NamespaceDrivenBuilderCollection serviceBuilders;
    protected final ResourceEnvironmentSetter resourceEnvironmentSetter;
    protected final Collection<WebServiceBuilder> webServiceBuilder;
    protected final NamingBuilder namingBuilders;
    protected final Collection<ModuleBuilderExtension> moduleBuilderExtensions;
    private static final QName SECURITY_QNAME;
    private static final QName SERVICE_QNAME;
    private static final URI RELATIVE_MODULE_BASE_URI;

    protected AbstractWebModuleBuilder(Kernel kernel, Collection securityBuilders, Collection serviceBuilders, NamingBuilder namingBuilders, ResourceEnvironmentSetter resourceEnvironmentSetter, Collection<WebServiceBuilder> webServiceBuilder, Collection<ModuleBuilderExtension> moduleBuilderExtensions) {
        this.kernel = kernel;
        this.securityBuilders = new NamespaceDrivenBuilderCollection(securityBuilders, SECURITY_QNAME);
        this.serviceBuilders = new NamespaceDrivenBuilderCollection(serviceBuilders, SERVICE_QNAME);
        this.namingBuilders = namingBuilders;
        this.resourceEnvironmentSetter = resourceEnvironmentSetter;
        this.webServiceBuilder = webServiceBuilder;
        this.moduleBuilderExtensions = moduleBuilderExtensions == null ? new ArrayList() : moduleBuilderExtensions;
    }

    public NamingBuilder getNamingBuilders() {
        return this.namingBuilders;
    }

    protected void addGBeanDependencies(EARContext earContext, GBeanData webModuleData) {
        Configuration earConfiguration = earContext.getConfiguration();
        this.addDependencies(earContext.findGBeanDatas(earConfiguration, MANAGED_CONNECTION_FACTORY_PATTERN), webModuleData);
        this.addDependencies(earContext.findGBeanDatas(earConfiguration, ADMIN_OBJECT_PATTERN), webModuleData);
        this.addDependencies(earContext.findGBeanDatas(earConfiguration, STATELESS_SESSION_BEAN_PATTERN), webModuleData);
        this.addDependencies(earContext.findGBeanDatas(earConfiguration, STATEFUL_SESSION_BEAN_PATTERN), webModuleData);
        this.addDependencies(earContext.findGBeanDatas(earConfiguration, ENTITY_BEAN_PATTERN), webModuleData);
    }

    private void addDependencies(LinkedHashSet<GBeanData> dependencies, GBeanData webModuleData) {
        for (GBeanData dependency : dependencies) {
            AbstractName dependencyName = dependency.getAbstractName();
            webModuleData.addDependency(dependencyName);
        }
    }

    public Module createModule(File plan, JarFile moduleFile, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        return this.createModule((Object)plan, moduleFile, ".", null, true, null, null, naming, idBuilder);
    }

    public Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment environment, Object moduleContextInfo, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        return this.createModule(plan, moduleFile, targetPath, specDDUrl, false, (String)moduleContextInfo, earName, naming, idBuilder);
    }

    protected abstract Module createModule(Object var1, JarFile var2, String var3, URL var4, boolean var5, String var6, AbstractName var7, Naming var8, ModuleIDBuilder var9) throws DeploymentException;

    protected Map<String, String> buildServletNameToPathMap(WebAppType webApp, String contextRoot) {
        ServletMappingType[] servletMappings;
        if (contextRoot == null) {
            contextRoot = "";
        } else if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (ServletMappingType servletMapping : servletMappings = webApp.getServletMappingArray()) {
            String servletName = servletMapping.getServletName().getStringValue().trim();
            UrlPatternType[] urlPatterns = servletMapping.getUrlPatternArray();
            for (int i = 0; urlPatterns != null && i < urlPatterns.length; ++i) {
                map.put(servletName, contextRoot + urlPatterns[i].getStringValue().trim());
            }
        }
        return map;
    }

    protected String determineDefaultContextRoot(WebAppType webApp, boolean isStandAlone, JarFile moduleFile, String targetPath) {
        if (webApp != null && webApp.getId() != null) {
            return webApp.getId();
        }
        if (isStandAlone) {
            return "/" + this.trimPath(new File(moduleFile.getName()).getName());
        }
        return this.trimPath(targetPath);
    }

    private String trimPath(String path) {
        if (path == null) {
            return null;
        }
        if (path.endsWith(".war")) {
            path = path.substring(0, path.length() - 4);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module, Collection configurationStores, ConfigurationStore targetConfigurationStore, Collection repositories) throws DeploymentException {
        EARContext moduleContext;
        if (module.isStandAlone()) {
            moduleContext = earContext;
        } else {
            Environment environment = module.getEnvironment();
            Artifact earConfigId = earContext.getConfigID();
            Artifact configId = new Artifact(earConfigId.getGroupId(), earConfigId.getArtifactId() + "_" + module.getTargetPath(), earConfigId.getVersion(), "car");
            environment.setConfigId(configId);
            environment.addDependency(earConfigId, ImportType.ALL);
            File configurationDir = new File(earContext.getBaseDir(), module.getTargetPath());
            configurationDir.mkdirs();
            try {
                File inPlaceConfigurationDir = null;
                if (null != earContext.getInPlaceConfigurationDir()) {
                    inPlaceConfigurationDir = new File(earContext.getInPlaceConfigurationDir(), module.getTargetPath());
                }
                moduleContext = new EARContext(configurationDir, inPlaceConfigurationDir, environment, ConfigurationModuleType.WAR, module.getModuleName(), earContext);
            }
            catch (DeploymentException e) {
                this.cleanupConfigurationDir(configurationDir);
                throw e;
            }
        }
        module.setEarContext(moduleContext);
        module.setRootEarContext(earContext);
        try {
            ClassPathList manifestcp = new ClassPathList();
            JarFile warFile = module.getModuleFile();
            Enumeration<JarEntry> entries = warFile.entries();
            ArrayList<ZipEntry> libs = new ArrayList<ZipEntry>();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                URI targetPath = new URI(null, entry.getName(), null);
                if (entry.getName().equals("WEB-INF/web.xml")) {
                    moduleContext.addFile(targetPath, module.getOriginalSpecDD());
                    continue;
                }
                if (entry.getName().startsWith("WEB-INF/lib") && entry.getName().endsWith(".jar")) {
                    libs.add(entry);
                    continue;
                }
                moduleContext.addFile(targetPath, (ZipFile)warFile, entry);
            }
            moduleContext.getConfiguration().addToClassPath("WEB-INF/classes/");
            manifestcp.add((Object)"WEB-INF/classes/");
            for (ZipEntry entry : libs) {
                URI targetPath = new URI(null, entry.getName(), null);
                moduleContext.addInclude(targetPath, (ZipFile)warFile, entry);
                manifestcp.add((Object)entry.getName());
            }
            moduleContext.addManifestClassPath(warFile, RELATIVE_MODULE_BASE_URI);
            moduleContext.getGeneralData().put(ClassPathList.class, manifestcp);
        }
        catch (IOException e) {
            throw new DeploymentException("Problem deploying war", (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Could not construct URI for location of war entry", (Throwable)e);
        }
        finally {
            if (!module.isStandAlone()) {
                try {
                    moduleContext.flush();
                }
                catch (IOException e) {
                    throw new DeploymentException("Problem closing war context", (Throwable)e);
                }
            }
        }
        for (ModuleBuilderExtension mbe : this.moduleBuilderExtensions) {
            mbe.installModule(earFile, earContext, module, configurationStores, targetConfigurationStore, repositories);
        }
    }

    protected void basicInitContext(EARContext earContext, Module module, XmlObject gerWebApp, boolean hasSecurityRealmName) throws DeploymentException {
        EARContext moduleContext = module.getEarContext();
        ClassPathList manifestcp = (ClassPathList)moduleContext.getGeneralData().get(ClassPathList.class);
        ModuleList moduleLocations = (ModuleList)module.getRootEarContext().getGeneralData().get(ModuleList.class);
        URI baseUri = URI.create(module.getTargetPath());
        URI resolutionUri = AbstractWebModuleBuilder.invertURI(baseUri);
        earContext.getCompleteManifestClassPath(module.getModuleFile(), baseUri, resolutionUri, manifestcp, moduleLocations);
        WebAppType webApp = (WebAppType)module.getSpecDD();
        if (!(webApp.getSecurityConstraintArray().length <= 0 && webApp.getSecurityRoleArray().length <= 0 || hasSecurityRealmName)) {
            throw new DeploymentException("web.xml for web app " + module.getName() + " includes security elements but Geronimo deployment plan is not provided or does not contain <security-realm-name> element necessary to configure security accordingly.");
        }
        XmlObject[] securityElements = XmlBeansUtil.selectSubstitutionGroupElements((QName)SECURITY_QNAME, (XmlObject)gerWebApp);
        if (securityElements.length > 0 && !hasSecurityRealmName) {
            throw new DeploymentException("You have supplied a security configuration for web app " + module.getName() + " but no security-realm-name to allow login");
        }
        this.getNamingBuilders().buildEnvironment((XmlObject)webApp, module.getVendorDD(), module.getEnvironment());
        this.getNamingBuilders().initContext((XmlObject)webApp, gerWebApp, module);
        Map<String, String> servletNameToPathMap = this.buildServletNameToPathMap((WebAppType)module.getSpecDD(), ((WebModule)module).getContextRoot());
        Map sharedContext = module.getSharedContext();
        Iterator<WebServiceBuilder> i$ = this.webServiceBuilder.iterator();
        while (i$.hasNext()) {
            WebServiceBuilder aWebServiceBuilder;
            WebServiceBuilder serviceBuilder = aWebServiceBuilder = i$.next();
            serviceBuilder.findWebServices(module, false, servletNameToPathMap, module.getEnvironment(), sharedContext);
        }
        this.securityBuilders.build(gerWebApp, (DeploymentContext)earContext, (DeploymentContext)module.getEarContext());
        this.serviceBuilders.build(gerWebApp, (DeploymentContext)earContext, (DeploymentContext)module.getEarContext());
    }

    static URI invertURI(URI baseUri) {
        URI resolutionUri = URI.create(".");
        URI test = baseUri;
        while (!test.equals(RELATIVE_MODULE_BASE_URI)) {
            resolutionUri = resolutionUri.resolve(RELATIVE_MODULE_BASE_URI);
            test = test.resolve(RELATIVE_MODULE_BASE_URI);
        }
        return resolutionUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebAppDocument convertToServletSchema(XmlObject xmlObject) throws XmlException {
        block18: {
            String schemaLocationURL = "http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd";
            String version = "2.5";
            XmlCursor cursor = xmlObject.newCursor();
            try {
                cursor.toStartDoc();
                cursor.toFirstChild();
                if ("http://java.sun.com/xml/ns/j2ee".equals(cursor.getName().getNamespaceURI())) {
                    SchemaConversionUtils.convertSchemaVersion((XmlCursor)cursor, (String)"http://java.sun.com/xml/ns/javaee", (String)schemaLocationURL, (String)version);
                    XmlObject result = xmlObject.changeType(WebAppDocument.type);
                    XmlBeansUtil.validateDD((XmlObject)result);
                    WebAppDocument webAppDocument = (WebAppDocument)result;
                    return webAppDocument;
                }
                if ("http://java.sun.com/xml/ns/javaee".equals(cursor.getName().getNamespaceURI())) {
                    SchemaConversionUtils.convertSchemaVersion((XmlCursor)cursor, (String)"http://java.sun.com/xml/ns/javaee", (String)schemaLocationURL, (String)version);
                    XmlObject result = xmlObject.changeType(WebAppDocument.type);
                    XmlBeansUtil.validateDD((XmlObject)result);
                    WebAppDocument webAppDocument = (WebAppDocument)result;
                    return webAppDocument;
                }
                XmlDocumentProperties xmlDocumentProperties = cursor.documentProperties();
                String publicId = xmlDocumentProperties.getDoctypePublicId();
                boolean is22 = "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN".equals(publicId);
                if (!"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN".equals(publicId) && !is22) break block18;
                XmlCursor moveable = xmlObject.newCursor();
                try {
                    moveable.toStartDoc();
                    moveable.toFirstChild();
                    SchemaConversionUtils.convertToSchema((XmlCursor)cursor, (String)"http://java.sun.com/xml/ns/javaee", (String)schemaLocationURL, (String)version);
                    cursor.toStartDoc();
                    cursor.toChild("http://java.sun.com/xml/ns/javaee", "web-app");
                    cursor.toFirstChild();
                    SchemaConversionUtils.convertToDescriptionGroup((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                    SchemaConversionUtils.convertToJNDIEnvironmentRefsGroup((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                    cursor.push();
                    if (cursor.toNextSibling(TAGLIB)) {
                        cursor.toPrevSibling();
                        moveable.toCursor(cursor);
                        cursor.beginElement("jsp-config", "http://java.sun.com/xml/ns/javaee");
                        while (moveable.toNextSibling(TAGLIB)) {
                            moveable.moveXml(cursor);
                        }
                    }
                    cursor.pop();
                    do {
                        String jspFile;
                        String name;
                        if (!"filter".equals(name = cursor.getName().getLocalPart()) && !"servlet".equals(name) && !"context-param".equals(name)) continue;
                        cursor.push();
                        cursor.toFirstChild();
                        SchemaConversionUtils.convertToDescriptionGroup((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                        while (cursor.toNextSibling("http://java.sun.com/xml/ns/javaee", "init-param")) {
                            cursor.push();
                            cursor.toFirstChild();
                            SchemaConversionUtils.convertToDescriptionGroup((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                            cursor.pop();
                        }
                        cursor.pop();
                        cursor.push();
                        if (cursor.toChild("http://java.sun.com/xml/ns/javaee", "jsp-file") && !(jspFile = cursor.getTextValue()).startsWith("/")) {
                            if (is22) {
                                cursor.setTextValue("/" + jspFile);
                            } else {
                                throw new XmlException("jsp-file does not start with / and this is not a 2.2 web app: " + jspFile);
                            }
                        }
                        cursor.pop();
                    } while (cursor.toNextSibling());
                }
                finally {
                    moveable.dispose();
                }
            }
            finally {
                cursor.dispose();
            }
        }
        XmlObject result = xmlObject.changeType(WebAppDocument.type);
        if (result != null) {
            XmlBeansUtil.validateDD((XmlObject)result);
            return (WebAppDocument)result;
        }
        XmlBeansUtil.validateDD((XmlObject)xmlObject);
        return (WebAppDocument)xmlObject;
    }

    protected void addUnmappedJSPPermissions(Set<String> securityRoles, Map<String, PermissionCollection> rolePermissions) {
        for (String roleName : securityRoles) {
            this.addPermissionToRole(roleName, (Permission)new WebRoleRefPermission("", roleName), rolePermissions);
        }
    }

    protected ComponentPermissions buildSpecSecurityConfig(WebAppType webApp, Set<String> securityRoles, Map<String, PermissionCollection> rolePermissions) {
        HTTPMethods methods;
        String actions;
        String name;
        SecurityConstraintType[] securityConstraintArray;
        HashMap<String, URLPattern> uncheckedPatterns = new HashMap<String, URLPattern>();
        HashMap<UncheckedItem, HTTPMethods> uncheckedResourcePatterns = new HashMap<UncheckedItem, HTTPMethods>();
        HashMap<UncheckedItem, HTTPMethods> uncheckedUserPatterns = new HashMap<UncheckedItem, HTTPMethods>();
        HashMap excludedPatterns = new HashMap();
        HashMap rolesPatterns = new HashMap();
        HashSet<URLPattern> allSet = new HashSet<URLPattern>();
        HashMap<String, URLPattern> allMap = new HashMap<String, URLPattern>();
        for (SecurityConstraintType securityConstraintType : securityConstraintArray = webApp.getSecurityConstraintArray()) {
            WebResourceCollectionType[] webResourceCollectionTypeArray;
            HashMap<String, Object> currentPatterns = securityConstraintType.isSetAuthConstraint() ? (securityConstraintType.getAuthConstraint().getRoleNameArray().length == 0 ? excludedPatterns : rolesPatterns) : uncheckedPatterns;
            String transport = "";
            if (securityConstraintType.isSetUserDataConstraint()) {
                transport = securityConstraintType.getUserDataConstraint().getTransportGuarantee().getStringValue().trim().toUpperCase();
            }
            for (WebResourceCollectionType webResourceCollectionType : webResourceCollectionTypeArray = securityConstraintType.getWebResourceCollectionArray()) {
                UrlPatternType[] urlPatternTypeArray;
                for (UrlPatternType urlPatternType : urlPatternTypeArray = webResourceCollectionType.getUrlPatternArray()) {
                    String[] httpMethodTypeArray;
                    URLPattern allPattern;
                    String url = urlPatternType.getStringValue().trim();
                    URLPattern pattern = (URLPattern)currentPatterns.get(url);
                    if (pattern == null) {
                        pattern = new URLPattern(url);
                        currentPatterns.put(url, pattern);
                    }
                    if ((allPattern = (URLPattern)allMap.get(url)) == null) {
                        allPattern = new URLPattern(url);
                        allSet.add(allPattern);
                        allMap.put(url, allPattern);
                    }
                    if ((httpMethodTypeArray = webResourceCollectionType.getHttpMethodArray()).length == 0) {
                        pattern.addMethod("");
                        allPattern.addMethod("");
                    } else {
                        for (String aHttpMethodTypeArray : httpMethodTypeArray) {
                            String method;
                            String string = method = aHttpMethodTypeArray == null ? null : aHttpMethodTypeArray.trim();
                            if (method == null) continue;
                            pattern.addMethod(method);
                            allPattern.addMethod(method);
                        }
                    }
                    if (currentPatterns == rolesPatterns) {
                        RoleNameType[] roleNameTypeArray;
                        for (RoleNameType roleNameType : roleNameTypeArray = securityConstraintType.getAuthConstraint().getRoleNameArray()) {
                            String role = roleNameType.getStringValue().trim();
                            if (role.equals("*")) {
                                pattern.addAllRoles(securityRoles);
                                continue;
                            }
                            pattern.addRole(role);
                        }
                    }
                    pattern.setTransport(transport);
                }
            }
        }
        Permissions excludedPermissions = new Permissions();
        Permissions uncheckedPermissions = new Permissions();
        for (URLPattern pattern : excludedPatterns.values()) {
            name = pattern.getQualifiedPattern(allSet);
            actions = pattern.getMethods();
            ((PermissionCollection)excludedPermissions).add((Permission)new WebResourcePermission(name, actions));
            ((PermissionCollection)excludedPermissions).add((Permission)new WebUserDataPermission(name, actions));
        }
        for (URLPattern pattern : rolesPatterns.values()) {
            name = pattern.getQualifiedPattern(allSet);
            actions = pattern.getMethods();
            WebResourcePermission permission = new WebResourcePermission(name, actions);
            for (String roleName : pattern.getRoles()) {
                this.addPermissionToRole(roleName, (Permission)permission, rolePermissions);
            }
            HTTPMethods methods2 = pattern.getHTTPMethods();
            int transportType = pattern.getTransport();
            this.addOrUpdatePattern(uncheckedUserPatterns, name, methods2, transportType);
        }
        for (URLPattern pattern : uncheckedPatterns.values()) {
            name = pattern.getQualifiedPattern(allSet);
            methods = pattern.getHTTPMethods();
            this.addOrUpdatePattern(uncheckedResourcePatterns, name, methods, 0);
            int transportType = pattern.getTransport();
            this.addOrUpdatePattern(uncheckedUserPatterns, name, methods, transportType);
        }
        for (URLPattern pattern : allSet) {
            name = pattern.getQualifiedPattern(allSet);
            methods = pattern.getComplementedHTTPMethods();
            if (methods.isNone()) continue;
            this.addOrUpdatePattern(uncheckedResourcePatterns, name, methods, 0);
            this.addOrUpdatePattern(uncheckedUserPatterns, name, methods, 0);
        }
        URLPattern pattern = new URLPattern("/");
        if (!allSet.contains(pattern)) {
            String name2 = pattern.getQualifiedPattern(allSet);
            HTTPMethods methods3 = pattern.getComplementedHTTPMethods();
            this.addOrUpdatePattern(uncheckedResourcePatterns, name2, methods3, 0);
            this.addOrUpdatePattern(uncheckedUserPatterns, name2, methods3, 0);
        }
        for (UncheckedItem item : uncheckedResourcePatterns.keySet()) {
            methods = (HTTPMethods)uncheckedResourcePatterns.get(item);
            String actions2 = URLPattern.getMethodsWithTransport((HTTPMethods)methods, (int)item.getTransportType());
            ((PermissionCollection)uncheckedPermissions).add((Permission)new WebResourcePermission(item.getName(), actions2));
        }
        for (UncheckedItem item : uncheckedUserPatterns.keySet()) {
            methods = (HTTPMethods)uncheckedUserPatterns.get(item);
            String actions3 = URLPattern.getMethodsWithTransport((HTTPMethods)methods, (int)item.getTransportType());
            ((PermissionCollection)uncheckedPermissions).add((Permission)new WebUserDataPermission(item.getName(), actions3));
        }
        return new ComponentPermissions((PermissionCollection)excludedPermissions, (PermissionCollection)uncheckedPermissions, rolePermissions);
    }

    protected void addPermissionToRole(String roleName, Permission permission, Map<String, PermissionCollection> rolePermissions) {
        PermissionCollection permissionsForRole = rolePermissions.get(roleName);
        if (permissionsForRole == null) {
            permissionsForRole = new Permissions();
            rolePermissions.put(roleName, permissionsForRole);
        }
        permissionsForRole.add(permission);
    }

    private void addOrUpdatePattern(Map<UncheckedItem, HTTPMethods> patternMap, String name, HTTPMethods actions, int transportType) {
        UncheckedItem item = new UncheckedItem(name, transportType);
        HTTPMethods existingActions = patternMap.get(item);
        if (existingActions != null) {
            patternMap.put(item, existingActions.add(actions));
            return;
        }
        patternMap.put(item, new HTTPMethods(actions, false));
    }

    protected static Set<String> collectRoleNames(WebAppType webApp) {
        SecurityRoleType[] securityRoles;
        HashSet<String> roleNames = new HashSet<String>();
        for (SecurityRoleType securityRole : securityRoles = webApp.getSecurityRoleArray()) {
            roleNames.add(securityRole.getRoleName().getStringValue().trim());
        }
        return roleNames;
    }

    protected static void check(WebAppType webApp) throws DeploymentException {
        AbstractWebModuleBuilder.checkURLPattern(webApp);
        AbstractWebModuleBuilder.checkMultiplicities(webApp);
    }

    private static void checkURLPattern(WebAppType webApp) throws DeploymentException {
        SecurityConstraintType[] constraints;
        ServletMappingType[] servletMappings;
        FilterMappingType[] filterMappings;
        for (FilterMappingType filterMapping : filterMappings = webApp.getFilterMappingArray()) {
            UrlPatternType[] urlPatterns = filterMapping.getUrlPatternArray();
            for (int j = 0; urlPatterns != null && j < urlPatterns.length; ++j) {
                AbstractWebModuleBuilder.checkString(urlPatterns[j].getStringValue().trim());
            }
        }
        for (ServletMappingType servletMapping : servletMappings = webApp.getServletMappingArray()) {
            UrlPatternType[] urlPatterns = servletMapping.getUrlPatternArray();
            for (int j = 0; urlPatterns != null && j < urlPatterns.length; ++j) {
                AbstractWebModuleBuilder.checkString(urlPatterns[j].getStringValue().trim());
            }
        }
        for (SecurityConstraintType constraint : constraints = webApp.getSecurityConstraintArray()) {
            WebResourceCollectionType[] collections;
            for (WebResourceCollectionType collection : collections = constraint.getWebResourceCollectionArray()) {
                UrlPatternType[] patterns;
                for (UrlPatternType pattern : patterns = collection.getUrlPatternArray()) {
                    AbstractWebModuleBuilder.checkString(pattern.getStringValue().trim());
                }
            }
        }
    }

    protected static void checkString(String pattern) throws DeploymentException {
        if (pattern.indexOf(13) >= 0) {
            throw new DeploymentException("<url-pattern> must not contain CR(#xD)");
        }
        if (pattern.indexOf(10) >= 0) {
            throw new DeploymentException("<url-pattern> must not contain LF(#xA)");
        }
    }

    private static void checkMultiplicities(WebAppType webApp) throws DeploymentException {
        if (webApp.getSessionConfigArray().length > 1) {
            throw new DeploymentException("Multiple <session-config> elements found");
        }
        if (webApp.getJspConfigArray().length > 1) {
            throw new DeploymentException("Multiple <jsp-config> elements found");
        }
        if (webApp.getLoginConfigArray().length > 1) {
            throw new DeploymentException("Multiple <login-config> elements found");
        }
    }

    private boolean cleanupConfigurationDir(File configurationDir) {
        LinkedList cannotBeDeletedList = new LinkedList();
        if (!DeploymentUtil.recursiveDelete((File)configurationDir, cannotBeDeletedList)) {
            log.warn((Object)("Unable to delete " + cannotBeDeletedList.size() + " files while recursively deleting directory " + configurationDir.getAbsolutePath() + LINE_SEP + "The first file that could not be deleted was:" + LINE_SEP + "  " + (!cannotBeDeletedList.isEmpty() ? (String)cannotBeDeletedList.getFirst() : "")));
            return false;
        }
        return true;
    }

    protected void processRoleRefPermissions(ServletType servletType, Set<String> securityRoles, Map<String, PermissionCollection> rolePermissions) {
        String servletName = servletType.getServletName().getStringValue().trim();
        SecurityRoleRefType[] securityRoleRefTypeArray = servletType.getSecurityRoleRefArray();
        HashSet<String> unmappedRoles = new HashSet<String>(securityRoles);
        for (SecurityRoleRefType securityRoleRefType : securityRoleRefTypeArray) {
            String roleName = securityRoleRefType.getRoleName().getStringValue().trim();
            String roleLink = securityRoleRefType.getRoleLink().getStringValue().trim();
            this.addPermissionToRole(roleLink, (Permission)new WebRoleRefPermission(servletName, roleName), rolePermissions);
            unmappedRoles.remove(roleName);
        }
        for (String roleName : unmappedRoles) {
            this.addPermissionToRole(roleName, (Permission)new WebRoleRefPermission(servletName, roleName), rolePermissions);
        }
    }

    protected ClassFinder createWebAppClassFinder(WebAppType webApp, WebModule webModule) throws DeploymentException {
        ClassLoader classLoader = webModule.getEarContext().getClassLoader();
        return AbstractWebModuleBuilder.createWebAppClassFinder(webApp, classLoader);
    }

    public static ClassFinder createWebAppClassFinder(WebAppType webApp, ClassLoader classLoader) throws DeploymentException {
        FilterType[] filters;
        ListenerType[] listeners;
        ServletType[] servlets;
        ArrayList<Class> classes = new ArrayList<Class>();
        for (ServletType servlet : servlets = webApp.getServletArray()) {
            Class<?> clas;
            FullyQualifiedClassType cls = servlet.getServletClass();
            if (cls == null) continue;
            try {
                clas = classLoader.loadClass(cls.getStringValue());
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("AbstractWebModuleBuilder: Could not load servlet class: " + cls.getStringValue(), (Throwable)e);
            }
            AbstractWebModuleBuilder.addClass(classes, clas);
        }
        for (ListenerType listener : listeners = webApp.getListenerArray()) {
            Class<?> clas;
            FullyQualifiedClassType cls = listener.getListenerClass();
            try {
                clas = classLoader.loadClass(cls.getStringValue());
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("AbstractWebModuleBuilder: Could not load listener class: " + cls.getStringValue(), (Throwable)e);
            }
            AbstractWebModuleBuilder.addClass(classes, clas);
        }
        for (FilterType filter : filters = webApp.getFilterArray()) {
            Class<?> clas;
            FullyQualifiedClassType cls = filter.getFilterClass();
            try {
                clas = classLoader.loadClass(cls.getStringValue());
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("AbstractWebModuleBuilder: Could not load filter class: " + cls.getStringValue(), (Throwable)e);
            }
            AbstractWebModuleBuilder.addClass(classes, clas);
        }
        try {
            return new ClassFinder(classes);
        }
        catch (NoClassDefFoundError e) {
            throw new DeploymentException("Classloader for " + webApp.getId() + "can't find " + e.getMessage(), (Throwable)e);
        }
    }

    private static void addClass(List<Class> classes, Class<?> clas) {
        while (clas != Object.class) {
            classes.add(clas);
            clas = clas.getSuperclass();
        }
    }

    protected void configureBasicWebModuleAttributes(WebAppType webApp, XmlObject vendorPlan, EARContext moduleContext, EARContext earContext, WebModule webModule, GBeanData webModuleData) throws DeploymentException {
        HashMap<NamingBuilder.Key, AbstractName> buildingContext = new HashMap<NamingBuilder.Key, AbstractName>();
        buildingContext.put(NamingBuilder.GBEAN_NAME_KEY, moduleContext.getModuleName());
        if (!webApp.getMetadataComplete()) {
            webModule.setClassFinder(this.createWebAppClassFinder(webApp, webModule));
            SecurityAnnotationHelper.processAnnotations((WebAppType)webApp, (ClassFinder)webModule.getClassFinder());
        }
        this.getNamingBuilders().buildNaming((XmlObject)webApp, vendorPlan, (Module)webModule, buildingContext);
        Map compContext = (Map)NamingBuilder.JNDI_KEY.get(buildingContext);
        Holder holder = (Holder)NamingBuilder.INJECTION_KEY.get(buildingContext);
        webModule.getSharedContext().put("WEB_APP_DATA", webModuleData);
        webModule.getSharedContext().put(NamingBuilder.JNDI_KEY, compContext);
        webModule.getSharedContext().put(NamingBuilder.INJECTION_KEY, holder);
        if (moduleContext.getServerName() != null) {
            webModuleData.setReferencePattern("J2EEServer", moduleContext.getServerName());
        }
        if (!webModule.isStandAlone()) {
            webModuleData.setReferencePattern("J2EEApplication", earContext.getModuleName());
        }
        webModuleData.setAttribute("holder", (Object)holder);
        if (earContext != moduleContext) {
            this.addGBeanDependencies(earContext, webModuleData);
        }
        webModuleData.setAttribute("componentContext", (Object)compContext);
        webModuleData.setReferencePattern("TransactionManager", moduleContext.getTransactionManagerName());
        webModuleData.setReferencePattern("TrackedConnectionAssociator", moduleContext.getConnectionTrackerName());
    }

    static {
        SECURITY_QNAME = GerSecurityDocument.type.getDocumentElementName();
        SERVICE_QNAME = ServiceDocument.type.getDocumentElementName();
        RELATIVE_MODULE_BASE_URI = URI.create("../");
        MANAGED_CONNECTION_FACTORY_PATTERN = new AbstractNameQuery(null, Collections.singletonMap("j2eeType", "JCAManagedConnectionFactory"));
        ADMIN_OBJECT_PATTERN = new AbstractNameQuery(null, Collections.singletonMap("j2eeType", "JCAAdminObject"));
        STATELESS_SESSION_BEAN_PATTERN = new AbstractNameQuery(null, Collections.singletonMap("j2eeType", "StatelessSessionBean"));
        STATEFUL_SESSION_BEAN_PATTERN = new AbstractNameQuery(null, Collections.singletonMap("j2eeType", "StatefulSessionBean"));
        ENTITY_BEAN_PATTERN = new AbstractNameQuery(null, Collections.singletonMap("j2eeType", "EntityBean"));
    }

    class UncheckedItem {
        static final int NA = 0;
        static final int INTEGRAL = 1;
        static final int CONFIDENTIAL = 2;
        private int transportType = 0;
        private String name;

        public UncheckedItem(String name, int transportType) {
            this.setName(name);
            this.setTransportType(transportType);
        }

        public boolean equals(Object o) {
            UncheckedItem item = (UncheckedItem)o;
            return item.transportType == this.transportType && item.name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode() + this.transportType;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getTransportType() {
            return this.transportType;
        }

        public void setTransportType(int transportType) {
            this.transportType = transportType;
        }
    }
}

