/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.geronimo.crypto.EncryptionManager;
import org.apache.geronimo.tomcat.TomcatServerGBean;
import org.apache.geronimo.tomcat.model.ListenerType;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ConnectorType", propOrder={"listener"})
public class ConnectorType {
    @XmlElement(name="Listener")
    protected List<ListenerType> listener;
    @XmlAttribute
    protected String className = Connector.class.getName();
    @XmlAttribute
    protected Boolean allowTrace;
    @XmlAttribute
    protected Long asyncTimeout;
    @XmlAttribute
    protected Boolean emptySessionPath;
    @XmlAttribute
    protected Boolean enableLookups;
    @XmlAttribute
    protected Integer maxParameterCount;
    @XmlAttribute
    protected Integer maxPostSize;
    @XmlAttribute
    protected Integer maxSavePostSize;
    @XmlAttribute
    protected Integer port;
    @XmlAttribute
    protected String protocol;
    @XmlAttribute
    protected String protocolHandlerClassName;
    @XmlAttribute
    protected String proxyName;
    @XmlAttribute
    protected Integer proxyPort;
    @XmlAttribute
    protected Integer redirectPort;
    @XmlAttribute
    protected String scheme;
    @XmlAttribute
    protected Boolean secure;
    @XmlAttribute
    protected String encoding;
    @XmlAttribute(name="URIEncoding")
    protected String uriEncoding;
    @XmlAttribute
    protected String useBodyEncodingForURI;
    @XmlAttribute
    protected String xpoweredBy;
    @XmlAttribute
    protected Boolean useIPVHosts;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();
    private static final String EMPTY_SESSION_PATH = "emptySessionPath";
    private static final String ENABLE_LOOKUPS = "enableLookups";
    private static final String MAX_PARAMETER_COUNT = "maxParameterCount";
    private static final String MAX_POST_SIZE = "maxPostSize";
    private static final String MAX_SAVE_POST_SIZE = "maxSavePostSize";
    private static final String PORT = "port";
    private static final String PROTOCOL = "protocol";
    private static final String PROTOCOL_HANDLER_CLASS_NAME = "protocolHandlerClassName";
    private static final String PROXY_NAME = "proxyName";
    private static final String PROXY_PORT = "proxyPort";
    private static final String REDIRECT_PORT = "redirectPort";
    private static final String SCHEME = "scheme";
    private static final String SECURE = "secure";
    private static final String ENCODING = "encoding";
    private static final String USE_BODY_ENCODING_FOR_URI = "useBodyEncodingForURI";
    private static final String X_POWERED_BY = "xPoweredBy";
    private static final String USE_IPVHOSTS = "useIPVHosts";
    private static final String ALLOW_TRACE = "allowTrace";
    private static final String ASYNC_TIMEOUT = "asyncTimeout";
    private static final String URI_ENCODING = "URIEncoding";

    public List<ListenerType> getListener() {
        if (this.listener == null) {
            this.listener = new ArrayList<ListenerType>();
        }
        return this.listener;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String value) {
        this.className = value;
    }

    public Boolean isAllowTrace() {
        return this.allowTrace;
    }

    public void setAllowTrace(Boolean value) {
        this.allowTrace = value;
    }

    public Long getAsyncTimeout() {
        return this.asyncTimeout;
    }

    public void setAsyncTimeout(Long value) {
        this.asyncTimeout = value;
    }

    public Boolean isEmptySessionPath() {
        return this.emptySessionPath;
    }

    public void setEmptySessionPath(Boolean value) {
        this.emptySessionPath = value;
    }

    public Boolean isEnableLookups() {
        return this.enableLookups;
    }

    public void setEnableLookups(Boolean value) {
        this.enableLookups = value;
    }

    public Integer getMaxParameterCount() {
        return this.maxParameterCount;
    }

    public void setMaxParameterCount(Integer value) {
        this.maxParameterCount = value;
    }

    public Integer getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setMaxPostSize(Integer value) {
        this.maxPostSize = value;
    }

    public Integer getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(Integer value) {
        this.maxSavePostSize = value;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer value) {
        this.port = value;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String value) {
        this.protocol = value;
    }

    public String getProtocolHandlerClassName() {
        return this.protocolHandlerClassName;
    }

    public void setProtocolHandlerClassName(String value) {
        this.protocolHandlerClassName = value;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public void setProxyName(String value) {
        this.proxyName = value;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer value) {
        this.proxyPort = value;
    }

    public Integer getRedirectPort() {
        return this.redirectPort;
    }

    public void setRedirectPort(Integer value) {
        this.redirectPort = value;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String value) {
        this.scheme = value;
    }

    public Boolean isSecure() {
        return this.secure;
    }

    public void setSecure(Boolean value) {
        this.secure = value;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String value) {
        this.encoding = value;
    }

    public String getURIEncoding() {
        return this.uriEncoding;
    }

    public void setURIEncoding(String value) {
        this.uriEncoding = value;
    }

    public String getUseBodyEncodingForURI() {
        return this.useBodyEncodingForURI;
    }

    public void setUseBodyEncodingForURI(String value) {
        this.useBodyEncodingForURI = value;
    }

    public String getXpoweredBy() {
        return this.xpoweredBy;
    }

    public void setXpoweredBy(String value) {
        this.xpoweredBy = value;
    }

    public Boolean isUseIPVHosts() {
        return this.useIPVHosts;
    }

    public void setUseIPVHosts(Boolean value) {
        this.useIPVHosts = value;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public Connector getConnector(ClassLoader cl, Service service) throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.isAllowTrace() != null) {
            properties.put(ALLOW_TRACE, this.isAllowTrace());
        }
        if (this.getAsyncTimeout() != null) {
            properties.put(ASYNC_TIMEOUT, this.getAsyncTimeout());
        }
        if (this.isEmptySessionPath() != null) {
            properties.put(EMPTY_SESSION_PATH, this.isEmptySessionPath());
        }
        if (this.isEnableLookups() != null) {
            properties.put(ENABLE_LOOKUPS, this.isEnableLookups());
        }
        if (this.getMaxParameterCount() != null) {
            properties.put(MAX_PARAMETER_COUNT, this.getMaxParameterCount());
        }
        if (this.getMaxPostSize() != null) {
            properties.put(MAX_POST_SIZE, this.getMaxPostSize());
        }
        if (this.getMaxSavePostSize() != null) {
            properties.put(MAX_SAVE_POST_SIZE, this.getMaxSavePostSize());
        }
        if (this.getPort() != null) {
            properties.put(PORT, this.getPort());
        }
        if (this.getProtocol() != null) {
            properties.put(PROTOCOL, this.getProtocol());
        }
        if (this.getProtocolHandlerClassName() != null) {
            properties.put(PROTOCOL_HANDLER_CLASS_NAME, this.getProtocolHandlerClassName());
        }
        if (this.getProxyName() != null) {
            properties.put(PROXY_NAME, this.getProxyName());
        }
        if (this.getProxyPort() != null) {
            properties.put(PROXY_PORT, this.getProxyPort());
        }
        if (this.getRedirectPort() != null) {
            properties.put(REDIRECT_PORT, this.getRedirectPort());
        }
        if (this.getScheme() != null) {
            properties.put(SCHEME, this.getScheme());
        }
        if (this.isSecure() != null) {
            properties.put(SECURE, this.isSecure());
        }
        if (this.getEncoding() != null) {
            properties.put(ENCODING, this.getEncoding());
        }
        if (this.getURIEncoding() != null) {
            properties.put(URI_ENCODING, this.getURIEncoding());
        }
        if (this.getUseBodyEncodingForURI() != null) {
            properties.put(USE_BODY_ENCODING_FOR_URI, this.getUseBodyEncodingForURI());
        }
        if (this.getXpoweredBy() != null) {
            properties.put(X_POWERED_BY, this.getXpoweredBy());
        }
        if (this.isUseIPVHosts() != null) {
            properties.put(USE_IPVHOSTS, this.isUseIPVHosts());
        }
        ObjectRecipe recipe = new ObjectRecipe(this.className, properties);
        recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
        recipe.setConstructorArgTypes(new Class[]{String.class});
        recipe.setConstructorArgNames(new String[]{PROTOCOL});
        Connector connector = (Connector)recipe.create(cl);
        boolean executorSupported = !connector.getProtocolHandlerClassName().equals("org.apache.jk.server.JkCoyoteHandler");
        for (Map.Entry<QName, String> entry : this.otherAttributes.entrySet()) {
            String name = entry.getKey().getLocalPart();
            String value = entry.getValue();
            if (executorSupported && "executor".equals(name)) {
                org.apache.catalina.Executor executor = service.getExecutor(entry.getValue());
                if (executor == null) {
                    throw new IllegalArgumentException("No executor found in service with name: " + value);
                }
                IntrospectionUtils.callMethod1((Object)connector.getProtocolHandler(), (String)"setExecutor", (Object)executor, (String)Executor.class.getName(), (ClassLoader)cl);
                continue;
            }
            if ("name".equals(name)) {
                TomcatServerGBean.ConnectorName.put(connector, value);
                continue;
            }
            if ("keystorePass".equals(name)) {
                value = (String)((Object)EncryptionManager.decrypt((String)value));
            }
            connector.setProperty(name, value);
        }
        for (ListenerType listenerType : this.getListener()) {
            LifecycleListener listener = listenerType.getLifecycleListener(cl);
            connector.addLifecycleListener(listener);
            TomcatServerGBean.LifecycleListeners.add(listener);
        }
        return connector;
    }
}

