/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.OsgiService;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.NoSuchAttributeException;
import org.apache.geronimo.kernel.config.DeploymentWatcher;
import org.apache.geronimo.kernel.lifecycle.LifecycleAdapter;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.osgi.web.WebApplicationUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
@OsgiService
public class TomcatDeploymentWatcher
implements DeploymentWatcher,
GBeanLifecycle,
SynchronousBundleListener {
    private static final Logger logger = LoggerFactory.getLogger(TomcatDeploymentWatcher.class);
    private final Map<AbstractName, File> abstractNameCleanUpDirectoryMap = new ConcurrentHashMap<AbstractName, File>();
    private final Map<Artifact, long[]> ebaArtifactApplicationContentBundleIdsMap = new ConcurrentHashMap<Artifact, long[]>();
    private final Set<Long> embeddedWABBundleIds = Collections.synchronizedSet(new HashSet());
    private final Kernel kernel;
    private final Map<Long, File> wabBundleIdCleanUpDirectoryMap = new ConcurrentHashMap<Long, File>();
    private final BundleContext bundleContext;
    private final LifecycleListener ebaLifecycleListener = new EBALifecycleListener();

    public TomcatDeploymentWatcher(@ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel, @ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext) {
        this.kernel = kernel;
        this.bundleContext = bundleContext;
    }

    public void bundleChanged(BundleEvent event) {
        File cleanUpDirectory;
        Bundle bundle = event.getBundle();
        Long bundleId = event.getBundle().getBundleId();
        if (event.getType() == 1 && WebApplicationUtils.isWebApplicationBundle((Bundle)bundle) && !this.embeddedWABBundleIds.contains(bundleId) && (cleanUpDirectory = this.wabBundleIdCleanUpDirectoryMap.remove(bundleId)) != null) {
            FileUtils.recursiveDelete((File)cleanUpDirectory);
        }
    }

    public void deleteOnUndeployed(Bundle bundle, AbstractName abName, File cleanUpDirectory) {
        if (WebApplicationUtils.isWebApplicationBundle((Bundle)bundle)) {
            this.wabBundleIdCleanUpDirectoryMap.put(bundle.getBundleId(), cleanUpDirectory);
        } else {
            this.abstractNameCleanUpDirectoryMap.put(abName, cleanUpDirectory);
        }
    }

    public void deployed(Artifact artifact) {
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doStart() throws Exception {
        this.kernel.getLifecycleMonitor().addLifecycleListener(this.ebaLifecycleListener, new AbstractNameQuery("org.apache.geronimo.aries.ApplicationGBean"));
        this.bundleContext.addBundleListener((BundleListener)this);
    }

    public void doStop() throws Exception {
        this.kernel.getLifecycleMonitor().removeLifecycleListener(this.ebaLifecycleListener);
        this.bundleContext.removeBundleListener((BundleListener)this);
    }

    public void undeployed(Artifact artifact) {
        long[] applicationBundleIds = this.ebaArtifactApplicationContentBundleIdsMap.remove(artifact);
        if (applicationBundleIds != null) {
            for (long applicationBundleId : applicationBundleIds) {
                File cleanUpDirectory = this.wabBundleIdCleanUpDirectoryMap.remove(applicationBundleId);
                if (cleanUpDirectory == null) continue;
                this.embeddedWABBundleIds.remove(applicationBundleId);
                FileUtils.recursiveDelete((File)cleanUpDirectory);
            }
            return;
        }
        Iterator<Map.Entry<AbstractName, File>> it = this.abstractNameCleanUpDirectoryMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<AbstractName, File> entry = it.next();
            if (!entry.getKey().getArtifact().equals((Object)artifact)) continue;
            FileUtils.recursiveDelete((File)entry.getValue());
            it.remove();
        }
    }

    private class EBALifecycleListener
    extends LifecycleAdapter {
        private EBALifecycleListener() {
        }

        public void running(AbstractName abName) {
            try {
                long[] applicationContentBundleIds;
                for (long applicationContentBundleId : applicationContentBundleIds = (long[])TomcatDeploymentWatcher.this.kernel.getAttribute(abName, "applicationContentBundleIds")) {
                    TomcatDeploymentWatcher.this.embeddedWABBundleIds.add(applicationContentBundleId);
                }
                TomcatDeploymentWatcher.this.ebaArtifactApplicationContentBundleIdsMap.put(abName.getArtifact(), applicationContentBundleIds);
            }
            catch (GBeanNotFoundException e) {
                logger.error("Unable to find application content bundle Ids from GBean " + abName, (Throwable)e);
            }
            catch (NoSuchAttributeException e) {
                logger.error("Unable to find application content bundle Ids from GBean " + abName, (Throwable)e);
            }
            catch (Exception e) {
                logger.error("Unable to find application content bundle Ids from GBean " + abName, (Throwable)e);
            }
        }
    }
}

