/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.beans.PropertyChangeListener;
import javax.naming.directory.DirContext;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Loader;
import org.apache.catalina.util.LifecycleBase;
import org.apache.geronimo.tomcat.GeronimoStandardContext;
import org.apache.naming.resources.DirContextURLStreamHandler;

public class GeronimoWebAppLoader
extends LifecycleBase
implements Loader {
    private final Loader delegate;
    private final GeronimoStandardContext standardContext;

    public GeronimoWebAppLoader(GeronimoStandardContext standardContext, Loader delegate) {
        this.delegate = delegate;
        this.standardContext = standardContext;
    }

    public void backgroundProcess() {
        this.delegate.backgroundProcess();
    }

    public ClassLoader getClassLoader() {
        return this.standardContext.getParentClassLoader();
    }

    public Container getContainer() {
        return this.delegate.getContainer();
    }

    public void setContainer(Container container) {
        this.delegate.setContainer(container);
    }

    public boolean getDelegate() {
        return this.delegate.getDelegate();
    }

    public void setDelegate(boolean delegateBoolean) {
        this.delegate.setDelegate(delegateBoolean);
    }

    public String getInfo() {
        return this.delegate.getInfo();
    }

    public boolean getReloadable() {
        return false;
    }

    public void setReloadable(boolean reloadable) {
        if (reloadable) {
            throw new UnsupportedOperationException("Reloadable context is not supported.");
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.delegate.addPropertyChangeListener(listener);
    }

    public void addRepository(String repository) {
        this.delegate.addRepository(repository);
    }

    public String[] findRepositories() {
        return this.delegate.findRepositories();
    }

    public boolean modified() {
        return this.delegate.modified();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.delegate.removePropertyChangeListener(listener);
    }

    protected void startInternal() throws LifecycleException {
        DirContext resources = this.delegate.getContainer().getResources();
        if (resources == null) {
            throw new IllegalStateException("JNDI environment was not set up correctly due to previous error");
        }
        DirContextURLStreamHandler.bind((ClassLoader)this.standardContext.getParentClassLoader(), (DirContext)resources);
        this.setState(LifecycleState.STARTING);
    }

    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        DirContextURLStreamHandler.unbind((ClassLoader)this.standardContext.getParentClassLoader());
    }

    protected void destroyInternal() throws LifecycleException {
    }

    protected void initInternal() throws LifecycleException {
    }
}

