/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.security.authentication;

import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.coyote.ActionCode;
import org.apache.geronimo.tomcat.security.AuthResult;
import org.apache.geronimo.tomcat.security.Authenticator;
import org.apache.geronimo.tomcat.security.LoginService;
import org.apache.geronimo.tomcat.security.ServerAuthException;
import org.apache.geronimo.tomcat.security.TomcatAuthStatus;
import org.apache.geronimo.tomcat.security.UserIdentity;
import org.apache.tomcat.util.res.StringManager;

public class ClientCertAuthenticator
implements Authenticator {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.authenticator");
    private final LoginService loginService;
    private final UserIdentity unauthenticatedIdentity;

    public ClientCertAuthenticator(LoginService loginService, UserIdentity unauthenticatedIdentity) {
        this.loginService = loginService;
        this.unauthenticatedIdentity = unauthenticatedIdentity;
    }

    @Override
    public AuthResult validateRequest(Request request, HttpServletResponse response, boolean isAuthMandatory, UserIdentity cachedIdentity) throws ServerAuthException {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (certs == null || certs.length < 1) {
            request.getCoyoteRequest().action(ActionCode.REQ_SSL_CERTIFICATE, null);
            certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        }
        try {
            if (certs == null || certs.length < 1) {
                if (isAuthMandatory) {
                    response.sendError(400, sm.getString("authenticator.certificates"));
                    return new AuthResult(TomcatAuthStatus.SEND_FAILURE, null, false);
                }
                return new AuthResult(TomcatAuthStatus.SUCCESS, this.unauthenticatedIdentity, false);
            }
            UserIdentity userIdentity = this.loginService.login(certs);
            if (userIdentity != null) {
                return new AuthResult(TomcatAuthStatus.SUCCESS, userIdentity, true);
            }
            if (isAuthMandatory) {
                response.sendError(401, sm.getString("authenticator.unauthorized"));
                return new AuthResult(TomcatAuthStatus.SEND_CONTINUE, null, false);
            }
        }
        catch (IOException e) {
            throw new ServerAuthException(e);
        }
        return new AuthResult(TomcatAuthStatus.SUCCESS, this.unauthenticatedIdentity, false);
    }

    @Override
    public boolean secureResponse(Request request, Response response, AuthResult authResult) throws ServerAuthException {
        return true;
    }

    @Override
    public String getAuthType() {
        return "CLIENT_CERT";
    }

    @Override
    public AuthResult login(String username, String password, Request request) throws ServletException {
        UserIdentity userIdentity = this.loginService.login(username, password);
        if (userIdentity != null) {
            return new AuthResult(TomcatAuthStatus.SUCCESS, userIdentity, true);
        }
        return new AuthResult(TomcatAuthStatus.FAILURE, null, false);
    }

    @Override
    public void logout(Request request) {
    }
}

