/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.catalina.Realm;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.security.jaas.ConfigurationFactory;
import org.apache.geronimo.tomcat.BaseGBean;
import org.apache.geronimo.tomcat.ObjectRetriever;

public class RealmGBean
extends BaseGBean
implements GBeanLifecycle,
ObjectRetriever {
    private final Realm realm;
    public static final GBeanInfo GBEAN_INFO;

    public RealmGBean(String className, Map initParams, ConfigurationFactory configurationFactory, ClassLoader classLoader) throws Exception {
        Realm realm;
        if (className == null) {
            throw new NullPointerException("No realm class supplied");
        }
        Class<?> clazz = Class.forName(className, true, classLoader);
        try {
            Constructor<?> c = clazz.getConstructor(ConfigurationFactory.class);
            if (configurationFactory == null) {
                throw new NullPointerException("ConfigurationFactory must be supplied");
            }
            realm = (Realm)c.newInstance(configurationFactory);
        }
        catch (NoSuchMethodException e) {
            realm = (Realm)clazz.newInstance();
        }
        this.setParameters(realm, initParams);
        this.realm = realm;
    }

    @Override
    public Object getInternalObject() {
        return this.realm;
    }

    public void doFail() {
    }

    public void doStart() throws Exception {
    }

    public void doStop() throws Exception {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"TomcatRealm", RealmGBean.class);
        infoFactory.addAttribute("className", String.class, true);
        infoFactory.addAttribute("initParams", Map.class, true);
        infoFactory.addReference("ConfigurationFactory", ConfigurationFactory.class);
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.setConstructor(new String[]{"className", "initParams", "ConfigurationFactory", "classLoader"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

