/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.naming.NamingEntry;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleDirContext
extends BaseDirContext {
    private static final Logger logger = LoggerFactory.getLogger(BundleDirContext.class);
    private final Bundle bundle;
    private String nameInNamespace;
    private final String path;
    private File rootDocPath;

    public BundleDirContext(Bundle bundle, String path, File rootDocPath) {
        this(bundle, path, Collections.emptyList(), rootDocPath);
    }

    public BundleDirContext(Bundle bundle, String path, List<DirContext> altDirContext, File rootDocPath) {
        this.bundle = bundle;
        this.path = path;
        this.altDirContexts.addAll(altDirContext);
        this.rootDocPath = rootDocPath;
    }

    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public String getAliases() {
        StringBuilder result = new StringBuilder();
        Iterator iter = this.aliases.entrySet().iterator();
        boolean first = true;
        try {
            while (iter.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    result.append(',');
                }
                Map.Entry entry = iter.next();
                result.append((String)entry.getKey());
                result.append('=');
                result.append(((BundleDirContext)((Object)entry.getValue())).getNameInNamespace());
            }
            return result.toString();
        }
        catch (NamingException e) {
            return "";
        }
    }

    public void setDocBase(String docBase) {
    }

    public String getNameInNamespace() throws NamingException {
        return this.nameInNamespace;
    }

    public DirContext getSchema(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        Enumeration entries = BundleUtils.getEntryPaths((Bundle)this.bundle, (String)(name = this.getName(name)));
        if (entries == null) {
            throw new NamingException("Resource not found: " + name);
        }
        return new NameClassPairEnumeration(name, entries);
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(String arg0, String arg1) throws NamingException {
    }

    public NamingEnumeration<SearchResult> search(String arg0, Attributes matchingAttributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration<SearchResult> search(String name, String filter, Object[] filterArgs, SearchControls cons) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void setAliases(String theAliases) {
        String[] kvps;
        this.aliases.clear();
        if (theAliases == null || theAliases.length() == 0) {
            return;
        }
        for (String kvp : kvps = theAliases.split(",")) {
            String[] kv = kvp.split("=");
            if (kv.length != 2 || kv[0].length() == 0 || kv[1].length() == 0) {
                throw new IllegalArgumentException(sm.getString("resources.invalidAliasMapping", new Object[]{kvp}));
            }
            File aliasLoc = new File(kv[1]);
            if (aliasLoc.exists()) continue;
            throw new IllegalArgumentException(sm.getString("resources.invalidAliasNotExist", new Object[]{kv[1]}));
        }
    }

    public void setNameInNamespace(String nameInNamespace) {
        this.nameInNamespace = nameInNamespace;
    }

    public void unbind(String arg0) throws NamingException {
    }

    protected Attributes doGetAttributes(String name, String[] attrIds) throws NamingException {
        URL url = BundleUtils.getEntry((Bundle)this.bundle, (String)(name = this.getName(name)));
        if (url == null) {
            return null;
        }
        ResourceAttributes resourceAttributes = new ResourceAttributes();
        resourceAttributes.setLastModified(this.bundle.getLastModified());
        resourceAttributes.setCreation(this.bundle.getLastModified());
        resourceAttributes.setName(url.toString());
        return resourceAttributes;
    }

    protected String doGetRealPath(String path) {
        return this.rootDocPath == null ? null : new File(this.rootDocPath, path).getAbsolutePath();
    }

    protected List<NamingEntry> doListBindings(String name) throws NamingException {
        Enumeration entries = BundleUtils.getEntryPaths((Bundle)this.bundle, (String)(name = this.getName(name)));
        if (entries == null) {
            throw new NamingException("Resource not found: " + name);
        }
        return Collections.list(new BindingEnumeration(this.bundle, name, entries, this.rootDocPath));
    }

    protected Object doLookup(String name) {
        URL url = BundleUtils.getEntry((Bundle)this.bundle, (String)(name = this.getName(name)));
        if (url == null) {
            return null;
        }
        if (url.toString().endsWith("/")) {
            return new BundleDirContext(this.bundle, name, this.rootDocPath == null ? null : new File(this.rootDocPath, name));
        }
        return new URLResource(url);
    }

    private String getName(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (this.path != null) {
            name = this.path + "/" + name;
        }
        return name;
    }

    private static String getBasePath(String name) {
        if (name != null && !name.endsWith("/")) {
            return name + "/";
        }
        return name;
    }

    private static String removeSlash(String name) {
        if (name.endsWith("/")) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }

    private static class URLResource
    extends Resource {
        private final URL url;

        private URLResource(URL url) {
            this.url = url;
        }

        public InputStream streamContent() throws IOException {
            return this.url.openStream();
        }

        public byte[] getContent() {
            try {
                int size;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                InputStream in = this.url.openStream();
                while ((size = in.read(buf)) > 0) {
                    baos.write(buf, 0, size);
                }
                in.close();
                return baos.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void setContent(InputStream inputStream) {
            throw new RuntimeException("Not supported");
        }

        public void setContent(byte[] binaryContent) {
            throw new RuntimeException("Not supported");
        }
    }

    private static class BindingEnumeration
    implements NamingEnumeration<NamingEntry> {
        private Bundle bundle;
        private String basePath;
        private Enumeration<String> entries;
        private File rootDocPath;

        public BindingEnumeration(Bundle bundle, String basePath, Enumeration<String> entries, File rootDocPath) {
            this.bundle = bundle;
            this.basePath = BundleDirContext.getBasePath(basePath);
            this.entries = entries;
            this.rootDocPath = rootDocPath;
        }

        @Override
        public NamingEntry next() throws NamingException {
            return this.nextElement();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        @Override
        public void close() throws NamingException {
        }

        @Override
        public boolean hasMoreElements() {
            return this.entries != null && this.entries.hasMoreElements();
        }

        @Override
        public NamingEntry nextElement() {
            String name = this.entries.nextElement();
            String relativeName = this.getRelativeName(name);
            if (name.endsWith("/")) {
                return new NamingEntry(BundleDirContext.removeSlash(relativeName), (Object)new BundleDirContext(this.bundle, name, this.rootDocPath == null ? null : new File(this.rootDocPath, relativeName)), 10);
            }
            return new NamingEntry(relativeName, (Object)relativeName, 0);
        }

        private String getRelativeName(String name) {
            if (this.basePath != null && name.startsWith(this.basePath)) {
                return name.substring(this.basePath.length());
            }
            return name;
        }
    }

    private static class NameClassPairEnumeration
    implements NamingEnumeration<NameClassPair> {
        private String basePath;
        private Enumeration<String> entries;

        public NameClassPairEnumeration(String basePath, Enumeration<String> entries) {
            this.basePath = BundleDirContext.getBasePath(basePath);
            this.entries = entries;
        }

        @Override
        public NameClassPair next() throws NamingException {
            return this.nextElement();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        @Override
        public void close() throws NamingException {
        }

        @Override
        public boolean hasMoreElements() {
            return this.entries != null && this.entries.hasMoreElements();
        }

        @Override
        public NameClassPair nextElement() {
            String name = this.entries.nextElement();
            String relativeName = this.getRelativeName(name);
            if (name.endsWith("/")) {
                return new Binding(BundleDirContext.removeSlash(relativeName), (Object)DirContext.class.getName());
            }
            return new Binding(relativeName, (Object)String.class.getName());
        }

        private String getRelativeName(String name) {
            if (this.basePath != null && name.startsWith(this.basePath)) {
                return name.substring(this.basePath.length());
            }
            return name;
        }
    }
}

