/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.security.authentication.jaspic;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.message.MessageInfo;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;

public class JaspicMessageInfo
implements MessageInfo {
    private static final String MANDATORY_KEY = "javax.security.auth.message.MessagePolicy.isMandatory";
    private final Map<String, Object> map = new HashMap<String, Object>();
    private HttpServletRequest request;
    private HttpServletResponse response;

    public JaspicMessageInfo() {
    }

    public JaspicMessageInfo(Request request, Response response, boolean authMandatory) {
        this.request = request;
        this.response = response;
        if (authMandatory) {
            this.map.put(MANDATORY_KEY, Boolean.toString(authMandatory));
        }
    }

    public Map getMap() {
        return this.map;
    }

    public Object getRequestMessage() {
        return this.request;
    }

    public Object getResponseMessage() {
        return this.response;
    }

    public void setRequestMessage(Object request) {
        if (!(request instanceof HttpServletRequest)) {
            throw new IllegalArgumentException("Request in not a servlet request but " + request.getClass().getName());
        }
        this.request = (HttpServletRequest)request;
    }

    public void setResponseMessage(Object response) {
        if (!(response instanceof HttpServletResponse)) {
            throw new IllegalArgumentException("response in not a servlet response but " + response.getClass().getName());
        }
        this.response = (HttpServletResponse)response;
    }
}

