/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.core;

import javax.servlet.Servlet;
import javax.servlet.ServletRegistration;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.StandardContext;
import org.apache.geronimo.tomcat.GeronimoStandardContext;
import org.apache.geronimo.tomcat.core.GeronimoApplicationServletRegistrationAdapter;
import org.apache.geronimo.web.security.SpecSecurityBuilder;

public class GeronimoApplicationContext
extends ApplicationContext {
    private GeronimoStandardContext context;
    private SpecSecurityBuilder specSecurityBuilder;

    public GeronimoApplicationContext(GeronimoStandardContext context) {
        super((StandardContext)context);
        this.context = context;
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) throws IllegalStateException {
        return this.createGeronimoApplicationServletRegistrationAdapter(super.addServlet(servletName, servletClass), servletName);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) throws IllegalStateException {
        return this.createGeronimoApplicationServletRegistrationAdapter(super.addServlet(servletName, servlet), servletName);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String servletClass) throws IllegalStateException {
        return this.createGeronimoApplicationServletRegistrationAdapter(super.addServlet(servletName, servletClass), servletName);
    }

    public void declareRoles(String ... roles) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException("declareRoles is not allowed to invoke after the ServletContext is initialized");
        }
        this.specSecurityBuilder.declareRoles(roles);
    }

    protected ServletRegistration.Dynamic createGeronimoApplicationServletRegistrationAdapter(ServletRegistration.Dynamic applicationServletRegistration, String servletName) {
        if (applicationServletRegistration == null) {
            return null;
        }
        return new GeronimoApplicationServletRegistrationAdapter(this.context, this, (Wrapper)this.context.findChild(servletName), applicationServletRegistration);
    }

    public SpecSecurityBuilder getSpecSecurityBuilder() {
        return this.specSecurityBuilder;
    }

    public void setSpecSecurityBuilder(SpecSecurityBuilder specSecurityBuilder) {
        this.specSecurityBuilder = specSecurityBuilder;
    }
}

