/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.connector;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Map;
import javax.management.j2ee.statistics.Stats;
import org.apache.catalina.Executor;
import org.apache.catalina.connector.Connector;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.Persistent;
import org.apache.geronimo.management.StatisticsProvider;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.tomcat.TomcatContainer;
import org.apache.geronimo.tomcat.connector.Ajp13Protocol;
import org.apache.geronimo.tomcat.connector.ConnectorGBean;
import org.apache.geronimo.tomcat.stats.ConnectorStats;

@GBean(name="Tomcat Connector AJP")
public class AJP13ConnectorGBean
extends ConnectorGBean
implements Ajp13Protocol,
StatisticsProvider {
    private ConnectorStats connStatsProvider = new ConnectorStats();
    private boolean reset = true;
    protected String connectHost;

    public AJP13ConnectorGBean(@ParamAttribute(manageable=false, name="name") String name, @ParamAttribute(manageable=false, name="initParams") Map<String, String> initParams, @ParamAttribute(manageable=false, name="host") String host, @ParamAttribute(manageable=false, name="port") int port, @ParamReference(name="TomcatContainer") TomcatContainer container, @ParamReference(name="ServerInfo") ServerInfo serverInfo, @ParamAttribute(manageable=false, name="connector") Connector conn) throws Exception {
        super(name, initParams, "AJP/1.3", container, serverInfo, conn);
        if (host == null) {
            host = "0.0.0.0";
        }
        if (port == 0) {
            throw new IllegalArgumentException("Must declare a port.");
        }
        this.connector.setAttribute("address", (Object)host);
        this.connector.setPort(port);
    }

    @Override
    public String getGeronimoProtocol() {
        return "AJP";
    }

    @Override
    public String getConnectUrl() {
        if (this.connectHost == null) {
            String host = this.getAddress();
            if (host == null || host.equals("0.0.0.0") || host.equals("0:0:0:0:0:0:0:1")) {
                InetAddress address = null;
                try {
                    address = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    host = "unknown-host";
                }
                if (address != null && ((host = address.getCanonicalHostName()) == null || host.equals(""))) {
                    host = address.getHostAddress();
                }
            }
            if (host.indexOf(":") >= 0) {
                host = "[" + host + "]";
            }
            this.connectHost = host;
        }
        return this.getScheme().toLowerCase() + "://" + this.connectHost + (this.getPort() == this.getDefaultPort() ? "" : ":" + this.getPort());
    }

    @Override
    public int getDefaultPort() {
        return -1;
    }

    public InetSocketAddress getListenAddress() {
        return new InetSocketAddress(this.getHost(), this.getPort());
    }

    @Override
    public String getAddress() {
        Object value = this.connector.getAttribute("address");
        if (value == null) {
            return "0.0.0.0";
        }
        if (value instanceof InetAddress) {
            return ((InetAddress)value).getHostAddress();
        }
        return value.toString();
    }

    @Override
    public int getBacklog() {
        Object value = this.connector.getAttribute("backlog");
        return value == null ? 10 : Integer.parseInt(value.toString());
    }

    @Override
    public int getBufferSize() {
        Object value = this.connector.getAttribute("bufferSize");
        return value == null ? 2048 : Integer.parseInt(value.toString());
    }

    @Override
    public int getConnectionTimeout() {
        Object value = this.connector.getAttribute("connectionTimeout");
        return value == null ? -1 : Integer.parseInt(value.toString());
    }

    @Override
    public String getExecutor() {
        Object value = this.connector.getAttribute("executor");
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Executor) {
            return ((Executor)value).getName();
        }
        return value.getClass().getName();
    }

    @Override
    public String getHost() {
        return this.getAddress();
    }

    @Override
    public int getKeepAliveTimeout() {
        Object value = this.connector.getAttribute("keepAliveTimeout");
        return value == null ? this.getConnectionTimeout() : Integer.parseInt(value.toString());
    }

    @Override
    public int getMaxThreads() {
        Object value = this.connector.getAttribute("maxThreads");
        return value == null ? 200 : Integer.parseInt(value.toString());
    }

    @Override
    public int getMaxSpareThreads() {
        Object value = this.connector.getAttribute("maxSpareThreads");
        return value == null ? 100 : Integer.parseInt(value.toString());
    }

    @Override
    public int getMinSpareThreads() {
        Object value = this.connector.getAttribute("minSpareThreads");
        return value == null ? 10 : Integer.parseInt(value.toString());
    }

    @Override
    public int getPort() {
        return this.connector.getPort();
    }

    @Override
    public boolean getTcpNoDelay() {
        Object value = this.connector.getAttribute("tcpNoDelay");
        return value == null ? true : new Boolean(value.toString());
    }

    @Override
    public boolean getTomcatAuthentication() {
        Object value = this.connector.getAttribute("tomcatAuthentication");
        return value == null ? true : new Boolean(value.toString());
    }

    @Override
    @Persistent(manageable=false)
    public void setAddress(String address) {
        this.connector.setAttribute("address", (Object)address);
    }

    @Override
    @Persistent(manageable=false)
    public void setBacklog(int backlog) {
        this.connector.setAttribute("backlog", (Object)new Integer(backlog));
    }

    @Override
    @Persistent(manageable=false)
    public void setBufferSize(int bufferSize) {
        this.connector.setAttribute("bufferSize", (Object)new Integer(bufferSize));
    }

    @Override
    @Persistent(manageable=false)
    public void setConnectionTimeout(int connectionTimeout) {
        this.connector.setAttribute("connectionTimeout", (Object)new Integer(connectionTimeout));
    }

    @Override
    @Persistent(manageable=false)
    public void setExecutor(String executor) {
        this.connector.setAttribute("executor", (Object)executor);
    }

    @Override
    @Persistent(manageable=false)
    public void setHost(String host) {
        this.setAddress(host);
    }

    @Override
    @Persistent(manageable=false)
    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.connector.setAttribute("keepAliveTimeout", (Object)keepAliveTimeout);
    }

    @Override
    @Persistent(manageable=false)
    public void setMaxThreads(int maxThreads) {
        this.connector.setAttribute("maxThreads", (Object)maxThreads);
    }

    @Override
    @Persistent(manageable=false)
    public void setMaxSpareThreads(int maxSpareThreads) {
        this.connector.setAttribute("maxSpareThreads", (Object)new Integer(maxSpareThreads));
    }

    @Override
    @Persistent(manageable=false)
    public void setMinSpareThreads(int minSpareThreads) {
        this.connector.setAttribute("minSpareThreads", (Object)new Integer(minSpareThreads));
    }

    @Persistent(manageable=false)
    public void setNoCompressionUserAgents(String noCompressionUserAgents) {
        this.connector.setAttribute("noCompressionUserAgents", (Object)noCompressionUserAgents);
    }

    @Override
    @Persistent(manageable=false)
    public void setPort(int port) {
        this.connector.setPort(port);
    }

    @Override
    @Persistent(manageable=false)
    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.connector.setAttribute("tcpNoDelay", (Object)new Boolean(tcpNoDelay));
    }

    @Override
    @Persistent(manageable=false)
    public void setTomcatAuthentication(boolean tomcatAuthentication) {
        this.connector.setAttribute("tomcatAuthentication", (Object)new Boolean(tomcatAuthentication));
    }

    public boolean isStatisticsProvider() {
        return true;
    }

    @Override
    public Stats getStats() {
        String port = String.valueOf(this.getPort());
        if (this.reset) {
            this.reset = false;
            return this.connStatsProvider.getStats(port);
        }
        return this.connStatsProvider.updateStats(port);
    }

    @Override
    public void resetStats() {
        this.reset = true;
    }
}

