/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import javax.naming.directory.DirContext;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.geronimo.connector.outbound.connectiontracking.TrackedConnectionAssociator;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.j2ee.RuntimeCustomizer;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.j2ee.jndi.ContextSource;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.ObjectNameUtil;
import org.apache.geronimo.management.J2EEApplication;
import org.apache.geronimo.management.J2EEServer;
import org.apache.geronimo.management.StatisticsProvider;
import org.apache.geronimo.management.geronimo.WebContainer;
import org.apache.geronimo.management.geronimo.WebModule;
import org.apache.geronimo.security.jaas.ConfigurationFactory;
import org.apache.geronimo.security.jacc.ApplicationPolicyConfigurationManager;
import org.apache.geronimo.security.jacc.RunAsSource;
import org.apache.geronimo.tomcat.LifecycleListenerGBean;
import org.apache.geronimo.tomcat.ObjectRetriever;
import org.apache.geronimo.tomcat.TomcatContainer;
import org.apache.geronimo.tomcat.TomcatContext;
import org.apache.geronimo.tomcat.TomcatInstanceManager;
import org.apache.geronimo.tomcat.ValveGBean;
import org.apache.geronimo.tomcat.cluster.CatalinaClusterGBean;
import org.apache.geronimo.tomcat.stats.ModuleStats;
import org.apache.geronimo.tomcat.util.SecurityHolder;
import org.apache.geronimo.transaction.GeronimoUserTransaction;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.apache.geronimo.webservices.WebServiceContainerFactory;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.tomcat.InstanceManager;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(name="Tomcat WebApplication Context", j2eeType="WebModule")
public class TomcatWebAppContext
implements GBeanLifecycle,
TomcatContext,
WebModule,
StatisticsProvider {
    private static final Logger log = LoggerFactory.getLogger(TomcatWebAppContext.class);
    public static final String GBEAN_REF_CLUSTERED_VALVE_RETRIEVER = "ClusteredValveRetriever";
    public static final String GBEAN_REF_MANAGER_RETRIEVER = "ManagerRetriever";
    protected final TomcatContainer container;
    private final ClassLoader classLoader;
    private final Bundle bundle;
    protected Context context = null;
    private String contextPath = null;
    private String docBase = null;
    private String virtualServer = null;
    private final Realm realm;
    private final List valveChain;
    private final List listenerChain;
    private final CatalinaCluster catalinaCluster;
    private final Manager manager;
    private final boolean crossContext;
    private final String workDir;
    private final boolean disableCookies;
    private final UserTransaction userTransaction;
    private final javax.naming.Context componentContext;
    private final Kernel kernel;
    private final Set unshareableResources;
    private final Set applicationManagedSecurityResources;
    private final TrackedConnectionAssociator trackedConnectionAssociator;
    private final SecurityHolder securityHolder;
    private final J2EEServer server;
    private final Map webServices;
    private final String objectName;
    private final String originalSpecDD;
    private final String modulePath;
    private final Holder holder;
    private final RuntimeCustomizer contextCustomizer;
    private final Collection<String> listeners;
    private String displayName;
    private Map<String, Object> deploymentAttributes;
    private ApplicationPolicyConfigurationManager applicationPolicyConfigurationManager;
    private final String j2EEServer;
    private final String j2EEApplication;
    private ModuleStats statsProvider;
    private boolean reset = true;
    private final Valve clusteredValve;

    public TomcatWebAppContext(@ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader classLoader, @ParamSpecial(type=SpecialAttributeType.bundle) Bundle bundle, @ParamSpecial(type=SpecialAttributeType.objectName) String objectName, @ParamAttribute(name="contextPath") String contextPath, @ParamAttribute(name="deploymentDescriptor") String originalSpecDD, @ParamAttribute(name="modulePath") String modulePath, @ParamAttribute(name="securityHolder") SecurityHolder securityHolder, @ParamAttribute(name="virtualServer") String virtualServer, @ParamAttribute(name="unshareableResources") Set<String> unshareableResources, @ParamAttribute(name="applicationManagedSecurityResources") Set<String> applicationManagedSecurityResources, @ParamReference(name="TransactionManager") TransactionManager transactionManager, @ParamReference(name="TrackedConnectionAssociator") TrackedConnectionAssociator trackedConnectionAssociator, @ParamReference(name="Container") TomcatContainer container, @ParamReference(name="RunAsSource") RunAsSource runAsSource, @ParamReference(name="ConfigurationFactory") ConfigurationFactory configurationFactory, @ParamReference(name="TomcatRealm") ObjectRetriever tomcatRealm, @ParamReference(name="ClusteredValveRetriever") ObjectRetriever clusteredValveRetriever, @ParamReference(name="TomcatValveChain") ValveGBean tomcatValveChain, @ParamReference(name="LifecycleListenerChain") LifecycleListenerGBean lifecycleListenerChain, @ParamReference(name="Cluster") CatalinaClusterGBean cluster, @ParamReference(name="ManagerRetriever") ObjectRetriever managerRetriever, @ParamAttribute(name="crossContext") boolean crossContext, @ParamAttribute(name="workDir") String workDir, @ParamAttribute(name="disableCookies") boolean disableCookies, @ParamAttribute(name="displayName") String displayName, @ParamAttribute(name="webServices") Map webServices, @ParamAttribute(name="holder") Holder holder, @ParamReference(name="ContextCustomizer") RuntimeCustomizer contextCustomizer, @ParamReference(name="J2EEServer") J2EEServer server, @ParamReference(name="J2EEApplication") J2EEApplication application, @ParamReference(name="ContextSource") ContextSource contextSource, @ParamReference(name="applicationPolicyConfigurationManager") ApplicationPolicyConfigurationManager applicationPolicyConfigurationManager, @ParamAttribute(name="listenerClassNames") Collection<String> listenerClassNames, @ParamAttribute(name="deploymentAttributes") Map<String, Object> deploymentAttributes, @ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel) throws Exception {
        ArrayList<Object> chain;
        assert (classLoader != null);
        assert (bundle != null);
        assert (transactionManager != null);
        assert (trackedConnectionAssociator != null);
        assert (contextSource != null);
        assert (container != null);
        this.clusteredValve = null != clusteredValveRetriever ? (Valve)clusteredValveRetriever.getInternalObject() : null;
        this.objectName = objectName;
        this.deploymentAttributes = deploymentAttributes;
        this.container = container;
        this.bundle = bundle;
        this.modulePath = modulePath;
        this.originalSpecDD = originalSpecDD;
        this.contextPath = contextPath;
        this.virtualServer = virtualServer;
        this.securityHolder = securityHolder;
        this.componentContext = contextSource.getContext();
        this.userTransaction = new GeronimoUserTransaction(transactionManager);
        this.unshareableResources = unshareableResources;
        this.applicationManagedSecurityResources = applicationManagedSecurityResources;
        this.trackedConnectionAssociator = trackedConnectionAssociator;
        this.applicationPolicyConfigurationManager = applicationPolicyConfigurationManager;
        this.server = server;
        if (securityHolder != null) {
            securityHolder.setRunAsSource(runAsSource == null ? RunAsSource.NULL : runAsSource);
            securityHolder.setConfigurationFactory(configurationFactory);
        }
        this.holder = holder == null ? new Holder() : holder;
        this.contextCustomizer = contextCustomizer;
        if (tomcatRealm != null) {
            this.realm = (Realm)tomcatRealm.getInternalObject();
            if (this.realm == null) {
                throw new IllegalArgumentException("tomcatRealm must be an instance of org.apache.catalina.Realm.");
            }
        } else {
            this.realm = null;
        }
        this.displayName = displayName;
        this.listeners = listenerClassNames;
        if (tomcatValveChain != null) {
            chain = new ArrayList<Object>();
            for (ValveGBean valveGBean = tomcatValveChain; valveGBean != null; valveGBean = valveGBean.getNextValve()) {
                chain.add((Valve)valveGBean.getInternalObject());
            }
            this.valveChain = chain;
        } else {
            this.valveChain = null;
        }
        if (lifecycleListenerChain != null) {
            chain = new ArrayList();
            for (LifecycleListenerGBean listenerGBean = lifecycleListenerChain; listenerGBean != null; listenerGBean = listenerGBean.getNextListener()) {
                chain.add((LifecycleListener)listenerGBean.getInternalObject());
            }
            this.listenerChain = chain;
        } else {
            this.listenerChain = null;
        }
        this.catalinaCluster = cluster != null ? (CatalinaCluster)cluster.getInternalObject() : null;
        this.manager = managerRetriever != null ? (Manager)managerRetriever.getInternalObject() : null;
        this.crossContext = crossContext;
        this.workDir = workDir;
        this.disableCookies = disableCookies;
        this.webServices = this.createWebServices(webServices, kernel);
        this.classLoader = classLoader;
        this.kernel = kernel;
        if (objectName != null) {
            ObjectName myObjectName = ObjectNameUtil.getObjectName((String)objectName);
            this.verifyObjectName(myObjectName);
            this.j2EEServer = myObjectName.getKeyProperty("J2EEServer");
            this.j2EEApplication = myObjectName.getKeyProperty("J2EEApplication");
        } else {
            this.j2EEServer = null;
            this.j2EEApplication = null;
        }
    }

    private Map createWebServices(Map webServiceFactoryMap, Kernel kernel) throws Exception {
        HashMap<String, WebServiceContainer> webServices = new HashMap<String, WebServiceContainer>();
        if (webServiceFactoryMap != null) {
            for (Map.Entry entry : webServiceFactoryMap.entrySet()) {
                String servletName = (String)entry.getKey();
                AbstractName factoryName = (AbstractName)entry.getValue();
                WebServiceContainerFactory webServiceContainerFactory = (WebServiceContainerFactory)kernel.getGBean(factoryName);
                WebServiceContainer webServiceContainer = webServiceContainerFactory.getWebServiceContainer();
                webServices.put(servletName, webServiceContainer);
            }
        }
        return webServices;
    }

    public ApplicationPolicyConfigurationManager getApplicationPolicyConfigurationManager() {
        return this.applicationPolicyConfigurationManager;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getJ2EEApplication() {
        return this.j2EEApplication;
    }

    public String getJ2EEServer() {
        return this.j2EEServer;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return true;
    }

    public boolean isEventProvider() {
        return true;
    }

    public String getWARName() {
        try {
            return ObjectName.getInstance(this.objectName).getKeyProperty("name");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public WebContainer getContainer() {
        return this.container;
    }

    public String getServer() {
        return this.server == null ? null : this.server.getObjectName();
    }

    @Override
    public String getDocBase() {
        return this.docBase;
    }

    @Override
    public UserTransaction getUserTransaction() {
        return this.userTransaction;
    }

    @Override
    public javax.naming.Context getJndiContext() {
        return this.componentContext;
    }

    @Override
    public String getVirtualServer() {
        return this.virtualServer;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Kernel getKernel() {
        return this.kernel;
    }

    @Override
    public boolean isDisableCookies() {
        return this.disableCookies;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public SecurityHolder getSecurityHolder() {
        return this.securityHolder;
    }

    @Override
    public Set getApplicationManagedSecurityResources() {
        return this.applicationManagedSecurityResources;
    }

    @Override
    public TrackedConnectionAssociator getTrackedConnectionAssociator() {
        return this.trackedConnectionAssociator;
    }

    @Override
    public Set getUnshareableResources() {
        return this.unshareableResources;
    }

    @Override
    public Realm getRealm() {
        return this.realm;
    }

    @Override
    public Valve getClusteredValve() {
        return this.clusteredValve;
    }

    @Override
    public List getValveChain() {
        return this.valveChain;
    }

    @Override
    public List getLifecycleListenerChain() {
        return this.listenerChain;
    }

    @Override
    public CatalinaCluster getCluster() {
        return this.catalinaCluster;
    }

    @Override
    public Manager getManager() {
        return this.manager;
    }

    @Override
    public boolean isCrossContext() {
        return this.crossContext;
    }

    @Override
    public String getWorkDir() {
        return this.workDir;
    }

    @Override
    public Map getWebServices() {
        return this.webServices;
    }

    @Override
    public InstanceManager getInstanceManager() {
        return new TomcatInstanceManager(this.holder, this.classLoader, this.componentContext);
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public String getModulePath() {
        return this.modulePath;
    }

    public RuntimeCustomizer getRuntimeCustomizer() {
        return this.contextCustomizer;
    }

    public String[] getServlets() {
        String[] result = null;
        if (this.context != null && this.context instanceof StandardContext) {
            result = ((StandardContext)this.context).getServlets();
        }
        return result;
    }

    @Override
    public Collection<String> getListeners() {
        return this.listeners;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Object getDeploymentAttribute(String name) {
        return this.deploymentAttributes.get(name);
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"WebModule".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("WebModule object name j2eeType property must be 'WebModule'", objectName);
        }
        if (!keyPropertyList.containsKey("name")) {
            throw new InvalidObjectNameException("WebModule object must contain a name property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEServer")) {
            throw new InvalidObjectNameException("WebModule object name must contain a J2EEServer property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEApplication")) {
            throw new InvalidObjectNameException("WebModule object name must contain a J2EEApplication property", objectName);
        }
        if (keyPropertyList.size() != 4) {
            throw new InvalidObjectNameException("WebModule object name can only have j2eeType, name, J2EEApplication, and J2EEServer properties", objectName);
        }
    }

    public String[] getJavaVMs() {
        return this.server == null ? new String[]{} : this.server.getJavaVMs();
    }

    @Override
    public String getDeploymentDescriptor() {
        return this.originalSpecDD;
    }

    public Stats getStats() {
        if (this.reset) {
            this.reset = false;
            return this.statsProvider.getStats();
        }
        return this.statsProvider.updateStats();
    }

    public void resetStats() {
        this.reset = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.container.addContext(this);
            DirContext resources = this.context.getResources();
            if (resources == null) {
                throw new IllegalStateException("JNDI environment was not set up correctly due to previous error");
            }
            DirContextURLStreamHandler.bind((ClassLoader)this.classLoader, (DirContext)resources);
            if (this.context instanceof StandardContext) {
                this.statsProvider = new ModuleStats((StandardContext)this.context);
            }
            log.debug("TomcatWebAppContext started for " + this.contextPath);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public void doStop() throws Exception {
        this.statsProvider = null;
        this.container.removeContext(this);
        DirContextURLStreamHandler.unbind((ClassLoader)this.classLoader);
        log.debug("TomcatWebAppContext stopped");
    }

    public void doFail() {
        this.statsProvider = null;
        this.container.removeContext(this);
        log.warn("TomcatWebAppContext failed");
    }
}

