/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import org.apache.catalina.connector.Connector;
import org.apache.geronimo.crypto.KeystoreUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.gbean.annotation.AnnotationGBeanInfoFactory;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.proxy.ProxyManager;
import org.apache.geronimo.management.geronimo.NetworkConnector;
import org.apache.geronimo.management.geronimo.WebAccessLog;
import org.apache.geronimo.management.geronimo.WebContainer;
import org.apache.geronimo.management.geronimo.WebManager;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.tomcat.Messages;
import org.apache.geronimo.tomcat.TomcatLogManager;
import org.apache.geronimo.tomcat.TomcatServerConfigManager;
import org.apache.geronimo.tomcat.TomcatServerGBean;
import org.apache.geronimo.tomcat.TomcatWebContainer;
import org.apache.geronimo.tomcat.connector.AJP13ConnectorGBean;
import org.apache.geronimo.tomcat.connector.Http11APRConnectorGBean;
import org.apache.geronimo.tomcat.connector.Http11ConnectorGBean;
import org.apache.geronimo.tomcat.connector.Http11NIOConnectorGBean;
import org.apache.geronimo.tomcat.connector.Https11APRConnectorGBean;
import org.apache.geronimo.tomcat.connector.Https11ConnectorGBean;
import org.apache.geronimo.tomcat.connector.Https11NIOConnectorGBean;
import org.apache.geronimo.tomcat.connector.TomcatWebConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatManagerImpl
implements WebManager {
    private static final Logger log = LoggerFactory.getLogger(TomcatManagerImpl.class);
    private final Kernel kernel;
    private TomcatServerConfigManager tomcatServerConfigManager;
    private static final WebManager.ConnectorType HTTP_BIO = new WebManager.ConnectorType(Messages.getString("TomcatManagerImpl.0"));
    private static final WebManager.ConnectorType HTTPS_BIO = new WebManager.ConnectorType(Messages.getString("TomcatManagerImpl.1"));
    private static final WebManager.ConnectorType HTTP_NIO = new WebManager.ConnectorType(Messages.getString("TomcatManagerImpl.2"));
    private static final WebManager.ConnectorType HTTPS_NIO = new WebManager.ConnectorType(Messages.getString("TomcatManagerImpl.3"));
    private static final WebManager.ConnectorType HTTP_APR = new WebManager.ConnectorType(Messages.getString("TomcatManagerImpl.4"));
    private static final WebManager.ConnectorType HTTPS_APR = new WebManager.ConnectorType(Messages.getString("TomcatManagerImpl.5"));
    private static final WebManager.ConnectorType AJP = new WebManager.ConnectorType(Messages.getString("TomcatManagerImpl.6"));
    private static List<WebManager.ConnectorType> CONNECTOR_TYPES = Arrays.asList(HTTP_BIO, HTTPS_BIO, HTTP_NIO, HTTPS_NIO, HTTP_APR, HTTPS_APR, AJP);
    private static List<WebManager.ConnectorType> NON_APR_CONNECTOR_TYPES = Arrays.asList(HTTP_BIO, HTTPS_BIO, HTTP_NIO, HTTPS_NIO, AJP);
    private static Map<WebManager.ConnectorType, List<WebManager.ConnectorAttribute>> CONNECTOR_ATTRIBUTES = new HashMap<WebManager.ConnectorType, List<WebManager.ConnectorAttribute>>();
    private static Map<WebManager.ConnectorType, GBeanInfo> CONNECTOR_GBEAN_INFOS;
    private static List<String> defaultAttributeNames;
    private static AnnotationGBeanInfoFactory annotationGbeanInfoFactory;

    public TomcatManagerImpl(@ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel, @ParamReference(name="Server") TomcatServerGBean tomcatServerGBean) {
        this.kernel = kernel;
        this.tomcatServerConfigManager = tomcatServerGBean.getTomcatServerConfigManager();
    }

    public String getProductName() {
        return "Tomcat";
    }

    public Object[] getContainers() {
        ProxyManager proxyManager = this.kernel.getProxyManager();
        AbstractNameQuery query = new AbstractNameQuery(TomcatWebContainer.class.getName());
        Set names = this.kernel.listGBeans(query);
        Object[] results = new TomcatWebContainer[names.size()];
        int i = 0;
        for (AbstractName name : names) {
            results[i] = (TomcatWebContainer)proxyManager.createProxy(name, TomcatWebContainer.class.getClassLoader());
            ++i;
        }
        return results;
    }

    public String[] getSupportedProtocols() {
        return new String[]{"HTTP", "HTTPS", "AJP"};
    }

    public void removeConnector(AbstractName connectorAbstractName) {
        try {
            this.kernel.invoke(connectorAbstractName, "doStop");
            String connectorName = (String)this.kernel.getGBeanData(connectorAbstractName).getAttribute("name");
            this.tomcatServerConfigManager.removeConnector(connectorName);
            this.kernel.unloadGBean(connectorAbstractName);
        }
        catch (Exception e) {
            log.error("error when removing connector:" + connectorAbstractName, (Throwable)e);
        }
    }

    public NetworkConnector[] getConnectors(String protocol) {
        if (protocol == null) {
            return this.getConnectors();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        ProxyManager proxyManager = this.kernel.getProxyManager();
        AbstractNameQuery query = new AbstractNameQuery(TomcatWebConnector.class.getName());
        Set names = this.kernel.listGBeans(query);
        for (AbstractName name : names) {
            try {
                if (!this.kernel.getAttribute(name, "protocol").equals(protocol)) continue;
                result.add(proxyManager.createProxy(name, TomcatWebConnector.class.getClassLoader()));
            }
            catch (Exception e) {
                log.error("Unable to check the protocol for a connector", (Throwable)e);
            }
        }
        return result.toArray(new TomcatWebConnector[names.size()]);
    }

    public WebAccessLog getAccessLog(WebContainer container) {
        AbstractNameQuery query = new AbstractNameQuery(TomcatLogManager.class.getName());
        Set names = this.kernel.listGBeans(query);
        if (names.size() == 0) {
            return null;
        }
        if (names.size() > 1) {
            throw new IllegalStateException("Should not be more than one Tomcat access log manager");
        }
        return (WebAccessLog)this.kernel.getProxyManager().createProxy((AbstractName)names.iterator().next(), TomcatLogManager.class.getClassLoader());
    }

    public List<WebManager.ConnectorType> getConnectorTypes() {
        if (this.isNativeAPRLibInstalled()) {
            return CONNECTOR_TYPES;
        }
        return NON_APR_CONNECTOR_TYPES;
    }

    public List<WebManager.ConnectorAttribute> getConnectorAttributes(WebManager.ConnectorType connectorType) {
        return WebManager.ConnectorAttribute.copy(CONNECTOR_ATTRIBUTES.get(connectorType));
    }

    public AbstractName getConnectorConfiguration(WebManager.ConnectorType connectorType, List<WebManager.ConnectorAttribute> connectorAttributes, WebContainer container, String uniqueName) {
        GBeanInfo gbeanInfo = CONNECTOR_GBEAN_INFOS.get(connectorType);
        AbstractName containerName = this.kernel.getAbstractNameFor((Object)container);
        AbstractName name = this.kernel.getNaming().createSiblingName(containerName, uniqueName, "GBean");
        GBeanData gbeanData = new GBeanData(name, gbeanInfo);
        gbeanData.setAttribute("name", (Object)uniqueName);
        gbeanData.setReferencePattern("TomcatContainer", containerName);
        HashMap<String, String> initParams = new HashMap<String, String>();
        for (WebManager.ConnectorAttribute connectorAttribute : connectorAttributes) {
            gbeanData.setAttribute(connectorAttribute.getAttributeName(), connectorAttribute.getValue());
            initParams.put(connectorAttribute.getAttributeName(), connectorAttribute.getStringValue());
        }
        gbeanData.setAttribute("initParams", initParams);
        AbstractNameQuery query = new AbstractNameQuery(ServerInfo.class.getName());
        Set set = this.kernel.listGBeans(query);
        AbstractName serverInfo = (AbstractName)set.iterator().next();
        gbeanData.setReferencePattern("ServerInfo", serverInfo);
        try {
            this.kernel.loadGBean(gbeanData, container.getBundleContext());
            this.kernel.startGBean(name);
        }
        catch (Exception e) {
            log.error("Error when adding new tomcat connector" + uniqueName, (Throwable)e);
        }
        return name;
    }

    public NetworkConnector[] getConnectors() {
        ProxyManager proxyManager = this.kernel.getProxyManager();
        AbstractNameQuery query = new AbstractNameQuery(TomcatWebConnector.class.getName());
        Set names = this.kernel.listGBeans(query);
        NetworkConnector[] results = new TomcatWebConnector[names.size()];
        int i = 0;
        for (AbstractName name : names) {
            results[i] = (TomcatWebConnector)proxyManager.createProxy(name, TomcatWebConnector.class.getClassLoader());
            ++i;
        }
        return results;
    }

    public NetworkConnector[] getConnectorsForContainer(Object container, String protocol) {
        if (protocol == null) {
            return this.getConnectorsForContainer(container);
        }
        AbstractName containerName = this.kernel.getAbstractNameFor(container);
        ProxyManager mgr = this.kernel.getProxyManager();
        try {
            ArrayList<Object> results = new ArrayList<Object>();
            AbstractNameQuery query = new AbstractNameQuery(TomcatWebConnector.class.getName());
            Set set = this.kernel.listGBeans(query);
            for (AbstractName name : set) {
                GBeanData data = this.kernel.getGBeanData(name);
                ReferencePatterns refs = data.getReferencePatterns("TomcatContainer");
                if (!containerName.equals((Object)refs.getAbstractName())) continue;
                try {
                    String testProtocol = (String)this.kernel.getAttribute(name, "protocol");
                    if (testProtocol == null || !testProtocol.equals(protocol)) break;
                    results.add(mgr.createProxy(name, TomcatWebConnector.class.getClassLoader()));
                }
                catch (Exception e) {
                    log.error("Unable to look up protocol for connector '" + name + "'", (Throwable)e);
                }
                break;
            }
            return results.toArray(new TomcatWebConnector[results.size()]);
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Unable to look up connectors for Tomcat container '" + containerName + "': ").initCause(e);
        }
    }

    public NetworkConnector[] getConnectorsForContainer(Object container) {
        AbstractName containerName = this.kernel.getAbstractNameFor(container);
        ProxyManager mgr = this.kernel.getProxyManager();
        try {
            ArrayList<Object> results = new ArrayList<Object>();
            AbstractNameQuery query = new AbstractNameQuery(TomcatWebConnector.class.getName());
            Set set = this.kernel.listGBeans(query);
            for (AbstractName name : set) {
                GBeanData data = this.kernel.getGBeanData(name);
                ReferencePatterns refs = data.getReferencePatterns("TomcatContainer");
                if (!containerName.equals((Object)refs.getAbstractName())) continue;
                results.add(mgr.createProxy(name, TomcatWebConnector.class.getClassLoader()));
            }
            return results.toArray(new TomcatWebConnector[results.size()]);
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Unable to look up connectors for Tomcat container '" + containerName).initCause(e);
        }
    }

    private static void addCommonConnectorAttributes(List<WebManager.ConnectorAttribute> connectorAttributes) {
        connectorAttributes.add(new WebManager.ConnectorAttribute("allowTrace", (Object)false, Messages.getString("TomcatManagerImpl.80"), Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("emptySessionPath", (Object)false, Messages.getString("TomcatManagerImpl.82"), Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("enableLookups", (Object)true, Messages.getString("TomcatManagerImpl.84"), Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxPostSize", (Object)0x200000, Messages.getString("TomcatManagerImpl.86"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxSavePostSize", (Object)4096, Messages.getString("TomcatManagerImpl.88"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("proxyName", null, Messages.getString("TomcatManagerImpl.90"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("proxyPort", (Object)0, Messages.getString("TomcatManagerImpl.92"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("redirectPort", (Object)8443, Messages.getString("TomcatManagerImpl.94"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("uriEncoding", (Object)"ISO-8859-1", Messages.getString("TomcatManagerImpl.97"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useBodyEncodingForURI", (Object)false, Messages.getString("TomcatManagerImpl.99"), Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useIPVHosts", (Object)false, Messages.getString("TomcatManagerImpl.101"), Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("xpoweredBy", (Object)false, Messages.getString("TomcatManagerImpl.103"), Boolean.class));
    }

    private static void addHttpConnectorAttributes(List<WebManager.ConnectorAttribute> connectorAttributes) {
        connectorAttributes.add(new WebManager.ConnectorAttribute("acceptCount", (Object)10, Messages.getString("TomcatManagerImpl.105"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("address", (Object)"0.0.0.0", Messages.getString("TomcatManagerImpl.108"), String.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("bufferSize", (Object)2048, Messages.getString("TomcatManagerImpl.110"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("compressableMimeType", (Object)"text/html,text/xml,text/plain", Messages.getString("TomcatManagerImpl.113"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("compression", (Object)"off", Messages.getString("TomcatManagerImpl.116"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("connectionLinger", (Object)-1, Messages.getString("TomcatManagerImpl.118"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("connectionTimeout", (Object)60000, Messages.getString("TomcatManagerImpl.120"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("executor", (Object)"DefaultThreadPool", Messages.getString("TomcatManagerImpl.122"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("keepAliveTimeout", (Object)60000, Messages.getString("TomcatManagerImpl.124"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("disableUploadTimeout", (Object)true, Messages.getString("TomcatManagerImpl.126"), Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxHttpHeaderSize", (Object)4096, Messages.getString("TomcatManagerImpl.128"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxKeepAliveRequests", (Object)100, Messages.getString("TomcatManagerImpl.130"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxThreads", (Object)40, Messages.getString("TomcatManagerImpl.132"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("minSpareThreads", (Object)10, Messages.getString("TomcatManagerImpl.134"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxSpareThreads", (Object)100, Messages.getString("TomcatManagerImpl.136"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("noCompressionUserAgents", (Object)"", Messages.getString("TomcatManagerImpl.139"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("port", (Object)8080, Messages.getString("TomcatManagerImpl.141"), Integer.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("restrictedUserAgents", (Object)"", Messages.getString("TomcatManagerImpl.144"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("server", null, Messages.getString("TomcatManagerImpl.147"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socketBuffer", (Object)9000, Messages.getString("TomcatManagerImpl.149"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("tcpNoDelay", (Object)true, Messages.getString("TomcatManagerImpl.151"), Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("threadPriority", (Object)5, Messages.getString("TomcatManagerImpl.153"), Integer.class));
    }

    private static void addSslConnectorAttributes(List<WebManager.ConnectorAttribute> connectorAttributes) {
        connectorAttributes.add(new WebManager.ConnectorAttribute("algorithm", (Object)KeyManagerFactory.getDefaultAlgorithm(), Messages.getString("TomcatManagerImpl.155"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("clientAuth", (Object)false, Messages.getString("TomcatManagerImpl.157"), Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("keystoreFile", (Object)"", Messages.getString("TomcatManagerImpl.160"), String.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("keystorePass", null, Messages.getString("TomcatManagerImpl.162"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("keystoreType", (Object)KeystoreUtil.defaultType, Messages.getString("TomcatManagerImpl.165"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslProtocol", (Object)"TLS", Messages.getString("TomcatManagerImpl.168"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("ciphers", (Object)"", Messages.getString("TomcatManagerImpl.171"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("keyAlias", null, Messages.getString("TomcatManagerImpl.173"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("truststoreFile", null, Messages.getString("TomcatManagerImpl.175"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("truststorePass", null, Messages.getString("TomcatManagerImpl.177"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("truststoreType", (Object)KeystoreUtil.defaultType, Messages.getString("TomcatManagerImpl.179"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("scheme", (Object)"https", Messages.getString("TomcatManagerImpl.169"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("secure", (Object)true, Messages.getString("TomcatManagerImpl.170"), Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslEnabled", (Object)true, Messages.getString("TomcatManagerImpl.167"), Boolean.class));
    }

    private static void addNioConnectorAttributes(List<WebManager.ConnectorAttribute> connectorAttributes) {
        connectorAttributes.add(new WebManager.ConnectorAttribute("useSendfile", (Object)true, Messages.getString("TomcatManagerImpl.181"), Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useExecutor", (Object)true, Messages.getString("TomcatManagerImpl.183"), Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("acceptorThreadCount", (Object)1, Messages.getString("TomcatManagerImpl.185"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("pollerThreadCount", (Object)1, Messages.getString("TomcatManagerImpl.187"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("pollerThreadPriority", (Object)5, Messages.getString("TomcatManagerImpl.189"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("acceptorThreadPriority", (Object)5, Messages.getString("TomcatManagerImpl.191"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("selectorTimeout", (Object)1000, Messages.getString("TomcatManagerImpl.193"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useComet", (Object)true, Messages.getString("TomcatManagerImpl.195"), Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("processCache", (Object)200, Messages.getString("TomcatManagerImpl.197"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_directBuffer", (Object)false, Messages.getString("TomcatManagerImpl.199"), Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_rxBufSize", (Object)25188, Messages.getString("TomcatManagerImpl.201"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_txBufSize", (Object)43800, Messages.getString("TomcatManagerImpl.203"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_appReadBufSize", (Object)8192, Messages.getString("TomcatManagerImpl.205"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_appWriteBufSize", (Object)8192, Messages.getString("TomcatManagerImpl.207"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_bufferPool", (Object)500, Messages.getString("TomcatManagerImpl.209"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_bufferPoolSize", (Object)0x6400000, Messages.getString("TomcatManagerImpl.211"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_processorCache", (Object)500, Messages.getString("TomcatManagerImpl.213"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_keyCache", (Object)500, Messages.getString("TomcatManagerImpl.215"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_eventCache", (Object)500, Messages.getString("TomcatManagerImpl.217"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_tcpNoDelay", (Object)false, Messages.getString("TomcatManagerImpl.219"), Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_soKeepAlive", (Object)false, Messages.getString("TomcatManagerImpl.221"), Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_ooBInline", (Object)true, Messages.getString("TomcatManagerImpl.223"), Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_soReuseAddress", (Object)true, Messages.getString("TomcatManagerImpl.225"), Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_soLingerOn", (Object)true, Messages.getString("TomcatManagerImpl.227"), Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_soLingerTime", (Object)25, Messages.getString("TomcatManagerImpl.229"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_soTimeout", (Object)5000, Messages.getString("TomcatManagerImpl.231"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_soTrafficClass", (Object)28, Messages.getString("TomcatManagerImpl.233"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_performanceConnectionTime", (Object)1, Messages.getString("TomcatManagerImpl.235"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_performanceLatency", (Object)0, Messages.getString("TomcatManagerImpl.237"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("socket_performanceBandwidth", (Object)1, Messages.getString("TomcatManagerImpl.239"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("selectorPool_maxSelectors", (Object)200, Messages.getString("TomcatManagerImpl.241"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("selectorPool_maxSpareSelectors", (Object)-1, Messages.getString("TomcatManagerImpl.243"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("command_line_options", (Object)true, Messages.getString("TomcatManagerImpl.245"), Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("oomParachute", (Object)0x100000, Messages.getString("TomcatManagerImpl.247"), Integer.class));
    }

    private static void addAprConnectorAttributes(List<WebManager.ConnectorAttribute> connectorAttributes) {
        connectorAttributes.add(new WebManager.ConnectorAttribute("pollTime", (Object)2000, Messages.getString("TomcatManagerImpl.249"), Integer.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("pollerSize", (Object)8192, Messages.getString("TomcatManagerImpl.251"), Integer.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("useSendfile", (Object)true, Messages.getString("TomcatManagerImpl.253"), Boolean.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sendfileSize", (Object)1024, Messages.getString("TomcatManagerImpl.255"), Integer.class, true));
    }

    private static <T> void setAttribute(List<WebManager.ConnectorAttribute> connectorAttributes, String attributeName, T value) {
        for (WebManager.ConnectorAttribute connectorAttribute : connectorAttributes) {
            if (!connectorAttribute.getAttributeName().equals(attributeName)) continue;
            connectorAttribute.setValue(value);
            return;
        }
    }

    public WebManager.ConnectorType getConnectorType(AbstractName connectorName) {
        WebManager.ConnectorType connectorType = null;
        try {
            GBeanInfo info = this.kernel.getGBeanInfo(connectorName);
            boolean found = false;
            Set intfs = info.getInterfaces();
            Iterator it = intfs.iterator();
            while (it.hasNext() && !found) {
                String intf = (String)it.next();
                if (!intf.equals(TomcatWebConnector.class.getName())) continue;
                found = true;
            }
            if (!found) {
                throw new GBeanNotFoundException(connectorName);
            }
            String searchingFor = info.getName();
            for (Map.Entry<WebManager.ConnectorType, GBeanInfo> entry : CONNECTOR_GBEAN_INFOS.entrySet()) {
                String candidate = entry.getValue().getName();
                if (!candidate.equals(searchingFor)) continue;
                return entry.getKey();
            }
        }
        catch (GBeanNotFoundException e) {
            log.warn("No such GBean '" + connectorName + "'");
        }
        catch (Exception e) {
            log.error("Failed to get connector type", (Throwable)e);
        }
        return connectorType;
    }

    public void updateConnectorConfig(AbstractName connectorName) throws Exception {
        String serviceName;
        GBeanData containerGBeanData = null;
        try {
            GBeanData connectorGBeanData = this.kernel.getGBeanData(connectorName);
            ReferencePatterns rp = connectorGBeanData.getReferencePatterns("TomcatContainer");
            containerGBeanData = this.kernel.getGBeanData(rp.getAbstractName());
            Object object = containerGBeanData.getAttribute("serviceName");
            serviceName = object == null ? null : object.toString();
        }
        catch (GBeanNotFoundException e) {
            throw new Exception("Can't find connector GBean when updating connector config", e);
        }
        catch (InternalKernelException e) {
            throw new Exception("error to update conector config", e);
        }
        HashMap<String, String> attributesToUpdate = new HashMap<String, String>();
        String connectorUniqueName = (String)this.kernel.getAttribute(connectorName, "name");
        String tomcatProtocol = (String)this.kernel.getAttribute(connectorName, "tomcatProtocol");
        attributesToUpdate.put("protocol", tomcatProtocol);
        WebManager.ConnectorType connectorType = this.getConnectorType(connectorName);
        List<WebManager.ConnectorAttribute> defaultAttributes = this.getConnectorAttributes(connectorType);
        for (WebManager.ConnectorAttribute defaultAttribute : defaultAttributes) {
            String attributeName = defaultAttribute.getAttributeName();
            Object latestAttibuteValue = null;
            try {
                latestAttibuteValue = this.kernel.getAttribute(connectorName, attributeName);
            }
            catch (Exception e) {
                continue;
            }
            if (null == latestAttibuteValue) {
                if (!defaultAttributeNames.contains(attributeName)) continue;
                attributesToUpdate.put(attributeName, defaultAttribute.getStringValue());
                continue;
            }
            if (defaultAttribute.getValue() != null && defaultAttribute.getValue().equals(latestAttibuteValue)) {
                if (!defaultAttributeNames.contains(attributeName)) continue;
                attributesToUpdate.put(attributeName, defaultAttribute.getStringValue());
                continue;
            }
            WebManager.ConnectorAttribute latestAttibute = new WebManager.ConnectorAttribute(defaultAttribute);
            latestAttibute.setValue(latestAttibuteValue);
            attributesToUpdate.put(attributeName, latestAttibute.getStringValue());
        }
        this.tomcatServerConfigManager.updateConnector(attributesToUpdate, connectorUniqueName, serviceName);
    }

    private boolean isNativeAPRLibInstalled() {
        try {
            Connector connector = new Connector("HTTP/1.1");
            if (!connector.getProtocolHandlerClassName().equalsIgnoreCase("org.apache.coyote.http11.Http11AprProtocol")) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    static {
        ArrayList<Object> connectorAttributes = new ArrayList<WebManager.ConnectorAttribute>();
        TomcatManagerImpl.addCommonConnectorAttributes(connectorAttributes);
        TomcatManagerImpl.addHttpConnectorAttributes(connectorAttributes);
        CONNECTOR_ATTRIBUTES.put(HTTP_BIO, connectorAttributes);
        connectorAttributes = new ArrayList();
        TomcatManagerImpl.addCommonConnectorAttributes(connectorAttributes);
        TomcatManagerImpl.addHttpConnectorAttributes(connectorAttributes);
        TomcatManagerImpl.addSslConnectorAttributes(connectorAttributes);
        TomcatManagerImpl.setAttribute(connectorAttributes, "port", 8443);
        CONNECTOR_ATTRIBUTES.put(HTTPS_BIO, connectorAttributes);
        connectorAttributes = new ArrayList();
        TomcatManagerImpl.addCommonConnectorAttributes(connectorAttributes);
        TomcatManagerImpl.addHttpConnectorAttributes(connectorAttributes);
        TomcatManagerImpl.addNioConnectorAttributes(connectorAttributes);
        CONNECTOR_ATTRIBUTES.put(HTTP_NIO, connectorAttributes);
        connectorAttributes = new ArrayList();
        TomcatManagerImpl.addCommonConnectorAttributes(connectorAttributes);
        TomcatManagerImpl.addHttpConnectorAttributes(connectorAttributes);
        TomcatManagerImpl.addSslConnectorAttributes(connectorAttributes);
        TomcatManagerImpl.addNioConnectorAttributes(connectorAttributes);
        TomcatManagerImpl.setAttribute(connectorAttributes, "port", 8443);
        CONNECTOR_ATTRIBUTES.put(HTTPS_NIO, connectorAttributes);
        connectorAttributes = new ArrayList();
        TomcatManagerImpl.addCommonConnectorAttributes(connectorAttributes);
        TomcatManagerImpl.addHttpConnectorAttributes(connectorAttributes);
        TomcatManagerImpl.addAprConnectorAttributes(connectorAttributes);
        CONNECTOR_ATTRIBUTES.put(HTTP_APR, connectorAttributes);
        connectorAttributes = new ArrayList();
        TomcatManagerImpl.addCommonConnectorAttributes(connectorAttributes);
        TomcatManagerImpl.addHttpConnectorAttributes(connectorAttributes);
        TomcatManagerImpl.addAprConnectorAttributes(connectorAttributes);
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslProtocol", (Object)"all", Messages.getString("TomcatManagerImpl.11"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslCipherSuite", (Object)"ALL", Messages.getString("TomcatManagerImpl.14"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslCertificateFile", (Object)"", Messages.getString("TomcatManagerImpl.17"), String.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslCertificateKeyFile", null, Messages.getString("TomcatManagerImpl.19"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslPassword", null, Messages.getString("TomcatManagerImpl.21"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslVerifyClient", (Object)"none", Messages.getString("TomcatManagerImpl.24"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslVerifyDepth", (Object)10, Messages.getString("TomcatManagerImpl.26"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslCACertificateFile", null, Messages.getString("TomcatManagerImpl.28"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslCACertificatePath", null, Messages.getString("TomcatManagerImpl.30"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslCertificateChainFile", null, Messages.getString("TomcatManagerImpl.32"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslCARevocationFile", null, Messages.getString("TomcatManagerImpl.34"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("sslCARevocationPath", null, Messages.getString("TomcatManagerImpl.36"), String.class));
        TomcatManagerImpl.setAttribute(connectorAttributes, "port", 8443);
        CONNECTOR_ATTRIBUTES.put(HTTPS_APR, connectorAttributes);
        connectorAttributes = new ArrayList();
        TomcatManagerImpl.addCommonConnectorAttributes(connectorAttributes);
        connectorAttributes.add(new WebManager.ConnectorAttribute("host", (Object)"0.0.0.0", Messages.getString("TomcatManagerImpl.40"), String.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("port", (Object)8009, Messages.getString("TomcatManagerImpl.42"), Integer.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("backlog", (Object)10, Messages.getString("TomcatManagerImpl.44"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("bufferSize", (Object)-1, Messages.getString("TomcatManagerImpl.46"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("connectionTimeout", (Object)-1, Messages.getString("TomcatManagerImpl.48"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("executor", (Object)"DefaultThreadPool", Messages.getString("TomcatManagerImpl.122"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("keepAliveTimeout", (Object)-1, Messages.getString("TomcatManagerImpl.50"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxThreads", (Object)40, Messages.getString("TomcatManagerImpl.52"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("minSpareThreads", (Object)10, Messages.getString("TomcatManagerImpl.54"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxSpareThreads", (Object)100, Messages.getString("TomcatManagerImpl.56"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("tcpNoDelay", (Object)true, Messages.getString("TomcatManagerImpl.58"), Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("tomcatAuthentication", (Object)true, Messages.getString("TomcatManagerImpl.60"), Boolean.class));
        CONNECTOR_ATTRIBUTES.put(AJP, connectorAttributes);
        CONNECTOR_GBEAN_INFOS = new HashMap<WebManager.ConnectorType, GBeanInfo>();
        defaultAttributeNames = new ArrayList<String>();
        annotationGbeanInfoFactory = new AnnotationGBeanInfoFactory();
        CONNECTOR_GBEAN_INFOS.put(HTTP_BIO, annotationGbeanInfoFactory.getGBeanInfo(Http11ConnectorGBean.class));
        CONNECTOR_GBEAN_INFOS.put(HTTPS_BIO, annotationGbeanInfoFactory.getGBeanInfo(Https11ConnectorGBean.class));
        CONNECTOR_GBEAN_INFOS.put(HTTP_NIO, annotationGbeanInfoFactory.getGBeanInfo(Http11NIOConnectorGBean.class));
        CONNECTOR_GBEAN_INFOS.put(HTTPS_NIO, annotationGbeanInfoFactory.getGBeanInfo(Https11NIOConnectorGBean.class));
        CONNECTOR_GBEAN_INFOS.put(HTTP_APR, annotationGbeanInfoFactory.getGBeanInfo(Http11APRConnectorGBean.class));
        CONNECTOR_GBEAN_INFOS.put(HTTPS_APR, annotationGbeanInfoFactory.getGBeanInfo(Https11APRConnectorGBean.class));
        CONNECTOR_GBEAN_INFOS.put(AJP, annotationGbeanInfoFactory.getGBeanInfo(AJP13ConnectorGBean.class));
        defaultAttributeNames.add("name");
        defaultAttributeNames.add("protocol");
        defaultAttributeNames.add("host");
        defaultAttributeNames.add("port");
        defaultAttributeNames.add("executor");
        defaultAttributeNames.add("redirectPort");
        defaultAttributeNames.add("connectionTimeout");
        defaultAttributeNames.add("scheme");
        defaultAttributeNames.add("secure");
        defaultAttributeNames.add("sslProtocol");
        defaultAttributeNames.add("sslEnabled");
    }
}

