/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.io.File;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardService;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.management.geronimo.NetworkConnector;
import org.apache.geronimo.management.geronimo.WebManager;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.jaas.ConfigurationFactory;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.tomcat.EjbWsContextConfig;
import org.apache.geronimo.tomcat.GeronimoStandardContext;
import org.apache.geronimo.tomcat.LifecycleListenerGBean;
import org.apache.geronimo.tomcat.ObjectRetriever;
import org.apache.geronimo.tomcat.TomcatContext;
import org.apache.geronimo.tomcat.TomcatEJBWebServiceContext;
import org.apache.geronimo.tomcat.TomcatServerGBean;
import org.apache.geronimo.tomcat.TomcatWebContainer;
import org.apache.geronimo.tomcat.WebContextConfig;
import org.apache.geronimo.webservices.SoapHandler;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.apache.naming.resources.DirContextURLStreamHandlerFactory;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class TomcatContainer
implements SoapHandler,
GBeanLifecycle,
TomcatWebContainer {
    private static final Logger log = LoggerFactory.getLogger(TomcatContainer.class);
    private static final String DEFAULT_CATALINA_HOME = "var/catalina";
    private Service embedded;
    private final Engine engine;
    private final Map<String, Context> webServices = new HashMap<String, Context>();
    private final String objectName;
    private final String[] applicationListeners;
    private final WebManager manager;
    private static boolean first = true;
    private final BundleContext bundleContext;
    private final ClassLoader classLoader;

    public TomcatContainer(@ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader classLoader, @ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext, @ParamAttribute(name="catalinaHome") String catalinaHome, @ParamAttribute(name="applicationListeners") String[] applicationListeners, @ParamReference(name="Server") TomcatServerGBean server, @ParamAttribute(name="serviceName") String serviceName, @ParamReference(name="EngineGBean") ObjectRetriever engineGBean, @ParamReference(name="ListenerChain") LifecycleListenerGBean listenerChain, @ParamReference(name="ServerInfo") ServerInfo serverInfo, @ParamSpecial(type=SpecialAttributeType.objectName) String objectName, @ParamReference(name="WebManager") WebManager manager) throws MalformedObjectNameException, LifecycleException {
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader cannot be null.");
        }
        if (bundleContext == null) {
            throw new IllegalArgumentException("bundleContext cannot be null.");
        }
        if (engineGBean == null && server == null) {
            throw new IllegalArgumentException("Server and EngineGBean cannot both be null.");
        }
        this.bundleContext = bundleContext;
        this.classLoader = classLoader;
        DirContextURLStreamHandlerFactory streamHandlerFactory = new DirContextURLStreamHandlerFactory();
        if (first) {
            first = false;
            try {
                URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)streamHandlerFactory);
            }
            catch (Exception e) {
                log.error("Error registering jndi stream handler", (Throwable)e);
            }
            catch (Throwable t) {
                log.info("Dual registration of jndi stream handler: " + t.getMessage());
            }
        }
        if (catalinaHome == null) {
            catalinaHome = DEFAULT_CATALINA_HOME;
        }
        catalinaHome = serverInfo.resolveServerPath(catalinaHome);
        System.setProperty("catalina.home", catalinaHome);
        if (server != null) {
            this.embedded = server.getService(serviceName);
            this.engine = (Engine)this.embedded.getContainer();
        } else {
            this.engine = (Engine)engineGBean.getInternalObject();
            StandardService embedded = new StandardService();
            File rootContext = new File(catalinaHome + "/ROOT");
            String docBase = "";
            if (rootContext.exists()) {
                docBase = "ROOT";
            }
            Container[] hosts = this.engine.findChildren();
            ObjectName objName = objectName == null ? null : ObjectName.getInstance(objectName);
            for (Container host : hosts) {
                Context defaultContext = this.createContext("", classLoader, null);
                defaultContext.setDocBase(docBase);
                if (objName != null) {
                    defaultContext.setName(objName.getKeyProperty("name"));
                }
                if (defaultContext instanceof GeronimoStandardContext) {
                    GeronimoStandardContext ctx = (GeronimoStandardContext)defaultContext;
                    ctx.setJ2EEApplication(null);
                    ctx.setJ2EEServer(objName == null ? "geronimo" : objName.getKeyProperty("J2EEServer"));
                    ctx.setJavaVMs(new String[0]);
                    ctx.setServer(objName == null ? "geronimo" : objName.getKeyProperty("J2EEServer"));
                }
                host.addChild((Container)defaultContext);
            }
            embedded.setContainer((Container)this.engine);
            if (listenerChain != null) {
                for (LifecycleListenerGBean listenerGBean = listenerChain; listenerGBean != null; listenerGBean = listenerGBean.getNextListener()) {
                    embedded.addLifecycleListener((LifecycleListener)listenerGBean.getInternalObject());
                }
            }
            embedded.start();
            this.embedded = embedded;
        }
        this.objectName = objectName;
        this.applicationListeners = applicationListeners;
        this.manager = manager;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return true;
    }

    public NetworkConnector[] getConnectors() {
        return this.manager.getConnectorsForContainer((Object)this);
    }

    public NetworkConnector[] getConnectors(String protocol) {
        return this.manager.getConnectorsForContainer((Object)this, protocol);
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doStart() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("doStart()");
            log.debug("Java Endorsed Dirs set to:" + System.getProperty("java.endorsed.dirs"));
            log.debug("Java Ext Dirs set to:" + System.getProperty("java.ext.dirs"));
        }
    }

    public void doStop() throws Exception {
        if (this.embedded instanceof Lifecycle) {
            this.embedded.stop();
        }
    }

    public void addContext(TomcatContext contextInfo) throws Exception {
        Collection<String> listeners;
        Container host;
        Context context = this.createContext(contextInfo.getContextPath(), contextInfo.getClassLoader(), contextInfo.getDeploymentDescriptor());
        String virtualServer = contextInfo.getVirtualServer();
        if (virtualServer == null) {
            virtualServer = this.engine.getDefaultHost();
        }
        if ((host = this.engine.findChild(virtualServer)) == null) {
            throw new IllegalArgumentException("Invalid virtual host '" + virtualServer + "'.  Do you have a matching Host entry in the plan?");
        }
        context.setParent(host);
        context.getServletContext().setAttribute("osgi-bundlecontext", (Object)contextInfo.getBundle().getBundleContext());
        contextInfo.setContext(context);
        if (context instanceof GeronimoStandardContext) {
            ((GeronimoStandardContext)context).setContextProperties(contextInfo);
        }
        if (this.applicationListeners != null) {
            for (String listener : this.applicationListeners) {
                context.addApplicationListener(listener);
            }
        }
        if ((listeners = contextInfo.getListeners()) != null) {
            for (String listener : listeners) {
                context.addApplicationListener(listener);
            }
        }
        try {
            host.addChild((Container)context);
        }
        catch (IllegalArgumentException ex) {
            log.error("Unable to add the child container: " + context.getName() + " .  Please check if your project's context-root is unique.", (Throwable)ex);
        }
    }

    public void removeContext(TomcatContext ctx) {
        Context context = ctx.getContext();
        if (context != null) {
            if (context instanceof GeronimoStandardContext) {
                GeronimoStandardContext stdctx = (GeronimoStandardContext)context;
                try {
                    stdctx.kill();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (context.getParent() != null) {
                context.getParent().removeChild((Container)context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnector(Connector connector) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.embedded.addConnector(connector);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public void removeConnector(Connector connector) {
        this.embedded.removeConnector(connector);
    }

    public void addWebService(String contextPath, String[] virtualHosts, WebServiceContainer webServiceContainer, String policyContextId, ConfigurationFactory configurationFactory, String realmName, String authMethod, Properties properties, ClassLoader classLoader) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Creating EJBWebService context '" + contextPath + "'.");
        }
        TomcatEJBWebServiceContext context = new TomcatEJBWebServiceContext(contextPath, webServiceContainer, classLoader);
        Subject defaultSubject = ContextManager.EMPTY;
        EjbWsContextConfig config = new EjbWsContextConfig(policyContextId, configurationFactory, defaultSubject, authMethod, realmName);
        context.addLifecycleListener((LifecycleListener)config);
        TomcatEJBWebServiceContext webServiceContext = context;
        String virtualServer = virtualHosts != null && virtualHosts.length > 0 ? virtualHosts[0] : this.engine.getDefaultHost();
        Container host = this.engine.findChild(virtualServer);
        if (host == null) {
            throw new IllegalArgumentException("Invalid virtual host '" + virtualServer + "'.  Do you have a matchiing Host entry in the plan?");
        }
        host.addChild((Container)webServiceContext);
        this.webServices.put(contextPath, (Context)webServiceContext);
    }

    public void removeWebService(String contextPath) {
        TomcatEJBWebServiceContext context = (TomcatEJBWebServiceContext)this.webServices.get(contextPath);
        try {
            context.stop();
            context.destroy();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        context.getParent().removeChild((Container)context);
        this.webServices.remove(contextPath);
    }

    public Context createContext(String path, ClassLoader cl, String deploymentDescriptor) {
        if (log.isDebugEnabled()) {
            log.debug("Creating context '" + path);
        }
        GeronimoStandardContext context = new GeronimoStandardContext();
        context.setPath(path);
        if (cl != null) {
            context.setParentClassLoader(cl);
        }
        WebContextConfig config = new WebContextConfig(deploymentDescriptor);
        context.addLifecycleListener((LifecycleListener)config);
        context.setDelegate(true);
        return context;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }
}

