/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.naming.Context;
import javax.naming.directory.DirContext;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Engine;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.valves.ValveBase;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.common.GeronimoSecurityException;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.osgi.web.WebApplicationUtils;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.jaas.ConfigurationFactory;
import org.apache.geronimo.security.jacc.RunAsSource;
import org.apache.geronimo.tomcat.BundleDirContext;
import org.apache.geronimo.tomcat.TomcatContext;
import org.apache.geronimo.tomcat.TomcatWebAppContext;
import org.apache.geronimo.tomcat.core.GeronimoApplicationContext;
import org.apache.geronimo.tomcat.interceptor.BeforeAfter;
import org.apache.geronimo.tomcat.interceptor.ComponentContextBeforeAfter;
import org.apache.geronimo.tomcat.interceptor.InstanceContextBeforeAfter;
import org.apache.geronimo.tomcat.interceptor.UserTransactionBeforeAfter;
import org.apache.geronimo.tomcat.listener.DispatchListener;
import org.apache.geronimo.tomcat.listener.JACCSecurityLifecycleListener;
import org.apache.geronimo.tomcat.listener.RunAsInstanceListener;
import org.apache.geronimo.tomcat.util.SecurityHolder;
import org.apache.geronimo.tomcat.valve.GeronimoBeforeAfterValve;
import org.apache.geronimo.tomcat.valve.ProtectedTargetValve;
import org.apache.geronimo.web.WebAttributeName;
import org.apache.geronimo.webservices.POJOWebServiceServlet;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.apache.geronimo.webservices.WebServiceContainerInvoker;
import org.apache.naming.resources.FileDirContext;
import org.apache.tomcat.InstanceManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;

public class GeronimoStandardContext
extends StandardContext {
    private static final long serialVersionUID = 3834587716552831032L;
    private static final boolean allowLinking = Boolean.getBoolean("org.apache.geronimo.tomcat.GeronimoStandardContext.allowLinking");
    private Subject defaultSubject = null;
    private RunAsSource runAsSource = RunAsSource.NULL;
    private Map webServiceMap = null;
    private boolean pipelineInitialized;
    private BeforeAfter beforeAfter = null;
    private int contextCount = 0;
    private boolean authenticatorInstalled;
    private ConfigurationFactory configurationFactory;
    private String policyContextId;
    private Bundle bundle;
    private ServiceRegistration serviceRegistration;
    private final Object instanceListenersLock = new Object();
    private final Object wrapperLifecyclesLock = new Object();
    private final Object wrapperListenersLock = new Object();

    public GeronimoStandardContext() {
        this.setXmlNamespaceAware(true);
        this.setProcessTlds(false);
        this.setUseHttpOnly(false);
        this.setXmlValidation(false);
    }

    public void setContextProperties(TomcatContext ctx) throws DeploymentException {
        Manager manager;
        CatalinaCluster cluster;
        List listenerChain;
        SecurityHolder securityHolder;
        this.bundle = ctx.getBundle();
        this.setResources(this.createDirContext(ctx));
        Context enc = ctx.getJndiContext();
        this.setInstanceManager(ctx.getInstanceManager());
        if (ctx instanceof TomcatWebAppContext) {
            ServletContext servletContext;
            TomcatWebAppContext tomcatWebAppContext = (TomcatWebAppContext)ctx;
            this.setJavaVMs(tomcatWebAppContext.getJavaVMs());
            this.setServer(tomcatWebAppContext.getServer());
            this.setJ2EEApplication(tomcatWebAppContext.getJ2EEApplication());
            this.setJ2EEServer(tomcatWebAppContext.getJ2EEServer());
            if (tomcatWebAppContext.getRuntimeCustomizer() != null) {
                servletContext = new HashMap();
                HashMap<Class, Object> customizerContext = new HashMap<Class, Object>();
                customizerContext.put(Map.class, servletContext);
                customizerContext.put(Context.class, enc);
                tomcatWebAppContext.getRuntimeCustomizer().customize(customizerContext);
                for (Map.Entry entry : servletContext.entrySet()) {
                    this.getServletContext().setAttribute((String)entry.getKey(), entry.getValue());
                }
            }
            if (tomcatWebAppContext.getSecurityHolder() != null) {
                this.configurationFactory = tomcatWebAppContext.getSecurityHolder().getConfigurationFactory();
                this.addJACCSecurityLifecycleListener(tomcatWebAppContext);
            }
            servletContext = this.getServletContext();
            servletContext.setAttribute(InstanceManager.class.getName(), (Object)ctx.getInstanceManager());
            List orderedLists = (List)tomcatWebAppContext.getDeploymentAttribute(WebAttributeName.ORDERED_LIBS.name());
            if (orderedLists != null) {
                servletContext.setAttribute("javax.servlet.context.orderedLibs", Collections.unmodifiableList(orderedLists));
            }
            Map servletContainerInitializerClassNamesMap = (Map)tomcatWebAppContext.getDeploymentAttribute(WebAttributeName.SERVLET_CONTAINER_INITIALIZERS.name());
            Bundle bundle = tomcatWebAppContext.getBundle();
            if (servletContainerInitializerClassNamesMap != null) {
                for (Map.Entry entry : servletContainerInitializerClassNamesMap.entrySet()) {
                    String servletContainerInitializerClassName = (String)entry.getKey();
                    Set classNames = (Set)entry.getValue();
                    try {
                        ServletContainerInitializer servletContainerInitializer = (ServletContainerInitializer)bundle.loadClass(servletContainerInitializerClassName).newInstance();
                        if (classNames == null || classNames.size() == 0) {
                            this.addServletContainerInitializer(servletContainerInitializer, null);
                            continue;
                        }
                        HashSet<Class> classSet = new HashSet<Class>();
                        for (String cls : classNames) {
                            try {
                                classSet.add(bundle.loadClass(cls));
                            }
                            catch (ClassNotFoundException e) {
                                this.logger.warn((Object)("Fail to load class " + cls + " interested by ServletContainerInitializer " + servletContainerInitializerClassName), (Throwable)e);
                            }
                        }
                        this.addServletContainerInitializer(servletContainerInitializer, classSet);
                    }
                    catch (IllegalAccessException e) {
                        this.logger.error((Object)("Fail to initialize ServletContainerInitializer " + servletContainerInitializerClassName), (Throwable)e);
                    }
                    catch (InstantiationException e) {
                        this.logger.error((Object)("Fail to initialize ServletContainerInitializer " + servletContainerInitializerClassName), (Throwable)e);
                    }
                    catch (ClassNotFoundException e) {
                        this.logger.error((Object)("Fail to initialize ServletContainerInitializer " + servletContainerInitializerClassName), (Throwable)e);
                    }
                }
            }
        }
        int index = 0;
        BeforeAfter interceptor = new InstanceContextBeforeAfter(null, index++, index++, ctx.getUnshareableResources(), ctx.getApplicationManagedSecurityResources(), ctx.getTrackedConnectionAssociator());
        if (enc != null) {
            interceptor = new ComponentContextBeforeAfter(interceptor, index++, enc);
        }
        if ((securityHolder = ctx.getSecurityHolder()) != null) {
            this.runAsSource = securityHolder.getRunAsSource();
            if (securityHolder.getPolicyContextID() != null) {
                this.policyContextId = securityHolder.getPolicyContextID();
                PolicyContext.setContextID((String)this.policyContextId);
                this.defaultSubject = securityHolder.getDefaultSubject();
                if (this.defaultSubject == null) {
                    this.defaultSubject = ContextManager.EMPTY;
                }
            }
        }
        interceptor = new UserTransactionBeforeAfter(interceptor, index++, ctx.getUserTransaction());
        this.addValve((Valve)new ProtectedTargetValve());
        Valve clusteredValve = ctx.getClusteredValve();
        if (null != clusteredValve) {
            this.addValve(clusteredValve);
        }
        GeronimoBeforeAfterValve geronimoBAValve = new GeronimoBeforeAfterValve(interceptor, index);
        this.addValve((Valve)geronimoBAValve);
        this.beforeAfter = interceptor;
        this.contextCount = index;
        this.addValve((Valve)new SystemMethodValve());
        List valveChain = ctx.getValveChain();
        if (valveChain != null) {
            for (Object valve : valveChain) {
                this.addValve((Valve)valve);
            }
        }
        if ((listenerChain = ctx.getLifecycleListenerChain()) != null) {
            for (Object listener : listenerChain) {
                this.addLifecycleListener((LifecycleListener)listener);
            }
        }
        if ((cluster = ctx.getCluster()) != null) {
            this.setCluster((Cluster)cluster);
        }
        if ((manager = ctx.getManager()) != null) {
            this.setManager(manager);
        }
        this.pipelineInitialized = true;
        this.webServiceMap = ctx.getWebServices();
        this.setCrossContext(ctx.isCrossContext());
        this.setWorkDir(ctx.getWorkDir());
        super.setAllowLinking(allowLinking);
        this.setCookies(!ctx.isDisableCookies());
        this.addInstanceListener(DispatchListener.class.getName());
        if (this.runAsSource != null) {
            this.addInstanceListener(RunAsInstanceListener.class.getName());
        }
    }

    private void addJACCSecurityLifecycleListener(TomcatWebAppContext tomcatWebAppContext) throws DeploymentException {
        float schemaVersion = ((Float)tomcatWebAppContext.getDeploymentAttribute(WebAttributeName.SCHEMA_VERSION.name())).floatValue();
        boolean metaComplete = (Boolean)tomcatWebAppContext.getDeploymentAttribute(WebAttributeName.META_COMPLETE.name());
        this.addLifecycleListener(new JACCSecurityLifecycleListener(this.bundle, tomcatWebAppContext.getDeploymentDescriptor(), schemaVersion >= 2.5f && !metaComplete, tomcatWebAppContext.getApplicationPolicyConfigurationManager(), tomcatWebAppContext.getSecurityHolder().getPolicyContextID()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Wrapper createWrapper() {
        InstanceListener listener;
        StandardWrapper wrapper = null;
        if (this.getWrapperClass() != null) {
            try {
                wrapper = (Wrapper)this.getInstanceManager().newInstance(this.getWrapperClass());
            }
            catch (Throwable t) {
                this.getLogger().error((Object)"createWrapper", t);
                return null;
            }
        } else {
            wrapper = new StandardWrapper();
        }
        Object object = this.instanceListenersLock;
        synchronized (object) {
            for (String instanceListener : this.findInstanceListeners()) {
                try {
                    listener = (InstanceListener)this.getInstanceManager().newInstance(instanceListener);
                    wrapper.addInstanceListener(listener);
                }
                catch (Throwable t) {
                    this.getLogger().error((Object)"createWrapper", t);
                    return null;
                }
            }
        }
        object = this.wrapperLifecyclesLock;
        synchronized (object) {
            for (String wrapperLifecycle : this.findWrapperLifecycles()) {
                try {
                    listener = (LifecycleListener)this.getInstanceManager().newInstance(wrapperLifecycle);
                    if (!(wrapper instanceof Lifecycle)) continue;
                    wrapper.addLifecycleListener((LifecycleListener)listener);
                }
                catch (Throwable t) {
                    this.getLogger().error((Object)"createWrapper", t);
                    return null;
                }
            }
        }
        object = this.wrapperListenersLock;
        synchronized (object) {
            for (String wrapperListener : this.findWrapperListeners()) {
                try {
                    listener = (ContainerListener)this.getInstanceManager().newInstance(wrapperListener);
                    wrapper.addContainerListener((ContainerListener)listener);
                }
                catch (Throwable t) {
                    this.getLogger().error((Object)"createWrapper", t);
                    return null;
                }
            }
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backgroundProcess() {
        Object[] context = null;
        if (this.beforeAfter != null) {
            context = new Object[this.contextCount];
            this.beforeAfter.before(context, null, null, 0);
        }
        try {
            super.backgroundProcess();
        }
        finally {
            if (this.beforeAfter != null) {
                this.beforeAfter.after(context, null, null, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws Exception {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
        Object[] context = null;
        if (this.beforeAfter != null) {
            context = new Object[this.contextCount];
            this.beforeAfter.before(context, null, null, 0);
        }
        try {
            this.stop();
            this.destroy();
        }
        finally {
            if (this.beforeAfter != null) {
                this.beforeAfter.after(context, null, null, 0);
            }
        }
    }

    protected void initInternal() throws LifecycleException {
        String docBase = this.getDocBase();
        super.initInternal();
        this.setDocBase(docBase);
    }

    /*
     * Unable to fully structure code
     */
    protected void startInternal() throws LifecycleException {
        if (this.pipelineInitialized) {
            try {
                valve = this.getPipeline().getFirst();
                valve.invoke(null, null);
                if (this.hasRunAsServlet()) {
                    if (this.runAsSource != null) ** GOTO lbl17
                    throw new GeronimoSecurityException("web.xml or annotation specifies a run-as role but no subject configuration supplied for run-as roles");
                }
                this.removeInstanceListener(RunAsInstanceListener.class.getName());
            }
            catch (IOException e) {
                if (e.getCause() instanceof LifecycleException) {
                    throw (LifecycleException)e.getCause();
                }
                throw new LifecycleException((Throwable)e);
            }
            catch (ServletException e) {
                throw new LifecycleException((Throwable)e);
            }
        } else {
            super.startInternal();
        }
lbl17:
        // 3 sources

        if (WebApplicationUtils.isWebApplicationBundle((Bundle)this.bundle)) {
            this.serviceRegistration = WebApplicationUtils.registerServletContext((Bundle)this.bundle, (ServletContext)this.getServletContext());
        }
    }

    public void addChild(Container child) {
        Wrapper wrapper = (Wrapper)child;
        String servletClassName = wrapper.getServletClass();
        if (servletClassName == null) {
            super.addChild(child);
            return;
        }
        ClassLoader cl = this.getParentClassLoader();
        try {
            WebServiceContainer webServiceContainer;
            Class<?> baseServletClass = cl.loadClass(Servlet.class.getName());
            Class<?> servletClass = cl.loadClass(servletClassName);
            if (!baseServletClass.isAssignableFrom(servletClass) && this.webServiceMap != null && (webServiceContainer = (WebServiceContainer)this.webServiceMap.get(wrapper.getName())) != null) {
                wrapper.setServletClass("org.apache.geronimo.webservices.POJOWebServiceServlet");
                String webServicecontainerID = wrapper.getName() + WebServiceContainerInvoker.WEBSERVICE_CONTAINER + webServiceContainer.hashCode();
                this.getServletContext().setAttribute(webServicecontainerID, (Object)webServiceContainer);
                wrapper.addInitParameter(WebServiceContainerInvoker.WEBSERVICE_CONTAINER, webServicecontainerID);
                String pojoClassID = wrapper.getName() + POJOWebServiceServlet.POJO_CLASS + servletClass.hashCode();
                this.getServletContext().setAttribute(pojoClassID, servletClass);
                wrapper.addInitParameter(POJOWebServiceServlet.POJO_CLASS, pojoClassID);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        super.addChild(child);
    }

    public synchronized void setLoader(final Loader delegate) {
        Loader loader = new Loader(){

            public void backgroundProcess() {
                delegate.backgroundProcess();
            }

            public ClassLoader getClassLoader() {
                return GeronimoStandardContext.this.parentClassLoader;
            }

            public Container getContainer() {
                return delegate.getContainer();
            }

            public void setContainer(Container container) {
                delegate.setContainer(container);
            }

            public boolean getDelegate() {
                return delegate.getDelegate();
            }

            public void setDelegate(boolean delegateBoolean) {
                delegate.setDelegate(delegateBoolean);
            }

            public String getInfo() {
                return delegate.getInfo();
            }

            public boolean getReloadable() {
                return false;
            }

            public void setReloadable(boolean reloadable) {
                if (reloadable) {
                    throw new UnsupportedOperationException("Reloadable context is not supported.");
                }
            }

            public void addPropertyChangeListener(PropertyChangeListener listener) {
                delegate.addPropertyChangeListener(listener);
            }

            public void addRepository(String repository) {
                delegate.addRepository(repository);
            }

            public String[] findRepositories() {
                return delegate.findRepositories();
            }

            public boolean modified() {
                return delegate.modified();
            }

            public void removePropertyChangeListener(PropertyChangeListener listener) {
                delegate.removePropertyChangeListener(listener);
            }
        };
        super.setLoader(loader);
    }

    public ServletContext getServletContext() {
        if (this.context == null) {
            this.context = new GeronimoApplicationContext(this);
            if (this.getAltDDName() != null) {
                this.context.setAttribute("org.apache.catalina.deploy.alt_dd", (Object)this.getAltDDName());
            }
        }
        return super.getServletContext();
    }

    public ServletContext getInternalServletContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DirContext createDirContext(TomcatContext tomcatContext) throws DeploymentException {
        ArrayList<DirContext> altDirContexts = new ArrayList<DirContext>();
        Engine engine = (Engine)this.getParent().getParent();
        String serviceName = engine.getService().getName();
        String engineName = engine.getName();
        String hostName = this.getParent().getName();
        String tomcatHome = System.getProperty("catalina.home");
        File resourceRootDirectory = new File(tomcatHome + File.separator + "resources" + File.separator + serviceName + File.separator + engineName + File.separator + hostName + File.separator + (this.getName().equals("/") ? "_" : this.getName()));
        File completeFlagFile = new File(resourceRootDirectory, "complete.flag");
        try {
            completeFlagFile.delete();
            FileUtils.recursiveDelete((File)resourceRootDirectory);
            resourceRootDirectory.mkdirs();
            Enumeration en = tomcatContext.getBundle().findEntries(tomcatContext.getModulePath() != null ? tomcatContext.getModulePath() + "/WEB-INF/lib" : "WEB-INF/lib", "*.jar", false);
            if (en != null) {
                while (en.hasMoreElements()) {
                    URL jarUrl = (URL)en.nextElement();
                    File jarResourceDirectory = new File(resourceRootDirectory, jarUrl.getFile().substring(jarUrl.getFile().lastIndexOf(47) + 1));
                    jarResourceDirectory.mkdirs();
                    ZipInputStream in = null;
                    try {
                        ZipEntry zipEntry;
                        in = new ZipInputStream(jarUrl.openStream());
                        while ((zipEntry = in.getNextEntry()) != null) {
                            String name = zipEntry.getName();
                            if (name.indexOf("META-INF/resources") != 0) continue;
                            if (zipEntry.isDirectory()) {
                                new File(jarResourceDirectory, name).mkdirs();
                                continue;
                            }
                            File resourceFile = new File(jarResourceDirectory, name);
                            resourceFile.getParentFile().mkdirs();
                            FileOutputStream out = null;
                            try {
                                out = new FileOutputStream(resourceFile);
                                IOUtils.copy((InputStream)in, (OutputStream)out);
                            }
                            catch (Throwable throwable) {
                                IOUtils.close(out);
                                throw throwable;
                            }
                            IOUtils.close((Closeable)out);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(in);
                        throw throwable;
                    }
                    IOUtils.close((Closeable)in);
                }
            }
            completeFlagFile.createNewFile();
        }
        catch (IOException e) {
            throw new DeploymentException("Fail to create static resoruce cache for jar files in WEB-INF folder", (Throwable)e);
        }
        File[] arr$ = resourceRootDirectory.listFiles();
        int len$ = arr$.length;
        int i$ = 0;
        while (i$ < len$) {
            File resourceDirectory = arr$[i$];
            if (resourceDirectory.isDirectory() && resourceDirectory.getName().endsWith(".jar") && resourceDirectory.listFiles().length > 0) {
                FileDirContext fileDirContext = new FileDirContext();
                fileDirContext.setAllowLinking(allowLinking);
                fileDirContext.setDocBase(resourceDirectory.getAbsolutePath());
                altDirContexts.add((DirContext)fileDirContext);
            }
            ++i$;
        }
        return new BundleDirContext(tomcatContext.getBundle(), tomcatContext.getModulePath(), altDirContexts);
    }

    public BeforeAfter getBeforeAfter() {
        return this.beforeAfter;
    }

    public int getContextCount() {
        return this.contextCount;
    }

    protected boolean hasRunAsServlet() {
        for (Container servlet : this.findChildren()) {
            if (!(servlet instanceof Wrapper) || ((Wrapper)servlet).getRunAs() == null) continue;
            return true;
        }
        return false;
    }

    public Subject getSubjectForRole(String runAsRole) {
        return this.runAsSource.getSubjectForRole(runAsRole);
    }

    public boolean isAuthenticatorInstalled() {
        return this.authenticatorInstalled;
    }

    public void setAuthenticatorInstalled(boolean authenticatorInstalled) {
        this.authenticatorInstalled = authenticatorInstalled;
    }

    public ConfigurationFactory getConfigurationFactory() {
        return this.configurationFactory;
    }

    public Subject getDefaultSubject() {
        return this.defaultSubject;
    }

    public String getPolicyContextId() {
        return this.policyContextId;
    }

    public String getBasePath() {
        if (this.getDocBase() == null) {
            return null;
        }
        return super.getBasePath();
    }

    private class SystemMethodValve
    extends ValveBase {
        public SystemMethodValve() {
            super(true);
        }

        public void invoke(Request request, Response response) throws IOException, ServletException {
            if (request == null && response == null) {
                try {
                    GeronimoStandardContext.super.startInternal();
                }
                catch (LifecycleException e) {
                    throw (IOException)new IOException("wrapping lifecycle exception").initCause(e);
                }
                if (!GeronimoStandardContext.this.getAvailable()) {
                    throw new IOException("Context did not start for an unknown reason");
                }
            } else {
                this.getNext().invoke(request, response);
            }
        }
    }
}

