/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.cluster;

import java.util.Map;
import org.apache.catalina.ha.ClusterListener;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.tomcat.BaseGBean;
import org.apache.geronimo.tomcat.ObjectRetriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterListenerGBean
extends BaseGBean
implements GBeanLifecycle,
ObjectRetriever {
    private static final Logger log = LoggerFactory.getLogger(ClusterListenerGBean.class);
    public static final String J2EE_TYPE = "ClusterListener";
    private final ClusterListener listener;
    private final ClusterListenerGBean nextListener;
    private final String className;
    public static final GBeanInfo GBEAN_INFO;

    public ClusterListenerGBean() {
        this.listener = null;
        this.nextListener = null;
        this.className = null;
    }

    public ClusterListenerGBean(String className, Map initParams, ClusterListenerGBean nextListener) throws Exception {
        if (className == null) {
            throw new IllegalArgumentException("className cannot be null.");
        }
        if (nextListener != null) {
            if (!(nextListener.getInternalObject() instanceof ClusterListener)) {
                throw new IllegalArgumentException("nextListener is not of type ClusterListener.");
            }
            this.nextListener = nextListener;
        } else {
            this.nextListener = null;
        }
        this.className = className;
        this.listener = (ClusterListener)Class.forName(className).newInstance();
        this.setParameters(this.listener, initParams);
    }

    public void doStart() throws Exception {
        log.debug(this.className + " started.");
    }

    public void doStop() throws Exception {
        log.debug(this.className + " stopped.");
    }

    public void doFail() {
        log.warn(this.className + " failed.");
    }

    public Object getInternalObject() {
        return this.listener;
    }

    public ClusterListenerGBean getNextValve() {
        return this.nextListener;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)J2EE_TYPE, ClusterListenerGBean.class, (String)J2EE_TYPE);
        infoFactory.addAttribute("className", String.class, true);
        infoFactory.addAttribute("initParams", Map.class, true);
        infoFactory.addReference("NextListener", ClusterListenerGBean.class, J2EE_TYPE);
        infoFactory.addOperation("getInternalObject", "Object");
        infoFactory.addOperation("getNextValve", "ClusterListenerGBean");
        infoFactory.setConstructor(new String[]{"className", "initParams", "NextListener"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

