/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.cluster;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.geronimo.clustering.ClusteredInvocation;
import org.apache.geronimo.clustering.ClusteredInvocationException;
import org.apache.geronimo.tomcat.cluster.JkRouter;
import org.apache.geronimo.tomcat.cluster.Router;

public abstract class AbstractClusteredValve
extends ValveBase {
    private final Router router;

    public AbstractClusteredValve(String nodeName) {
        if (null == nodeName) {
            throw new IllegalArgumentException("nodeName is required");
        }
        this.router = this.newRouter(nodeName);
    }

    protected Router newRouter(String nodeName) {
        return new JkRouter(nodeName);
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (null == request) {
            this.next.invoke(request, response);
            return;
        }
        ClusteredInvocation invocation = this.newClusteredInvocation(request, response);
        try {
            invocation.invoke();
        }
        catch (ClusteredInvocationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ServletException) {
                throw (ServletException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw (IOException)new IOException().initCause(e);
        }
    }

    protected abstract ClusteredInvocation newClusteredInvocation(Request var1, Response var2);

    protected abstract class WebClusteredInvocation
    implements ClusteredInvocation {
        protected final Request request;
        protected final Response response;

        protected WebClusteredInvocation(Request request, Response response) {
            this.request = request;
            this.response = response;
        }

        protected void invokeLocally() throws ClusteredInvocationException {
            String oldRequestedSessionId = AbstractClusteredValve.this.router.replaceRoutingInfoInRequestedSessionId(this.request);
            try {
                AbstractClusteredValve.this.next.invoke(this.request, this.response);
            }
            catch (IOException e) {
                throw new ClusteredInvocationException((Throwable)e);
            }
            catch (ServletException e) {
                throw new ClusteredInvocationException((Throwable)e);
            }
            finally {
                this.request.setRequestedSessionId(oldRequestedSessionId);
            }
            AbstractClusteredValve.this.router.writeSessionIdWithRoutingInfo(this.request, this.response);
        }

        public String getRequestedSessionId() {
            if (null == this.request) {
                return null;
            }
            return this.request.getRequestedSessionId();
        }
    }
}

