/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.cluster.wadi.builder;

import javax.xml.namespace.QName;
import org.apache.geronimo.schema.ElementConverter;
import org.apache.geronimo.xbeans.geronimo.naming.GerPatternType;
import org.apache.geronimo.xbeans.tomcat.cluster.wadi.GerTomcatClusteringWadiDocument;
import org.apache.xmlbeans.XmlCursor;

public class TomcatClusteringWADIConverter
implements ElementConverter {
    private static final String TOMCAT_CLUSTERING_WADI_NS = GerTomcatClusteringWadiDocument.type.getDocumentElementName().getNamespaceURI();
    private static final String NAMING_NS = GerPatternType.type.getName().getNamespaceURI();
    private static final String CLUSTER_ELEMENT_NAME = "cluster";
    private static final String BACKING_STRATEGY_FACTORY_ELEMENT_NAME = "backing-strategy-factory";

    public void convertElement(XmlCursor cursor, XmlCursor end) {
        end.toCursor(cursor);
        end.toEndToken();
        while (cursor.hasNextToken() && cursor.isLeftOf(end)) {
            if (cursor.isStart()) {
                String localPart = cursor.getName().getLocalPart();
                cursor.setName(new QName(TOMCAT_CLUSTERING_WADI_NS, localPart));
                if (localPart.equals(CLUSTER_ELEMENT_NAME) || localPart.equals(BACKING_STRATEGY_FACTORY_ELEMENT_NAME)) {
                    this.convertChildrenToNamingNS(cursor);
                    cursor.toEndToken();
                }
            }
            cursor.toNextToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertChildrenToNamingNS(XmlCursor cursor) {
        block6: {
            XmlCursor namingCursor = cursor.newCursor();
            try {
                if (!namingCursor.toFirstChild()) break block6;
                XmlCursor endNamingCursor = namingCursor.newCursor();
                try {
                    this.convertToNamingNS(namingCursor, endNamingCursor);
                }
                finally {
                    endNamingCursor.dispose();
                }
            }
            finally {
                namingCursor.dispose();
            }
        }
    }

    protected void convertToNamingNS(XmlCursor cursor, XmlCursor end) {
        end.toCursor(cursor);
        end.toEndToken();
        while (cursor.hasNextToken() && cursor.isLeftOf(end)) {
            if (cursor.isStart()) {
                String localPart = cursor.getName().getLocalPart();
                cursor.setName(new QName(NAMING_NS, localPart));
            }
            cursor.toNextToken();
        }
    }
}

