/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import javax.servlet.Servlet;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.Deployable;
import org.apache.geronimo.deployment.DeployableBundle;
import org.apache.geronimo.deployment.DeployableJarFile;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilderCollection;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.xbeans.EnvironmentType;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.ModuleBuilderExtension;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.j2ee.deployment.WebServiceBuilder;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedWebApp;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.kernel.util.JarUtils;
import org.apache.geronimo.naming.deployment.ENCConfigBuilder;
import org.apache.geronimo.naming.deployment.GBeanResourceEnvironmentBuilder;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentBuilder;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentSetter;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.security.deployment.GeronimoSecurityBuilderImpl;
import org.apache.geronimo.security.jaas.ConfigurationFactory;
import org.apache.geronimo.tomcat.RealmGBean;
import org.apache.geronimo.tomcat.TomcatWebAppContext;
import org.apache.geronimo.tomcat.util.SecurityHolder;
import org.apache.geronimo.web.WebAttributeName;
import org.apache.geronimo.web.deployment.GenericToSpecificPlanConverter;
import org.apache.geronimo.web25.deployment.AbstractWebModuleBuilder;
import org.apache.geronimo.web25.deployment.security.AuthenticationWrapper;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentValidationUtils;
import org.apache.geronimo.xbeans.geronimo.jaspi.JaspiAuthModuleType;
import org.apache.geronimo.xbeans.geronimo.jaspi.JaspiConfigProviderType;
import org.apache.geronimo.xbeans.geronimo.jaspi.JaspiServerAuthConfigType;
import org.apache.geronimo.xbeans.geronimo.jaspi.JaspiServerAuthContextType;
import org.apache.geronimo.xbeans.geronimo.naming.GerGbeanLocatorType;
import org.apache.geronimo.xbeans.geronimo.web.tomcat.TomcatAuthenticationType;
import org.apache.geronimo.xbeans.geronimo.web.tomcat.TomcatWebAppDocument;
import org.apache.geronimo.xbeans.geronimo.web.tomcat.TomcatWebAppType;
import org.apache.geronimo.xbeans.geronimo.web.tomcat.config.GerTomcatDocument;
import org.apache.geronimo.xbeans.javaee6.ServletType;
import org.apache.geronimo.xbeans.javaee6.WebAppDocument;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatModuleBuilder
extends AbstractWebModuleBuilder
implements GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(TomcatModuleBuilder.class);
    private static final String TOMCAT_NAMESPACE = TomcatWebAppDocument.type.getDocumentElementName().getNamespaceURI();
    private static final Map<String, String> NAMESPACE_UPDATES = new HashMap<String, String>();
    private final Environment defaultEnvironment;
    private final AbstractNameQuery tomcatContainerName;
    protected final NamespaceDrivenBuilderCollection clusteringBuilders;
    public static final GBeanInfo GBEAN_INFO;
    public static final String GBEAN_REF_CLUSTERING_BUILDERS = "ClusteringBuilders";

    public TomcatModuleBuilder(Environment defaultEnvironment, AbstractNameQuery tomcatContainerName, Collection<WebServiceBuilder> webServiceBuilder, Collection<NamespaceDrivenBuilder> serviceBuilders, NamingBuilder namingBuilders, Collection<NamespaceDrivenBuilder> clusteringBuilders, Collection<ModuleBuilderExtension> moduleBuilderExtensions, ResourceEnvironmentSetter resourceEnvironmentSetter, Kernel kernel) {
        super(kernel, serviceBuilders, namingBuilders, resourceEnvironmentSetter, webServiceBuilder, moduleBuilderExtensions);
        this.defaultEnvironment = defaultEnvironment;
        this.clusteringBuilders = new NamespaceDrivenBuilderCollection(clusteringBuilders);
        this.tomcatContainerName = tomcatContainerName;
    }

    public void doStart() throws Exception {
        XmlBeansUtil.registerNamespaceUpdates(NAMESPACE_UPDATES);
    }

    public void doStop() {
        XmlBeansUtil.unregisterNamespaceUpdates(NAMESPACE_UPDATES);
    }

    public void doFail() {
        this.doStop();
    }

    public Module createModule(Bundle bundle, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        AbstractName moduleName;
        if (bundle == null) {
            throw new NullPointerException("bundle is null");
        }
        String contextPath = (String)bundle.getHeaders().get("Web-ContextPath");
        if (contextPath == null) {
            return null;
        }
        String specDD = null;
        WebAppType webApp = null;
        URL specDDUrl = BundleUtils.getEntry((Bundle)bundle, (String)"WEB-INF/web.xml");
        if (specDDUrl == null) {
            webApp = WebAppType.Factory.newInstance();
        } else {
            try {
                specDD = JarUtils.readAll((URL)specDDUrl);
                XmlObject parsed = XmlBeansUtil.parse((String)specDD);
                WebAppDocument webAppDoc = SchemaConversionUtils.convertToServletSchema((XmlObject)parsed);
                webApp = webAppDoc.getWebApp();
                WebDeploymentValidationUtils.validateWebApp((WebAppType)webApp);
            }
            catch (XmlException e) {
                throw new DeploymentException("Error parsing web.xml for " + bundle.getSymbolicName(), (Throwable)e);
            }
            catch (Exception e) {
                throw new DeploymentException("Error reading web.xml for " + bundle.getSymbolicName(), (Throwable)e);
            }
        }
        AbstractName earName = null;
        String targetPath = ".";
        boolean standAlone = true;
        DeployableBundle deployable = new DeployableBundle(bundle);
        TomcatWebAppType tomcatWebApp = this.getTomcatWebApp(null, (Deployable)deployable, standAlone, targetPath, webApp);
        EnvironmentType environmentType = tomcatWebApp.getEnvironment();
        Environment environment = EnvironmentBuilder.buildEnvironment((EnvironmentType)environmentType, (Environment)this.defaultEnvironment);
        if (webApp.getDistributableArray().length == 1) {
            this.clusteringBuilders.buildEnvironment((XmlObject)tomcatWebApp, environment);
        }
        idBuilder.resolve(environment, bundle.getSymbolicName(), "wab");
        if (earName == null) {
            earName = naming.createRootName(environment.getConfigId(), "null", "J2EEApplication");
            moduleName = naming.createChildName(earName, environment.getConfigId().toString(), "WebModule");
        } else {
            moduleName = naming.createChildName(earName, targetPath, "WebModule");
        }
        AnnotatedWebApp annotatedWebApp = new AnnotatedWebApp(webApp);
        String name = this.getModuleName(webApp);
        if (name == null) {
            name = bundle.getSymbolicName();
        }
        WebModule module = new WebModule(standAlone, moduleName, name, environment, (Deployable)deployable, targetPath, (XmlObject)webApp, (XmlObject)tomcatWebApp, specDD, contextPath, TOMCAT_NAMESPACE, annotatedWebApp);
        for (ModuleBuilderExtension mbe : this.moduleBuilderExtensions) {
            mbe.createModule((Module)module, bundle, naming, idBuilder);
        }
        return module;
    }

    protected Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment earEnvironment, String contextRoot, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        AbstractName moduleName;
        String warName;
        WebAppType webApp;
        String specDD;
        block15: {
            assert (moduleFile != null) : "moduleFile is null";
            assert (targetPath != null) : "targetPath is null";
            assert (!targetPath.endsWith("/")) : "targetPath must not end with a '/'";
            specDD = null;
            webApp = null;
            try {
                if (specDDUrl == null) {
                    specDDUrl = JarUtils.createJarURL((JarFile)moduleFile, (String)"WEB-INF/web.xml");
                }
                specDD = JarUtils.readAll((URL)specDDUrl);
                XmlObject parsed = XmlBeansUtil.parse((String)specDD);
                WebAppDocument webAppDoc = SchemaConversionUtils.convertToServletSchema((XmlObject)parsed);
                webApp = webAppDoc.getWebApp();
                WebDeploymentValidationUtils.validateWebApp((WebAppType)webApp);
            }
            catch (XmlException e) {
                throw new DeploymentException("Error parsing web.xml for " + targetPath, (Throwable)e);
            }
            catch (Exception e) {
                if (moduleFile.getName().endsWith(".war")) break block15;
                return null;
            }
        }
        if (webApp == null) {
            webApp = WebAppType.Factory.newInstance();
        }
        DeployableJarFile deployable = new DeployableJarFile(moduleFile);
        boolean standAlone = earEnvironment == null;
        TomcatWebAppType tomcatWebApp = this.getTomcatWebApp(plan, (Deployable)deployable, standAlone, targetPath, webApp);
        contextRoot = this.getContextRoot(tomcatWebApp, contextRoot, webApp, standAlone, moduleFile, targetPath);
        EnvironmentType environmentType = tomcatWebApp.getEnvironment();
        Environment environment = EnvironmentBuilder.buildEnvironment((EnvironmentType)environmentType, (Environment)this.defaultEnvironment);
        if (webApp.getDistributableArray().length == 1) {
            this.clusteringBuilders.buildEnvironment((XmlObject)tomcatWebApp, environment);
        }
        if (!standAlone) {
            EnvironmentBuilder.mergeEnvironments((Environment)earEnvironment, (Environment)environment);
            environment = earEnvironment;
        }
        if ((warName = new File(moduleFile.getName()).getName()).lastIndexOf(46) > -1) {
            warName = warName.substring(0, warName.lastIndexOf(46));
        }
        idBuilder.resolve(environment, warName, "war");
        if (earName == null) {
            earName = naming.createRootName(environment.getConfigId(), "null", "J2EEApplication");
            moduleName = naming.createChildName(earName, environment.getConfigId().toString(), "WebModule");
        } else {
            moduleName = naming.createChildName(earName, targetPath, "WebModule");
        }
        AnnotatedWebApp annotatedWebApp = new AnnotatedWebApp(webApp);
        String name = this.getModuleName(webApp);
        if (name == null) {
            name = standAlone ? FileUtils.removeExtension((String)new File(moduleFile.getName()).getName(), (String)".war") : FileUtils.removeExtension((String)targetPath, (String)".war");
        }
        WebModule module = new WebModule(standAlone, moduleName, name, environment, (Deployable)deployable, targetPath, (XmlObject)webApp, (XmlObject)tomcatWebApp, specDD, contextRoot, TOMCAT_NAMESPACE, annotatedWebApp);
        for (ModuleBuilderExtension mbe : this.moduleBuilderExtensions) {
            mbe.createModule((Module)module, plan, moduleFile, targetPath, specDDUrl, environment, (Object)contextRoot, earName, naming, idBuilder);
        }
        return module;
    }

    private String getContextRoot(TomcatWebAppType tomcatWebApp, String contextRoot, WebAppType webApp, boolean standAlone, JarFile moduleFile, String targetPath) {
        if (tomcatWebApp.isSetContextRoot()) {
            contextRoot = tomcatWebApp.getContextRoot();
        } else if (contextRoot == null || contextRoot.trim().equals("")) {
            contextRoot = this.determineDefaultContextRoot(webApp, standAlone, moduleFile, targetPath);
        }
        contextRoot = contextRoot.trim();
        if (contextRoot.length() > 0 && !contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        return contextRoot;
    }

    TomcatWebAppType getTomcatWebApp(Object plan, Deployable deployable, boolean standAlone, String targetPath, WebAppType webApp) throws DeploymentException {
        XmlObject rawPlan = null;
        try {
            TomcatWebAppType tomcatWebApp;
            try {
                if (plan instanceof XmlObject) {
                    rawPlan = (XmlObject)plan;
                } else if (plan != null) {
                    rawPlan = XmlBeansUtil.parse((URL)((File)plan).toURI().toURL(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                } else {
                    URL path = deployable.getResource("WEB-INF/geronimo-web.xml");
                    if (path == null) {
                        path = deployable.getResource("WEB-INF/geronimo-tomcat.xml");
                    }
                    if (path == null) {
                        log.warn("Web application " + targetPath + " does not contain a WEB-INF/geronimo-web.xml deployment plan.  This may or may not be a problem, depending on whether you have things like resource references that need to be resolved.  You can also give the deployer a separate deployment plan file on the command line.");
                    } else {
                        rawPlan = XmlBeansUtil.parse((URL)path, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                    }
                }
            }
            catch (IOException e) {
                log.warn("Failed to load geronimo-web.xml", (Throwable)e);
            }
            if (rawPlan != null) {
                XmlObject webPlan = new GenericToSpecificPlanConverter(GerTomcatDocument.type.getDocumentElementName().getNamespaceURI(), TomcatWebAppDocument.type.getDocumentElementName().getNamespaceURI(), "tomcat").convertToSpecificPlan(rawPlan);
                tomcatWebApp = (TomcatWebAppType)webPlan.changeType(TomcatWebAppType.type);
                XmlBeansUtil.validateDD((XmlObject)tomcatWebApp);
            } else {
                tomcatWebApp = this.createDefaultPlan();
            }
            return tomcatWebApp;
        }
        catch (XmlException e) {
            throw new DeploymentException("xml problem for web app " + targetPath, (Throwable)e);
        }
    }

    private TomcatWebAppType createDefaultPlan() {
        return TomcatWebAppType.Factory.newInstance();
    }

    protected void postInitContext(EARContext earContext, Module module, Bundle bundle) throws DeploymentException {
        for (ModuleBuilderExtension mbe : this.moduleBuilderExtensions) {
            mbe.initContext(earContext, module, bundle);
        }
    }

    protected void preInitContext(EARContext earContext, Module module, Bundle bundle) throws DeploymentException {
        TomcatWebAppType gerWebApp = (TomcatWebAppType)module.getVendorDD();
        boolean hasSecurityRealmName = gerWebApp.isSetSecurityRealmName();
        module.getEarContext().getGeneralData().put(WEB_MODULE_HAS_SECURITY_REALM, hasSecurityRealmName);
    }

    public void addGBeans(EARContext earContext, Module module, Bundle bundle, Collection repository) throws DeploymentException {
        EARContext moduleContext = module.getEarContext();
        Bundle webBundle = moduleContext.getDeploymentBundle();
        AbstractName moduleName = module.getModuleName();
        WebModule webModule = (WebModule)module;
        WebAppType webApp = (WebAppType)webModule.getSpecDD();
        TomcatWebAppType tomcatWebApp = (TomcatWebAppType)webModule.getVendorDD();
        GBeanData webModuleData = new GBeanData(moduleName, TomcatWebAppContext.class);
        this.configureBasicWebModuleAttributes(webApp, tomcatWebApp, moduleContext, earContext, webModule, webModuleData);
        String contextPath = webModule.getContextRoot();
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        try {
            Class baseServletClass;
            Boolean distributable;
            moduleContext.addGBean(webModuleData);
            webModuleData.setAttribute("contextPath", (Object)contextPath);
            GBeanResourceEnvironmentBuilder rebuilder = new GBeanResourceEnvironmentBuilder(webModuleData);
            this.resourceEnvironmentSetter.setResourceEnvironment((ResourceEnvironmentBuilder)rebuilder, (XmlObject[])webApp.getResourceRefArray(), tomcatWebApp.getResourceRefArray());
            if (tomcatWebApp.isSetWebContainer()) {
                AbstractNameQuery webContainerName = ENCConfigBuilder.getGBeanQuery((String)"GBean", (GerGbeanLocatorType)tomcatWebApp.getWebContainer());
                webModuleData.setReferencePattern("Container", webContainerName);
            } else {
                webModuleData.setReferencePattern("Container", this.tomcatContainerName);
            }
            if (webApp.getDisplayNameArray().length > 0) {
                webModuleData.setAttribute("displayName", (Object)webApp.getDisplayNameArray()[0].getStringValue());
            }
            if (tomcatWebApp.isSetHost()) {
                String virtualServer = tomcatWebApp.getHost().trim();
                webModuleData.setAttribute("virtualServer", (Object)virtualServer);
            }
            if (tomcatWebApp.isSetCrossContext()) {
                webModuleData.setAttribute("crossContext", (Object)Boolean.TRUE);
            }
            if (tomcatWebApp.isSetWorkDir()) {
                String workDir = tomcatWebApp.getWorkDir();
                webModuleData.setAttribute("workDir", (Object)workDir);
            }
            if (tomcatWebApp.isSetDisableCookies()) {
                webModuleData.setAttribute("disableCookies", (Object)Boolean.TRUE);
            }
            if (tomcatWebApp.isSetTomcatRealm()) {
                String tomcatRealm = tomcatWebApp.getTomcatRealm().trim();
                AbstractName realmName = earContext.getNaming().createChildName(moduleName, tomcatRealm, RealmGBean.GBEAN_INFO.getJ2eeType());
                webModuleData.setReferencePattern("TomcatRealm", realmName);
            }
            if (tomcatWebApp.isSetValveChain()) {
                String valveChain = tomcatWebApp.getValveChain().trim();
                AbstractName valveName = earContext.getNaming().createChildName(moduleName, valveChain, "TomcatValve");
                webModuleData.setReferencePattern("TomcatValveChain", valveName);
            }
            if (tomcatWebApp.isSetListenerChain()) {
                String listenerChain = tomcatWebApp.getListenerChain().trim();
                AbstractName listenerName = earContext.getNaming().createChildName(moduleName, listenerChain, "TomcatLifecycleListener");
                webModuleData.setReferencePattern("LifecycleListenerChain", listenerName);
            }
            if (tomcatWebApp.isSetCluster()) {
                String cluster = tomcatWebApp.getCluster().trim();
                AbstractName clusterName = earContext.getNaming().createChildName(moduleName, cluster, "Cluster");
                webModuleData.setReferencePattern("Cluster", clusterName);
            }
            if (tomcatWebApp.isSetManager()) {
                String manager = tomcatWebApp.getManager().trim();
                AbstractName managerName = earContext.getNaming().createChildName(moduleName, manager, "Manager");
                webModuleData.setReferencePattern("ManagerRetriever", managerName);
            }
            Boolean bl = distributable = webApp.getDistributableArray().length == 1 ? Boolean.TRUE : Boolean.FALSE;
            if (Boolean.TRUE == distributable) {
                this.clusteringBuilders.build((XmlObject)tomcatWebApp, (DeploymentContext)earContext, (DeploymentContext)moduleContext);
                if (null == webModuleData.getReferencePatterns("ClusteredValveRetriever")) {
                    log.warn("No clustering builders configured: app will not be clustered");
                }
            }
            ArrayList listeners = new ArrayList();
            webModuleData.setAttribute("listenerClassNames", listeners);
            ServletType[] servletTypes = webApp.getServletArray();
            HashMap<String, AbstractName> webServices = new HashMap<String, AbstractName>();
            try {
                baseServletClass = webBundle.loadClass(Servlet.class.getName());
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not load javax.servlet.Servlet in bundle " + bundle, (Throwable)e);
            }
            for (ServletType servletType : servletTypes) {
                Class servletClass;
                if (!servletType.isSetServletClass()) continue;
                String servletName = servletType.getServletName().getStringValue().trim();
                String servletClassName = servletType.getServletClass().getStringValue().trim();
                try {
                    servletClass = webBundle.loadClass(servletClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentException("Could not load servlet class " + servletClassName + " from bundle " + bundle, (Throwable)e);
                }
                if (baseServletClass.isAssignableFrom(servletClass)) continue;
                AbstractName servletAbstractName = moduleContext.getNaming().createChildName(moduleName, servletName, "Servlet");
                GBeanData servletData = new GBeanData();
                servletData.setAbstractName(servletAbstractName);
                boolean configured = false;
                for (WebServiceBuilder serviceBuilder : this.webServiceBuilder) {
                    if (!serviceBuilder.configurePOJO(servletData, servletName, module, servletClassName, (DeploymentContext)moduleContext)) continue;
                    configured = true;
                    break;
                }
                if (!configured) {
                    throw new DeploymentException("POJO web service: " + servletName + " not configured by any web service builder");
                }
                ReferencePatterns patterns = servletData.getReferencePatterns("WebServiceContainerFactory");
                AbstractName wsContainerFactoryName = patterns.getAbstractName();
                webServices.put(servletName, wsContainerFactoryName);
                webModuleData.addDependency(wsContainerFactoryName);
            }
            webModuleData.setAttribute("webServices", webServices);
            if (tomcatWebApp.isSetSecurityRealmName()) {
                if (earContext.getSecurityConfiguration() == null) {
                    throw new DeploymentException("You have specified a <security-realm-name> for the webapp " + moduleName + " but no <security> configuration (role mapping) is supplied in the Geronimo plan for the web application (or the Geronimo plan for the EAR if the web app is in an EAR)");
                }
                SecurityHolder securityHolder = new SecurityHolder();
                String securityRealmName = tomcatWebApp.getSecurityRealmName().trim();
                webModuleData.setReferencePattern("RunAsSource", (AbstractNameQuery)GeronimoSecurityBuilderImpl.ROLE_MAPPER_DATA_NAME.get(earContext.getGeneralData()));
                webModuleData.setReferencePattern("ConfigurationFactory", new AbstractNameQuery(null, Collections.singletonMap("name", securityRealmName), ConfigurationFactory.class.getName()));
                String policyContextID = moduleName.toString().replaceAll("[, :]", "_");
                securityHolder.setPolicyContextID(policyContextID);
                securityHolder.setSecurity(true);
                webModuleData.setAttribute("securityHolder", (Object)securityHolder);
                if (tomcatWebApp.isSetAuthentication()) {
                    TomcatAuthenticationWrapper authType = new TomcatAuthenticationWrapper(tomcatWebApp.getAuthentication());
                    this.configureLocalJaspicProvider(authType, contextPath, module, webModuleData);
                }
            }
            HashMap<String, Object> deploymentAttributes = new HashMap<String, Object>();
            deploymentAttributes.put(WebAttributeName.META_COMPLETE.name(), webApp.getMetadataComplete());
            deploymentAttributes.put(WebAttributeName.SCHEMA_VERSION.name(), INITIAL_WEB_XML_SCHEMA_VERSION.get(earContext.getGeneralData()));
            deploymentAttributes.put(WebAttributeName.ORDERED_LIBS.name(), AbstractWebModuleBuilder.ORDERED_LIBS.get(earContext.getGeneralData()));
            deploymentAttributes.put(WebAttributeName.SERVLET_CONTAINER_INITIALIZERS.name(), AbstractWebModuleBuilder.SERVLET_CONTAINER_INITIALIZERS.get(earContext.getGeneralData()));
            webModuleData.setAttribute("deploymentAttributes", deploymentAttributes);
            for (ModuleBuilderExtension mbe : this.moduleBuilderExtensions) {
                mbe.addGBeans(earContext, module, bundle, repository);
            }
            if (tomcatWebApp.isSetSecurityRealmName()) {
                webModuleData.setReferencePattern("applicationPolicyConfigurationManager", (AbstractName)EARContext.JACC_MANAGER_NAME_KEY.get(earContext.getGeneralData()));
            }
            if (!webApp.getMetadataComplete()) {
                webApp.setMetadataComplete(true);
                if (((Float)INITIAL_WEB_XML_SCHEMA_VERSION.get(earContext.getGeneralData())).floatValue() >= 2.5f) {
                    String specDeploymentPlan = this.getSpecDDAsString(webModule);
                    module.setOriginalSpecDD(specDeploymentPlan);
                    earContext.addFile(new URI("./WEB-INF/web.xml"), specDeploymentPlan);
                }
            }
            webModuleData.setAttribute("deploymentDescriptor", (Object)module.getOriginalSpecDD());
            module.addAsChildConfiguration();
        }
        catch (DeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to initialize GBean for web app " + module.getName(), (Throwable)e);
        }
    }

    public String getSchemaNamespace() {
        return TOMCAT_NAMESPACE;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/web", "http://geronimo.apache.org/xml/ns/j2ee/web-2.0.1");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web-1.1", "http://geronimo.apache.org/xml/ns/j2ee/web-2.0.1");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web-1.2", "http://geronimo.apache.org/xml/ns/j2ee/web-2.0.1");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web-2.0", "http://geronimo.apache.org/xml/ns/j2ee/web-2.0.1");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/web/tomcat", "http://geronimo.apache.org/xml/ns/j2ee/web/tomcat-2.0.1");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web/tomcat-1.1", "http://geronimo.apache.org/xml/ns/j2ee/web/tomcat-2.0.1");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web/tomcat-1.2", "http://geronimo.apache.org/xml/ns/j2ee/web/tomcat-2.0.1");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web/tomcat-2.0", "http://geronimo.apache.org/xml/ns/j2ee/web/tomcat-2.0.1");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/web/tomcat/config", "http://geronimo.apache.org/xml/ns/j2ee/web/tomcat/config-1.0");
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(TomcatModuleBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("tomcatContainerName", AbstractNameQuery.class, true, true);
        infoBuilder.addReference("WebServiceBuilder", WebServiceBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("ServiceBuilders", NamespaceDrivenBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("NamingBuilders", NamingBuilder.class, "ModuleBuilder");
        infoBuilder.addReference(GBEAN_REF_CLUSTERING_BUILDERS, NamespaceDrivenBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("ModuleBuilderExtensions", ModuleBuilderExtension.class, "ModuleBuilder");
        infoBuilder.addReference("ResourceEnvironmentSetter", ResourceEnvironmentSetter.class, "ModuleBuilder");
        infoBuilder.addAttribute("kernel", Kernel.class, false);
        infoBuilder.addInterface(ModuleBuilder.class);
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "tomcatContainerName", "WebServiceBuilder", "ServiceBuilders", "NamingBuilders", GBEAN_REF_CLUSTERING_BUILDERS, "ModuleBuilderExtensions", "ResourceEnvironmentSetter", "kernel"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    private static class TomcatAuthenticationWrapper
    implements AuthenticationWrapper {
        private final TomcatAuthenticationType authType;

        private TomcatAuthenticationWrapper(TomcatAuthenticationType authType) {
            this.authType = authType;
        }

        public JaspiConfigProviderType getConfigProvider() {
            return this.authType.getConfigProvider();
        }

        public boolean isSetConfigProvider() {
            return this.authType.isSetConfigProvider();
        }

        public JaspiServerAuthConfigType getServerAuthConfig() {
            return this.authType.getServerAuthConfig();
        }

        public boolean isSetServerAuthConfig() {
            return this.authType.isSetServerAuthConfig();
        }

        public JaspiServerAuthContextType getServerAuthContext() {
            return this.authType.getServerAuthContext();
        }

        public boolean isSetServerAuthContext() {
            return this.authType.isSetServerAuthContext();
        }

        public JaspiAuthModuleType getServerAuthModule() {
            return this.authType.getServerAuthModule();
        }

        public boolean isSetServerAuthModule() {
            return this.authType.isSetServerAuthModule();
        }
    }
}

