/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.model;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.catalina.tribes.ChannelSender;
import org.apache.catalina.tribes.transport.ReplicationTransmitter;
import org.apache.geronimo.tomcat.model.TransportType;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SenderType")
public class SenderType {
    @XmlAttribute
    protected String className = ReplicationTransmitter.class.getName();
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();
    @XmlElement(name="Transport")
    private TransportType transport;

    public String getClassName() {
        return this.className;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public ChannelSender getSender(ClassLoader cl) throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<QName, String> entry : this.otherAttributes.entrySet()) {
            String name = entry.getKey().getLocalPart();
            properties.put(name, entry.getValue());
        }
        ObjectRecipe recipe = new ObjectRecipe(this.className, properties);
        recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
        ChannelSender channelSender = (ChannelSender)recipe.create(cl);
        if (channelSender instanceof ReplicationTransmitter && this.transport != null) {
            ReplicationTransmitter replicationTransmitter = (ReplicationTransmitter)channelSender;
            replicationTransmitter.setTransport(this.transport.getTransport(cl));
        }
        return channelSender;
    }

    public TransportType getTransport() {
        return this.transport;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setTransport(TransportType transport) {
        this.transport = transport;
    }
}

