/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.connector;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.management.j2ee.statistics.Stats;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Connector;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.Persistent;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.tomcat.BaseGBean;
import org.apache.geronimo.tomcat.ObjectRetriever;
import org.apache.geronimo.tomcat.TomcatContainer;
import org.apache.geronimo.tomcat.TomcatServerGBean;
import org.apache.geronimo.tomcat.connector.CommonProtocol;
import org.apache.geronimo.tomcat.connector.TomcatWebConnector;
import org.apache.tomcat.util.IntrospectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GBean(name="Tomcat Connector")
public abstract class ConnectorGBean
extends BaseGBean
implements CommonProtocol,
GBeanLifecycle,
ObjectRetriever,
TomcatWebConnector {
    private static final Logger log = LoggerFactory.getLogger(ConnectorGBean.class);
    public static final String CONNECTOR_CONTAINER_REFERENCE = "TomcatContainer";
    protected final ServerInfo serverInfo;
    protected final Connector connector;
    protected final TomcatContainer container;
    private String name;
    private boolean wrappedConnector;

    public ConnectorGBean(@ParamAttribute(manageable=false, name="name") String name, @ParamAttribute(manageable=false, name="initParams") Map<String, String> initParams, @ParamAttribute(manageable=false, name="protocol") String tomcatProtocol, @ParamReference(name="TomcatContainer") TomcatContainer container, @ParamReference(name="ServerInfo") ServerInfo serverInfo, @ParamAttribute(manageable=false, name="connector") Connector conn) throws Exception {
        if (initParams == null) {
            initParams = new HashMap<String, String>();
        }
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        if (container == null) {
            throw new IllegalArgumentException("container cannot be null.");
        }
        if (serverInfo == null) {
            throw new IllegalArgumentException("serverInfo cannot be null.");
        }
        tomcatProtocol = this.validateProtocol(tomcatProtocol);
        this.name = name;
        this.container = container;
        this.serverInfo = serverInfo;
        if (conn == null) {
            this.connector = new Connector(tomcatProtocol);
            for (LifecycleListener listener : TomcatServerGBean.LifecycleListeners) {
                this.connector.addLifecycleListener(listener);
            }
            this.wrappedConnector = false;
        } else {
            this.connector = conn;
            this.wrappedConnector = true;
        }
        this.setParameters(this.connector, initParams);
    }

    public void doFail() {
        log.warn(this.name + " connector failed");
        this.doStop();
    }

    public void doStart() throws LifecycleException {
        if (this.wrappedConnector) {
            return;
        }
        String executorName = null;
        org.apache.catalina.Executor executor = null;
        if (this.connector.getAttribute("executor") != null) {
            Object value = this.connector.getAttribute("executor");
            if (value == null) {
                executorName = null;
            }
            if (value instanceof String) {
                executorName = (String)value;
            }
            if (value instanceof org.apache.catalina.Executor) {
                executorName = ((org.apache.catalina.Executor)value).getName();
            }
            if ((executor = TomcatServerGBean.executors.get(executorName)) == null) {
                log.warn("No executor found with name:" + executorName + ", trying to get default executor with name 'DefaultThreadPool'");
                executor = TomcatServerGBean.executors.get("DefaultThreadPool");
            }
        } else {
            executor = TomcatServerGBean.executors.get("DefaultThreadPool");
            if (executor == null) {
                log.warn("No executor found in service with name: DefaultThreadPool");
            }
        }
        if (executor != null) {
            log.info("executor:" + executor.getName() + " found, set it to connector:" + this.getName());
            try {
                IntrospectionUtils.callMethod1((Object)this.connector.getProtocolHandler(), (String)"setExecutor", (Object)executor, (String)Executor.class.getName(), (ClassLoader)this.connector.getClass().getClassLoader());
            }
            catch (Exception e) {
                log.info("connector:" + this.getName() + "does not support executor set, do nothing");
            }
        }
        this.container.addConnector(this.connector);
        log.debug("{} connector started", (Object)this.name);
    }

    public void doStop() {
        if (!this.wrappedConnector) {
            this.container.removeConnector(this.connector);
        }
        log.debug("{} connector stopped", (Object)this.name);
    }

    protected String validateProtocol(String tomcatProtocol) {
        return tomcatProtocol;
    }

    public abstract int getDefaultPort();

    public abstract String getGeronimoProtocol();

    public abstract Stats getStats();

    public abstract void resetStats();

    @Override
    public Object getInternalObject() {
        return this.connector;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setAllowTrace(boolean allow) {
        this.connector.setAllowTrace(allow);
    }

    @Override
    public boolean getAllowTrace() {
        return this.connector.getAllowTrace();
    }

    @Override
    public void setEmptySessionPath(boolean emptySessionPath) {
        this.connector.setEmptySessionPath(emptySessionPath);
    }

    @Override
    public void setEnableLookups(boolean enabled) {
        this.connector.setEnableLookups(enabled);
    }

    @Override
    public int getMaxPostSize() {
        int value = this.connector.getMaxPostSize();
        return value == 0 ? 0x200000 : value;
    }

    @Override
    public void setMaxPostSize(int bytes) {
        this.connector.setMaxPostSize(bytes);
    }

    @Override
    public String getProtocol() {
        return this.getGeronimoProtocol();
    }

    @Override
    public String getTomcatProtocol() {
        return this.connector.getProtocol();
    }

    @Override
    public String getProxyName() {
        return this.connector.getProxyName();
    }

    @Override
    public int getProxyPort() {
        return this.connector.getProxyPort();
    }

    @Override
    public int getRedirectPort() {
        return this.connector.getRedirectPort();
    }

    @Override
    public String getScheme() {
        return this.connector.getScheme();
    }

    @Override
    public boolean getSecure() {
        return this.connector.getSecure();
    }

    @Override
    public String getUriEncoding() {
        return this.connector.getURIEncoding();
    }

    @Override
    public boolean getUseBodyEncodingForURI() {
        return this.connector.getUseBodyEncodingForURI();
    }

    @Override
    public boolean getUseIPVHosts() {
        return this.connector.getUseIPVHosts();
    }

    @Override
    @Persistent(manageable=false)
    public void setMaxSavePostSize(int maxSavePostSize) {
        this.connector.setMaxSavePostSize(maxSavePostSize);
    }

    @Override
    @Persistent(manageable=false)
    public void setProxyName(String proxyName) {
        if (proxyName.equals("")) {
            proxyName = null;
        }
        this.connector.setProxyName(proxyName);
    }

    @Override
    @Persistent(manageable=false)
    public void setProxyPort(int port) {
        this.connector.setProxyPort(port);
    }

    @Override
    @Persistent(manageable=false)
    public void setRedirectPort(int port) {
        this.connector.setRedirectPort(port);
    }

    @Override
    @Persistent(manageable=false)
    public void setScheme(String scheme) {
        this.connector.setScheme(scheme);
    }

    @Override
    @Persistent(manageable=false)
    public void setSecure(boolean secure) {
        this.connector.setSecure(secure);
    }

    @Override
    public boolean getSslEnabled() {
        Object value = this.connector.getAttribute("SSLEnabled");
        return value == null ? false : new Boolean(value.toString());
    }

    @Override
    @Persistent(manageable=false)
    public void setSslEnabled(boolean sslEnabled) {
        this.connector.setAttribute("SSLEnabled", (Object)sslEnabled);
    }

    @Override
    @Persistent(manageable=false)
    public void setUriEncoding(String uriEncoding) {
        this.connector.setURIEncoding(uriEncoding);
    }

    @Override
    @Persistent(manageable=false)
    public void setUseBodyEncodingForURI(boolean useBodyEncodingForURI) {
        this.connector.setUseBodyEncodingForURI(useBodyEncodingForURI);
    }

    @Override
    @Persistent(manageable=false)
    public void setUseIPVHosts(boolean useIPVHosts) {
        this.connector.setUseIPVHosts(useIPVHosts);
    }

    @Override
    @Persistent(manageable=false)
    public void setXpoweredBy(boolean xpoweredBy) {
        this.connector.setXpoweredBy(xpoweredBy);
    }

    @Override
    public boolean getEnableLookups() {
        return this.connector.getEnableLookups();
    }

    @Override
    public int getMaxSavePostSize() {
        int value = this.connector.getMaxSavePostSize();
        return value == 0 ? 4096 : value;
    }

    @Override
    public boolean getEmptySessionPath() {
        return this.connector.getEmptySessionPath();
    }

    @Override
    public boolean getXpoweredBy() {
        return this.connector.getXpoweredBy();
    }
}

