/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Valve;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.Embedded;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.tomcat.GeronimoStandardContext;
import org.apache.geronimo.tomcat.TomcatEJBWebServiceContext;
import org.apache.geronimo.webservices.WebServiceContainer;

public class TomcatGeronimoEmbedded
extends Embedded {
    private static final Log log = LogFactory.getLog(TomcatGeronimoEmbedded.class);

    public Context createContext(String path, String docBase, ClassLoader cl) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating context '" + path + "' with docBase '" + docBase + "'"));
        }
        GeronimoStandardContext context = new GeronimoStandardContext();
        context.setDocBase(docBase);
        context.setPath(path);
        if (cl != null) {
            context.setParentClassLoader(cl);
        }
        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/geronimo/tomcat/GeronimoCustomAuthenticator.properties");
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
            log.error((Object)"Unable to access GeronimoCustomAuthenticator.properties", (Throwable)e);
        }
        HashMap<Object, Object> customAuthenticators = new HashMap<Object, Object>(props);
        HashMap<String, Valve> customAuthenticatorValves = new HashMap<String, Valve>();
        for (Object key : customAuthenticators.keySet()) {
            String value = (String)customAuthenticators.get(key);
            Class<?> authenticatorClass = null;
            Valve valve = null;
            try {
                authenticatorClass = Class.forName(value);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)MessageFormat.format("Unable to access class {0}", value), (Throwable)e);
            }
            try {
                valve = (Valve)authenticatorClass.newInstance();
            }
            catch (IllegalAccessException e) {
                log.error((Object)MessageFormat.format("Unable to create an instance of the class {0}", value), (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error((Object)MessageFormat.format("Unable to access the constructor for the class {0}", value), (Throwable)e);
            }
            customAuthenticatorValves.put((String)key, valve);
        }
        ContextConfig config = new ContextConfig();
        config.setCustomAuthenticators(customAuthenticatorValves);
        context.addLifecycleListener((LifecycleListener)config);
        context.setDelegate(true);
        return context;
    }

    public Context createEJBWebServiceContext(String contextPath, WebServiceContainer webServiceContainer, String securityRealmName, String realmName, String transportGuarantee, String authMethod, ClassLoader classLoader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating EJBWebService context '" + contextPath + "'."));
        }
        TomcatEJBWebServiceContext context = new TomcatEJBWebServiceContext(contextPath, webServiceContainer, securityRealmName, realmName, transportGuarantee, authMethod, classLoader);
        ContextConfig config = new ContextConfig();
        config.setCustomAuthenticators((Map)this.authenticators);
        context.addLifecycleListener((LifecycleListener)config);
        return context;
    }
}

