/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.stats;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import org.apache.catalina.core.StandardContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.management.stats.WebModuleStatsImpl;
import org.apache.tomcat.util.modeler.Registry;

public class ModuleStats {
    private static final Log log = LogFactory.getLog(ModuleStats.class);
    private MBeanServer mBeanServer = null;
    private ObjectName mgrName;
    private WebModuleStatsImpl stats = new WebModuleStatsImpl();

    public ModuleStats(StandardContext context) {
        assert (context != null);
        this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
        try {
            this.mgrName = new ObjectName("*:type=Manager,*");
        }
        catch (Exception ex) {
            log.error((Object)("Error - " + ex.toString()));
        }
        Set<ObjectInstance> set = this.mBeanServer.queryMBeans(this.mgrName, null);
        for (ObjectInstance oi : set) {
            ObjectName objectName = oi.getObjectName();
            if (objectName.getKeyProperty("path").indexOf(context.getPath()) <= -1) continue;
            this.mgrName = objectName;
            break;
        }
        this.stats.setProcessingTime(context.getProcessingTime());
        this.stats.setStartupTime(context.getStartupTime());
        this.stats.setTldScanTime(context.getTldScanTime());
    }

    public Stats getStats() {
        this.stats.setStartTime();
        this.updateStats(this.stats);
        return this.stats;
    }

    public Stats updateStats() {
        this.updateStats(this.stats);
        return this.stats;
    }

    private void updateStats(WebModuleStatsImpl stats) {
        stats.setLastSampleTime();
        try {
            int maxActive = (Integer)this.mBeanServer.getAttribute(this.mgrName, "maxActive");
            int sessionMaxAliveTime = (Integer)this.mBeanServer.getAttribute(this.mgrName, "sessionMaxAliveTime");
            int sessionAverageAliveTime = (Integer)this.mBeanServer.getAttribute(this.mgrName, "sessionAverageAliveTime");
            int activeSessions = (Integer)this.mBeanServer.getAttribute(this.mgrName, "activeSessions");
            int rejectedSessions = (Integer)this.mBeanServer.getAttribute(this.mgrName, "rejectedSessions");
            int expiredSessions = (Integer)this.mBeanServer.getAttribute(this.mgrName, "expiredSessions");
            int sessionCounter = (Integer)this.mBeanServer.getAttribute(this.mgrName, "sessionCounter");
            stats.setSessionAliveTime(maxActive, -1L, (long)sessionMaxAliveTime, (long)(sessionAverageAliveTime * maxActive));
            stats.setRejectedSessionCount(rejectedSessions);
            stats.setExpiredSessionCount(expiredSessions);
            stats.setActiveSessionCount(activeSessions);
            stats.setSessionCount(sessionCounter);
        }
        catch (Exception ex) {
            log.error((Object)("Error getting attribute " + this.mgrName + " " + ex.toString()));
        }
    }
}

