/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.connector;

import java.util.Map;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.tomcat.TomcatContainer;
import org.apache.geronimo.tomcat.connector.BaseHttp11ConnectorGBean;
import org.apache.geronimo.tomcat.connector.Http11APRProtocol;

public class Http11APRConnectorGBean
extends BaseHttp11ConnectorGBean
implements Http11APRProtocol {
    private String certificateFile;
    private String certificateKeyFile;
    private String caCertificateFile;
    private String caCertificatePath;
    private String certificateChainFile;
    private String revocationPath;
    private String revocationFile;
    public static final GBeanInfo GBEAN_INFO;

    public Http11APRConnectorGBean(String name, Map initParams, String host, int port, TomcatContainer container, ServerInfo serverInfo) throws Exception {
        super(name, initParams, "org.apache.coyote.http11.Http11AprProtocol", host, port, container, serverInfo);
    }

    public int getDefaultPort() {
        return 80;
    }

    public String getGeronimoProtocol() {
        return "HTTP";
    }

    public int getPollTime() {
        Object value = this.connector.getAttribute("pollTime");
        return value == null ? 2000 : new Integer(value.toString());
    }

    public int getPollerSize() {
        Object value = this.connector.getAttribute("pollerSize");
        return value == null ? 8192 : new Integer(value.toString());
    }

    public int getSendfileSize() {
        Object value = this.connector.getAttribute("sendfileSize");
        return value == null ? 8192 : new Integer(value.toString());
    }

    public String getSslCACertificateFile() {
        return this.caCertificateFile;
    }

    public String getSslCACertificatePath() {
        return this.caCertificatePath;
    }

    public String getSslCertificateChainFile() {
        return this.certificateChainFile;
    }

    public String getSslCertificateFile() {
        return this.certificateFile;
    }

    public String getSslCertificateKeyFile() {
        return this.certificateKeyFile;
    }

    public String getSslCipherSuite() {
        return (String)this.connector.getAttribute("SSLCipherSuite");
    }

    public String getSslProtocol() {
        return (String)this.connector.getAttribute("SSLProtocol");
    }

    public String getSslCARevocationFile() {
        return this.revocationFile;
    }

    public String getSslCARevocationPath() {
        return this.revocationPath;
    }

    public String getSslVerifyClient() {
        return (String)this.connector.getAttribute("SSLVerifyClient");
    }

    public int getSslVerifyDepth() {
        Object value = this.connector.getAttribute("SSLVerifyDepth");
        return value == null ? 10 : new Integer(value.toString());
    }

    public boolean getUseSendfile() {
        Object value = this.connector.getAttribute("useSendfile");
        return value == null ? true : new Boolean(value.toString());
    }

    public void setPollTime(int pollTime) {
        this.connector.setAttribute("pollTime", (Object)pollTime);
    }

    public void setPollerSize(int pollerSize) {
        this.connector.setAttribute("pollerSize", (Object)pollerSize);
    }

    public void setSendfileSize(int sendfileSize) {
        this.connector.setAttribute("sendfileSize", (Object)sendfileSize);
    }

    public void setSslCACertificateFile(String sslCACertificateFile) {
        if (sslCACertificateFile != null && sslCACertificateFile.equals("")) {
            sslCACertificateFile = null;
        }
        this.caCertificateFile = sslCACertificateFile;
        if (this.caCertificateFile == null) {
            this.connector.setAttribute("SSLCACertificateFile", null);
        } else {
            this.connector.setAttribute("SSLCACertificateFile", (Object)this.serverInfo.resolveServerPath(this.caCertificateFile));
        }
    }

    public void setSslCACertificatePath(String sslCACertificatePath) {
        if (sslCACertificatePath != null && sslCACertificatePath.equals("")) {
            sslCACertificatePath = null;
        }
        this.caCertificatePath = sslCACertificatePath;
        if (this.caCertificatePath == null) {
            this.connector.setAttribute("SSLCACertificatePath", null);
        } else {
            this.connector.setAttribute("SSLCACertificatePath", (Object)this.serverInfo.resolveServerPath(this.caCertificatePath));
        }
    }

    public void setSslCertificateChainFile(String sslCertificateChainFile) {
        if (sslCertificateChainFile != null && sslCertificateChainFile.equals("")) {
            sslCertificateChainFile = null;
        }
        this.certificateChainFile = sslCertificateChainFile;
        if (this.certificateChainFile == null) {
            this.connector.setAttribute("SSLCertificateChainFile", null);
        } else {
            this.connector.setAttribute("SSLCertificateChainFile", (Object)this.serverInfo.resolveServerPath(this.certificateChainFile));
        }
    }

    public void setSslCertificateFile(String sslCertificateFile) {
        if (sslCertificateFile != null && sslCertificateFile.equals("")) {
            sslCertificateFile = null;
        }
        this.certificateFile = sslCertificateFile;
        if (this.certificateFile == null) {
            this.connector.setAttribute("SSLCertificateFile", null);
        } else {
            this.connector.setAttribute("SSLCertificateFile", (Object)this.serverInfo.resolveServerPath(this.certificateFile));
        }
    }

    public void setSslCertificateKeyFile(String sslCertificateKeyFile) {
        if (sslCertificateKeyFile != null && sslCertificateKeyFile.equals("")) {
            sslCertificateKeyFile = null;
        }
        this.certificateKeyFile = sslCertificateKeyFile;
        if (this.certificateKeyFile == null) {
            this.connector.setAttribute("SSLCertificateKeyFile", null);
        } else {
            this.connector.setAttribute("SSLCertificateKeyFile", (Object)this.serverInfo.resolveServerPath(this.certificateKeyFile));
        }
    }

    public void setSslCipherSuite(String sslCipherSuite) {
        this.connector.setAttribute("SSLCipherSuite", (Object)sslCipherSuite);
    }

    public void setSslPassword(String sslPassword) {
        if (sslPassword != null && sslPassword.equals("")) {
            sslPassword = null;
        }
        this.connector.setAttribute("SSLPassword", (Object)sslPassword);
    }

    public void setSslProtocol(String sslProtocol) {
        this.connector.setAttribute("SSLProtocol", (Object)sslProtocol);
    }

    public void setSslCARevocationFile(String sslCARevocationFile) {
        if (sslCARevocationFile != null && sslCARevocationFile.equals("")) {
            sslCARevocationFile = null;
        }
        this.revocationFile = sslCARevocationFile;
        if (this.revocationFile == null) {
            this.connector.setAttribute("SSLCARevocationFile", null);
        } else {
            this.connector.setAttribute("SSLCARevocationFile", (Object)this.serverInfo.resolveServerPath(this.revocationFile));
        }
    }

    public void setSslCARevocationPath(String sslCARevocationPath) {
        if (sslCARevocationPath != null && sslCARevocationPath.equals("")) {
            sslCARevocationPath = null;
        }
        this.revocationPath = sslCARevocationPath;
        if (this.revocationPath == null) {
            this.connector.setAttribute("SSLCARevocationPath", null);
        } else {
            this.connector.setAttribute("SSLCARevocationPath", (Object)this.serverInfo.resolveServerPath(this.revocationPath));
        }
    }

    public void setSslVerifyClient(String sslVerifyClient) {
        this.connector.setAttribute("SSLVerifyClient", (Object)sslVerifyClient);
    }

    public void setSslVerifyDepth(int sslVerifyDepth) {
        this.connector.setAttribute("SSLVerifyDepth", (Object)sslVerifyDepth);
    }

    public void setUseSendfile(boolean useSendfile) {
        this.connector.setAttribute("useSendfile", (Object)useSendfile);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"Tomcat Connector HTTP APR", Http11APRConnectorGBean.class, (GBeanInfo)BaseHttp11ConnectorGBean.GBEAN_INFO);
        infoFactory.addInterface(Http11APRProtocol.class, new String[]{"pollTime", "pollerSize", "useSendfile", "sendfileSize", "sslProtocol", "sslCipherSuite", "sslCertificateFile", "sslCertificateKeyFile", "sslPassword", "sslVerifyClient", "sslVerifyDepth", "sslCACertificateFile", "sslCACertificatePath", "sslCertificateChainFile", "sslCARevocationFile", "sslCARevocationPath"}, new String[]{"pollTime", "pollerSize", "useSendfile", "sendfileSize", "sslProtocol", "sslCipherSuite", "sslCertificateFile", "sslCertificateKeyFile", "sslPassword", "sslVerifyClient", "sslVerifyDepth", "sslCACertificateFile", "sslCACertificatePath", "sslCertificateChainFile", "sslCARevocationFile", "sslCARevocationPath"});
        infoFactory.setConstructor(new String[]{"name", "initParams", "host", "port", "TomcatContainer", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

