/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.valves.ValveBase;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.common.GeronimoSecurityException;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.jacc.RunAsSource;
import org.apache.geronimo.tomcat.TomcatContext;
import org.apache.geronimo.tomcat.TomcatWebAppContext;
import org.apache.geronimo.tomcat.interceptor.BeforeAfter;
import org.apache.geronimo.tomcat.interceptor.ComponentContextBeforeAfter;
import org.apache.geronimo.tomcat.interceptor.InstanceContextBeforeAfter;
import org.apache.geronimo.tomcat.interceptor.PolicyContextBeforeAfter;
import org.apache.geronimo.tomcat.interceptor.UserTransactionBeforeAfter;
import org.apache.geronimo.tomcat.listener.RunAsInstanceListener;
import org.apache.geronimo.tomcat.util.SecurityHolder;
import org.apache.geronimo.tomcat.valve.DefaultSubjectValve;
import org.apache.geronimo.tomcat.valve.GeronimoBeforeAfterValve;
import org.apache.geronimo.webservices.POJOWebServiceServlet;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.apache.geronimo.webservices.WebServiceContainerInvoker;

public class GeronimoStandardContext
extends StandardContext {
    private static final long serialVersionUID = 3834587716552831032L;
    private Subject defaultSubject = null;
    private RunAsSource runAsSource = RunAsSource.NULL;
    private Map webServiceMap = null;
    private boolean pipelineInitialized;
    private BeforeAfter beforeAfter = null;
    private int contextCount = 0;
    private static final boolean allowLinking = new Boolean(System.getProperty("org.apache.geronimo.tomcat.GeronimoStandardContext.allowLinking", "false"));

    public void setContextProperties(TomcatContext ctx) throws DeploymentException {
        Manager manager;
        CatalinaCluster cluster;
        List listenerChain;
        SecurityHolder securityHolder;
        Context enc = ctx.getJndiContext();
        this.setInstanceManager(ctx.getInstanceManager());
        if (ctx instanceof TomcatWebAppContext) {
            TomcatWebAppContext tctx = (TomcatWebAppContext)ctx;
            this.setJavaVMs(tctx.getJavaVMs());
            this.setServer(tctx.getServer());
            this.setJ2EEApplication(tctx.getJ2EEApplication());
            this.setJ2EEServer(tctx.getJ2EEServer());
            if (tctx.getRuntimeCustomizer() != null) {
                HashMap servletContext = new HashMap();
                HashMap<Class, Object> customizerContext = new HashMap<Class, Object>();
                customizerContext.put(Map.class, servletContext);
                customizerContext.put(Context.class, enc);
                tctx.getRuntimeCustomizer().customize(customizerContext);
                for (Map.Entry entry : servletContext.entrySet()) {
                    this.getServletContext().setAttribute((String)entry.getKey(), entry.getValue());
                }
            }
        }
        int index = 0;
        BeforeAfter interceptor = new InstanceContextBeforeAfter(null, index++, index++, ctx.getUnshareableResources(), ctx.getApplicationManagedSecurityResources(), ctx.getTrackedConnectionAssociator());
        if (enc != null) {
            interceptor = new ComponentContextBeforeAfter(interceptor, index++, enc);
        }
        if ((securityHolder = ctx.getSecurityHolder()) != null) {
            this.runAsSource = securityHolder.getRunAsSource();
            if (securityHolder.getPolicyContextID() != null) {
                PolicyContext.setContextID((String)securityHolder.getPolicyContextID());
                this.defaultSubject = securityHolder.getDefaultSubject();
                if (this.defaultSubject == null) {
                    this.defaultSubject = ContextManager.EMPTY;
                }
                interceptor = new PolicyContextBeforeAfter(interceptor, index++, index++, index++, securityHolder.getPolicyContextID(), this.defaultSubject);
            }
        }
        interceptor = new UserTransactionBeforeAfter(interceptor, index++, ctx.getUserTransaction());
        Valve clusteredValve = ctx.getClusteredValve();
        if (null != clusteredValve) {
            this.addValve(clusteredValve);
        }
        GeronimoBeforeAfterValve geronimoBAValve = new GeronimoBeforeAfterValve(interceptor, index);
        this.addValve((Valve)geronimoBAValve);
        this.beforeAfter = interceptor;
        this.contextCount = index;
        this.addValve((Valve)new SystemMethodValve());
        List valveChain = ctx.getValveChain();
        if (valveChain != null) {
            for (Object valve : valveChain) {
                this.addValve((Valve)valve);
            }
        }
        if ((listenerChain = ctx.getLifecycleListenerChain()) != null) {
            for (Object listener : listenerChain) {
                this.addLifecycleListener((LifecycleListener)listener);
            }
        }
        if ((cluster = ctx.getCluster()) != null) {
            this.setCluster((Cluster)cluster);
        }
        if ((manager = ctx.getManager()) != null) {
            this.setManager(manager);
        }
        this.pipelineInitialized = true;
        this.webServiceMap = ctx.getWebServices();
        this.setCrossContext(ctx.isCrossContext());
        this.setWorkDir(ctx.getWorkDir());
        super.setAllowLinking(allowLinking);
        this.setCookies(!ctx.isDisableCookies());
        this.addInstanceListener("org.apache.geronimo.tomcat.listener.DispatchListener");
        if (this.runAsSource != null) {
            this.addInstanceListener(RunAsInstanceListener.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backgroundProcess() {
        Object[] context = null;
        if (this.beforeAfter != null) {
            context = new Object[this.contextCount];
            this.beforeAfter.before(context, null, null, 0);
        }
        try {
            super.backgroundProcess();
        }
        finally {
            if (this.beforeAfter != null) {
                this.beforeAfter.after(context, null, null, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws Exception {
        Object[] context = null;
        if (this.beforeAfter != null) {
            context = new Object[this.contextCount];
            this.beforeAfter.before(context, null, null, 0);
        }
        try {
            this.stop();
            this.destroy();
        }
        finally {
            if (this.beforeAfter != null) {
                this.beforeAfter.after(context, null, null, 0);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void start() throws LifecycleException {
        if (this.pipelineInitialized) {
            try {
                Valve valve = this.getFirst();
                valve.invoke(null, null);
                DefaultSubjectValve defaultSubjectValve = new DefaultSubjectValve(this.defaultSubject);
                this.addValve((Valve)defaultSubjectValve);
                if (this.hasRunAsServlet()) {
                    if (this.runAsSource != null) return;
                    throw new GeronimoSecurityException("web.xml or annotation specifies a run-as role but no subject configuration supplied for run-as roles");
                }
                this.removeInstanceListener(RunAsInstanceListener.class.getName());
                return;
            }
            catch (IOException e) {
                if (!(e.getCause() instanceof LifecycleException)) throw new LifecycleException((Throwable)e);
                throw (LifecycleException)e.getCause();
            }
            catch (ServletException e) {
                throw new LifecycleException((Throwable)e);
            }
        } else {
            super.start();
        }
    }

    public void addChild(Container child) {
        Wrapper wrapper = (Wrapper)child;
        String servletClassName = wrapper.getServletClass();
        if (servletClassName == null) {
            super.addChild(child);
            return;
        }
        ClassLoader cl = this.getParentClassLoader();
        try {
            WebServiceContainer webServiceContainer;
            Class<?> baseServletClass = cl.loadClass(Servlet.class.getName());
            Class<?> servletClass = cl.loadClass(servletClassName);
            if (!baseServletClass.isAssignableFrom(servletClass) && this.webServiceMap != null && (webServiceContainer = (WebServiceContainer)this.webServiceMap.get(wrapper.getName())) != null) {
                wrapper.setServletClass("org.apache.geronimo.webservices.POJOWebServiceServlet");
                String webServicecontainerID = wrapper.getName() + WebServiceContainerInvoker.WEBSERVICE_CONTAINER + webServiceContainer.hashCode();
                this.getServletContext().setAttribute(webServicecontainerID, (Object)webServiceContainer);
                wrapper.addInitParameter(WebServiceContainerInvoker.WEBSERVICE_CONTAINER, webServicecontainerID);
                String pojoClassID = wrapper.getName() + POJOWebServiceServlet.POJO_CLASS + servletClass.hashCode();
                this.getServletContext().setAttribute(pojoClassID, servletClass);
                wrapper.addInitParameter(POJOWebServiceServlet.POJO_CLASS, pojoClassID);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        super.addChild(child);
    }

    public synchronized void setLoader(final Loader delegate) {
        Loader loader = new Loader(){

            public void backgroundProcess() {
                delegate.backgroundProcess();
            }

            public ClassLoader getClassLoader() {
                return GeronimoStandardContext.this.parentClassLoader;
            }

            public Container getContainer() {
                return delegate.getContainer();
            }

            public void setContainer(Container container) {
                delegate.setContainer(container);
            }

            public boolean getDelegate() {
                return delegate.getDelegate();
            }

            public void setDelegate(boolean delegateBoolean) {
                delegate.setDelegate(delegateBoolean);
            }

            public String getInfo() {
                return delegate.getInfo();
            }

            public boolean getReloadable() {
                return false;
            }

            public void setReloadable(boolean reloadable) {
                if (reloadable) {
                    throw new UnsupportedOperationException("Reloadable context is not supported.");
                }
            }

            public void addPropertyChangeListener(PropertyChangeListener listener) {
                delegate.addPropertyChangeListener(listener);
            }

            public void addRepository(String repository) {
                delegate.addRepository(repository);
            }

            public String[] findRepositories() {
                return delegate.findRepositories();
            }

            public boolean modified() {
                return delegate.modified();
            }

            public void removePropertyChangeListener(PropertyChangeListener listener) {
                delegate.removePropertyChangeListener(listener);
            }
        };
        super.setLoader(loader);
    }

    public BeforeAfter getBeforeAfter() {
        return this.beforeAfter;
    }

    public int getContextCount() {
        return this.contextCount;
    }

    protected boolean hasRunAsServlet() {
        for (Container servlet : this.findChildren()) {
            if (!(servlet instanceof Wrapper) || ((Wrapper)servlet).getRunAs() == null) continue;
            return true;
        }
        return false;
    }

    public Subject getSubjectForRole(String runAsRole) {
        return this.runAsSource.getSubjectForRole(runAsRole);
    }

    private class SystemMethodValve
    extends ValveBase {
        private SystemMethodValve() {
        }

        public void invoke(Request request, Response response) throws IOException, ServletException {
            if (request == null && response == null) {
                try {
                    GeronimoStandardContext.super.start();
                }
                catch (LifecycleException e) {
                    throw (IOException)new IOException("wrapping lifecycle exception").initCause(e);
                }
                if (GeronimoStandardContext.this.getState() != 1 || !GeronimoStandardContext.this.getAvailable()) {
                    throw new IOException("Context did not start for an unknown reason");
                }
            } else {
                this.getNext().invoke(request, response);
            }
        }
    }
}

