/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.cluster;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.geronimo.clustering.ClusteredInvocation;
import org.apache.geronimo.clustering.ClusteredInvocationException;

public abstract class AbstractClusteredValve
extends ValveBase {
    public void invoke(Request request, Response response) throws IOException, ServletException {
        ClusteredInvocation invocation = this.newClusteredInvocation(request, response);
        try {
            invocation.invoke();
        }
        catch (ClusteredInvocationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ServletException) {
                throw (ServletException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw (IOException)new IOException().initCause(e);
        }
    }

    protected abstract ClusteredInvocation newClusteredInvocation(Request var1, Response var2);

    protected abstract class WebClusteredInvocation
    implements ClusteredInvocation {
        protected final Request request;
        protected final Response response;

        protected WebClusteredInvocation(Request request, Response response) {
            this.request = request;
            this.response = response;
        }

        protected void invokeLocally() throws ClusteredInvocationException {
            try {
                AbstractClusteredValve.this.next.invoke(this.request, this.response);
            }
            catch (IOException e) {
                throw new ClusteredInvocationException((Throwable)e);
            }
            catch (ServletException e) {
                throw new ClusteredInvocationException((Throwable)e);
            }
        }

        public String getRequestedSessionId() {
            if (null == this.request) {
                return null;
            }
            return this.request.getRequestedSessionId();
        }
    }
}

