/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.deployment;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.jar.JarFile;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilder;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.deployment.xbeans.EnvironmentType;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.ModuleBuilderExtension;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.j2ee.deployment.WebServiceBuilder;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedWebApp;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.ENCConfigBuilder;
import org.apache.geronimo.naming.deployment.GBeanResourceEnvironmentBuilder;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentBuilder;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentSetter;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.geronimo.tomcat.RealmGBean;
import org.apache.geronimo.tomcat.TomcatWebAppContext;
import org.apache.geronimo.tomcat.util.SecurityHolder;
import org.apache.geronimo.web.deployment.GenericToSpecificPlanConverter;
import org.apache.geronimo.web25.deployment.AbstractWebModuleBuilder;
import org.apache.geronimo.xbeans.geronimo.naming.GerGbeanLocatorType;
import org.apache.geronimo.xbeans.geronimo.web.tomcat.TomcatWebAppDocument;
import org.apache.geronimo.xbeans.geronimo.web.tomcat.TomcatWebAppType;
import org.apache.geronimo.xbeans.geronimo.web.tomcat.config.GerTomcatDocument;
import org.apache.geronimo.xbeans.javaee.EjbLocalRefType;
import org.apache.geronimo.xbeans.javaee.EjbRefType;
import org.apache.geronimo.xbeans.javaee.EnvEntryType;
import org.apache.geronimo.xbeans.javaee.LifecycleCallbackType;
import org.apache.geronimo.xbeans.javaee.MessageDestinationRefType;
import org.apache.geronimo.xbeans.javaee.MessageDestinationType;
import org.apache.geronimo.xbeans.javaee.PersistenceContextRefType;
import org.apache.geronimo.xbeans.javaee.PersistenceUnitRefType;
import org.apache.geronimo.xbeans.javaee.ResourceEnvRefType;
import org.apache.geronimo.xbeans.javaee.ResourceRefType;
import org.apache.geronimo.xbeans.javaee.ServiceRefType;
import org.apache.geronimo.xbeans.javaee.ServletType;
import org.apache.geronimo.xbeans.javaee.WebAppDocument;
import org.apache.geronimo.xbeans.javaee.WebAppType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatModuleBuilder
extends AbstractWebModuleBuilder {
    private static final Log log = LogFactory.getLog(TomcatModuleBuilder.class);
    private final Environment defaultEnvironment;
    private final AbstractNameQuery tomcatContainerName;
    private static final String TOMCAT_NAMESPACE = TomcatWebAppDocument.type.getDocumentElementName().getNamespaceURI();
    private static final String IS_JAVAEE = "IS_JAVAEE";
    public static final GBeanInfo GBEAN_INFO;

    public TomcatModuleBuilder(Environment defaultEnvironment, AbstractNameQuery tomcatContainerName, Collection<WebServiceBuilder> webServiceBuilder, Collection securityBuilders, Collection serviceBuilders, NamingBuilder namingBuilders, Collection<ModuleBuilderExtension> moduleBuilderExtensions, ResourceEnvironmentSetter resourceEnvironmentSetter, Kernel kernel) {
        super(kernel, securityBuilders, serviceBuilders, namingBuilders, resourceEnvironmentSetter, webServiceBuilder, moduleBuilderExtensions);
        this.defaultEnvironment = defaultEnvironment;
        this.tomcatContainerName = tomcatContainerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, boolean standAlone, String contextRoot, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        AbstractName moduleName;
        Boolean isJavaee;
        assert (moduleFile != null) : "moduleFile is null";
        assert (targetPath != null) : "targetPath is null";
        assert (!targetPath.endsWith("/")) : "targetPath must not end with a '/'";
        String specDD = null;
        WebAppType webApp = null;
        try {
            if (specDDUrl == null) {
                specDDUrl = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"WEB-INF/web.xml");
            }
            specDD = DeploymentUtil.readAll((URL)specDDUrl);
            XmlObject parsed = XmlBeansUtil.parse((String)specDD);
            XmlCursor cursor = parsed.newCursor();
            try {
                cursor.toStartDoc();
                cursor.toFirstChild();
                isJavaee = "http://java.sun.com/xml/ns/javaee".equals(cursor.getName().getNamespaceURI());
            }
            finally {
                cursor.dispose();
            }
            WebAppDocument webAppDoc = this.convertToServletSchema(parsed);
            webApp = webAppDoc.getWebApp();
            TomcatModuleBuilder.check((WebAppType)webApp);
        }
        catch (XmlException e) {
            throw new DeploymentException("Error parsing web.xml for " + targetPath, (Throwable)e);
        }
        catch (Exception e) {
            if (!moduleFile.getName().endsWith(".war")) {
                return null;
            }
            isJavaee = true;
        }
        if (webApp == null) {
            webApp = WebAppType.Factory.newInstance();
        }
        TomcatWebAppType tomcatWebApp = this.getTomcatWebApp(plan, moduleFile, standAlone, targetPath, webApp);
        contextRoot = this.getContextRoot(tomcatWebApp, contextRoot, webApp, standAlone, moduleFile, targetPath);
        EnvironmentType environmentType = tomcatWebApp.getEnvironment();
        Environment environment = EnvironmentBuilder.buildEnvironment((EnvironmentType)environmentType, (Environment)this.defaultEnvironment);
        String warName = "";
        File temp = new File(moduleFile.getName());
        if (temp.isFile()) {
            warName = temp.getName();
            if (warName.lastIndexOf(46) > -1) {
                warName = warName.substring(0, warName.lastIndexOf(46));
            }
        } else {
            try {
                warName = temp.getCanonicalFile().getName();
                if (warName.equals("")) {
                    warName = "$root-dir$";
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        idBuilder.resolve(environment, warName, "war");
        if (earName == null) {
            earName = naming.createRootName(environment.getConfigId(), "null", "J2EEApplication");
            moduleName = naming.createChildName(earName, environment.getConfigId().toString(), "WebModule");
        } else {
            moduleName = naming.createChildName(earName, targetPath, "WebModule");
        }
        AnnotatedWebApp annotatedWebApp = new AnnotatedWebApp(webApp);
        WebModule module = new WebModule(standAlone, moduleName, environment, moduleFile, targetPath, (XmlObject)webApp, (XmlObject)tomcatWebApp, specDD, contextRoot, TOMCAT_NAMESPACE, annotatedWebApp);
        for (ModuleBuilderExtension mbe : this.moduleBuilderExtensions) {
            mbe.createModule((Module)module, plan, moduleFile, targetPath, specDDUrl, environment, (Object)contextRoot, earName, naming, idBuilder);
        }
        module.getSharedContext().put(IS_JAVAEE, isJavaee);
        return module;
    }

    private String getContextRoot(TomcatWebAppType tomcatWebApp, String contextRoot, WebAppType webApp, boolean standAlone, JarFile moduleFile, String targetPath) {
        if (tomcatWebApp.isSetContextRoot()) {
            contextRoot = tomcatWebApp.getContextRoot();
        } else if (contextRoot == null || contextRoot.trim().equals("")) {
            contextRoot = this.determineDefaultContextRoot(webApp, standAlone, moduleFile, targetPath);
        }
        contextRoot = contextRoot.trim();
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        return contextRoot;
    }

    TomcatWebAppType getTomcatWebApp(Object plan, JarFile moduleFile, boolean standAlone, String targetPath, WebAppType webApp) throws DeploymentException {
        XmlObject rawPlan = null;
        try {
            TomcatWebAppType tomcatWebApp;
            block12: {
                try {
                    if (plan instanceof XmlObject) {
                        rawPlan = (XmlObject)plan;
                        break block12;
                    }
                    if (plan != null) {
                        rawPlan = XmlBeansUtil.parse((URL)((File)plan).toURL(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                        break block12;
                    }
                    URL path = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"WEB-INF/geronimo-web.xml");
                    try {
                        rawPlan = XmlBeansUtil.parse((URL)path, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                    }
                    catch (FileNotFoundException e) {
                        path = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"WEB-INF/geronimo-tomcat.xml");
                        try {
                            rawPlan = XmlBeansUtil.parse((URL)path, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                        }
                        catch (FileNotFoundException e1) {
                            log.warn((Object)("Web application " + targetPath + " does not contain a WEB-INF/geronimo-web.xml deployment plan.  This may or may not be a problem, depending on whether you have things like resource references that need to be resolved.  You can also give the deployer a separate deployment plan file on the command line."));
                        }
                    }
                }
                catch (IOException e) {
                    log.warn((Object)e);
                }
            }
            if (rawPlan != null) {
                XmlObject webPlan = new GenericToSpecificPlanConverter(GerTomcatDocument.type.getDocumentElementName().getNamespaceURI(), TomcatWebAppDocument.type.getDocumentElementName().getNamespaceURI(), "tomcat").convertToSpecificPlan(rawPlan);
                tomcatWebApp = (TomcatWebAppType)webPlan.changeType(TomcatWebAppType.type);
                XmlBeansUtil.validateDD((XmlObject)tomcatWebApp);
            } else {
                tomcatWebApp = this.createDefaultPlan();
            }
            return tomcatWebApp;
        }
        catch (XmlException e) {
            throw new DeploymentException("xml problem for web app " + targetPath, (Throwable)e);
        }
    }

    private TomcatWebAppType createDefaultPlan() {
        return TomcatWebAppType.Factory.newInstance();
    }

    public void initContext(EARContext earContext, Module module, ClassLoader cl) throws DeploymentException {
        TomcatWebAppType gerWebApp = (TomcatWebAppType)module.getVendorDD();
        boolean hasSecurityRealmName = gerWebApp.isSetSecurityRealmName();
        this.basicInitContext(earContext, module, gerWebApp, hasSecurityRealmName);
        for (ModuleBuilderExtension mbe : this.moduleBuilderExtensions) {
            mbe.initContext(earContext, module, cl);
        }
    }

    public void addGBeans(EARContext earContext, Module module, ClassLoader cl, Collection repository) throws DeploymentException {
        EARContext moduleContext = module.getEarContext();
        ClassLoader webClassLoader = moduleContext.getClassLoader();
        AbstractName moduleName = moduleContext.getModuleName();
        WebModule webModule = (WebModule)module;
        WebAppType webApp = (WebAppType)webModule.getSpecDD();
        TomcatWebAppType tomcatWebApp = (TomcatWebAppType)webModule.getVendorDD();
        GBeanData webModuleData = new GBeanData(moduleName, TomcatWebAppContext.GBEAN_INFO);
        this.configureBasicWebModuleAttributes(webApp, tomcatWebApp, moduleContext, earContext, webModule, webModuleData);
        try {
            Class<?> baseServletClass;
            moduleContext.addGBean(webModuleData);
            Set securityRoles = TomcatModuleBuilder.collectRoleNames((WebAppType)webApp);
            HashMap rolePermissions = new HashMap();
            webModuleData.setAttribute("contextPath", (Object)webModule.getContextRoot());
            GBeanResourceEnvironmentBuilder rebuilder = new GBeanResourceEnvironmentBuilder(webModuleData);
            this.resourceEnvironmentSetter.setResourceEnvironment((ResourceEnvironmentBuilder)rebuilder, (XmlObject[])webApp.getResourceRefArray(), tomcatWebApp.getResourceRefArray());
            if (tomcatWebApp.isSetWebContainer()) {
                AbstractNameQuery webContainerName = ENCConfigBuilder.getGBeanQuery((String)"GBean", (GerGbeanLocatorType)tomcatWebApp.getWebContainer());
                webModuleData.setReferencePattern("Container", webContainerName);
            } else {
                webModuleData.setReferencePattern("Container", this.tomcatContainerName);
            }
            if (tomcatWebApp.isSetHost()) {
                String virtualServer = tomcatWebApp.getHost().trim();
                webModuleData.setAttribute("virtualServer", (Object)virtualServer);
            }
            if (tomcatWebApp.isSetCrossContext()) {
                webModuleData.setAttribute("crossContext", (Object)Boolean.TRUE);
            }
            if (tomcatWebApp.isSetDisableCookies()) {
                webModuleData.setAttribute("disableCookies", (Object)Boolean.TRUE);
            }
            if (tomcatWebApp.isSetTomcatRealm()) {
                String tomcatRealm = tomcatWebApp.getTomcatRealm().trim();
                AbstractName realmName = earContext.getNaming().createChildName(moduleName, tomcatRealm, RealmGBean.GBEAN_INFO.getJ2eeType());
                webModuleData.setReferencePattern("TomcatRealm", realmName);
            }
            if (tomcatWebApp.isSetValveChain()) {
                String valveChain = tomcatWebApp.getValveChain().trim();
                AbstractName valveName = earContext.getNaming().createChildName(moduleName, valveChain, "TomcatValve");
                webModuleData.setReferencePattern("TomcatValveChain", valveName);
            }
            if (tomcatWebApp.isSetListenerChain()) {
                String listenerChain = tomcatWebApp.getListenerChain().trim();
                AbstractName listenerName = earContext.getNaming().createChildName(moduleName, listenerChain, "TomcatLifecycleListener");
                webModuleData.setReferencePattern("LifecycleListenerChain", listenerName);
            }
            if (tomcatWebApp.isSetCluster()) {
                String cluster = tomcatWebApp.getCluster().trim();
                AbstractName clusterName = earContext.getNaming().createChildName(moduleName, cluster, "Cluster");
                webModuleData.setReferencePattern("Cluster", clusterName);
            }
            if (tomcatWebApp.isSetManager()) {
                String manager = tomcatWebApp.getManager().trim();
                AbstractName managerName = earContext.getNaming().createChildName(moduleName, manager, "Manager");
                webModuleData.setReferencePattern("Manager", managerName);
            }
            ServletType[] servletTypes = webApp.getServletArray();
            HashMap<String, AbstractName> webServices = new HashMap<String, AbstractName>();
            try {
                baseServletClass = webClassLoader.loadClass(Servlet.class.getName());
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not load javax.servlet.Servlet in web classloader", (Throwable)e);
            }
            for (ServletType servletType : servletTypes) {
                Class<?> servletClass;
                this.processRoleRefPermissions(servletType, securityRoles, rolePermissions);
                if (!servletType.isSetServletClass()) continue;
                String servletName = servletType.getServletName().getStringValue().trim();
                String servletClassName = servletType.getServletClass().getStringValue().trim();
                try {
                    servletClass = webClassLoader.loadClass(servletClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentException("Could not load servlet class " + servletClassName, (Throwable)e);
                }
                if (baseServletClass.isAssignableFrom(servletClass)) continue;
                AbstractName servletAbstractName = moduleContext.getNaming().createChildName(moduleName, servletName, "Servlet");
                GBeanData servletData = new GBeanData();
                servletData.setAbstractName(servletAbstractName);
                boolean configured = false;
                for (WebServiceBuilder serviceBuilder : this.webServiceBuilder) {
                    if (!serviceBuilder.configurePOJO(servletData, servletName, module, servletClassName, (DeploymentContext)moduleContext)) continue;
                    configured = true;
                    break;
                }
                if (!configured) {
                    throw new DeploymentException("POJO web service: " + servletName + " not configured by any web service builder");
                }
                ReferencePatterns patterns = servletData.getReferencePatterns("WebServiceContainerFactory");
                AbstractName wsContainerFactoryName = patterns.getAbstractName();
                webServices.put(servletName, wsContainerFactoryName);
                webModuleData.addDependency(wsContainerFactoryName);
            }
            this.addUnmappedJSPPermissions(securityRoles, rolePermissions);
            webModuleData.setAttribute("webServices", webServices);
            if (tomcatWebApp.isSetSecurityRealmName()) {
                if (earContext.getSecurityConfiguration() == null) {
                    throw new DeploymentException("You have specified a <security-realm-name> for the webapp " + moduleName + " but no <security> configuration (role mapping) is supplied in the Geronimo plan for the web application (or the Geronimo plan for the EAR if the web app is in an EAR)");
                }
                SecurityHolder securityHolder = new SecurityHolder();
                securityHolder.setSecurityRealm(tomcatWebApp.getSecurityRealmName().trim());
                webModuleData.setReferencePattern("RunAsSource", earContext.getJaccManagerName());
                String policyContextID = moduleName.toString().replaceAll("[, :]", "_");
                securityHolder.setPolicyContextID(policyContextID);
                ComponentPermissions componentPermissions = this.buildSpecSecurityConfig(webApp, securityRoles, rolePermissions);
                earContext.addSecurityContext(policyContextID, (Object)componentPermissions);
                securityHolder.setSecurity(true);
                webModuleData.setAttribute("securityHolder", (Object)securityHolder);
            }
            for (ModuleBuilderExtension mbe : this.moduleBuilderExtensions) {
                mbe.addGBeans(earContext, module, cl, repository);
            }
            if (!webApp.getMetadataComplete()) {
                webApp.setMetadataComplete(true);
                module.setOriginalSpecDD(module.getSpecDD().toString());
                webModuleData.setAttribute("deploymentDescriptor", (Object)module.getOriginalSpecDD());
            }
            if (((Boolean)module.getSharedContext().get(IS_JAVAEE)).booleanValue()) {
                WebAppType shortWebApp = (WebAppType)webApp.copy();
                shortWebApp.setEjbLocalRefArray(new EjbLocalRefType[0]);
                shortWebApp.setEjbRefArray(new EjbRefType[0]);
                shortWebApp.setEnvEntryArray(new EnvEntryType[0]);
                shortWebApp.setMessageDestinationArray(new MessageDestinationType[0]);
                shortWebApp.setMessageDestinationRefArray(new MessageDestinationRefType[0]);
                shortWebApp.setPersistenceContextRefArray(new PersistenceContextRefType[0]);
                shortWebApp.setPersistenceUnitRefArray(new PersistenceUnitRefType[0]);
                shortWebApp.setPostConstructArray(new LifecycleCallbackType[0]);
                shortWebApp.setPreDestroyArray(new LifecycleCallbackType[0]);
                shortWebApp.setResourceEnvRefArray(new ResourceEnvRefType[0]);
                shortWebApp.setResourceRefArray(new ResourceRefType[0]);
                shortWebApp.setServiceRefArray(new ServiceRefType[0]);
                File webXml = new File(moduleContext.getBaseDir(), "/WEB-INF/web.xml");
                File inPlaceDir = moduleContext.getInPlaceConfigurationDir();
                if (inPlaceDir != null) {
                    webXml = new File(inPlaceDir, "/WEB-INF/web.xml");
                }
                webXml.getParentFile().mkdirs();
                try {
                    FileWriter outFile = new FileWriter(webXml);
                    XmlOptions opts = new XmlOptions();
                    opts.setSaveAggressiveNamespaces();
                    opts.setSaveSyntheticDocumentElement(WebAppDocument.type.getDocumentElementName());
                    opts.setUseDefaultNamespace();
                    opts.setSavePrettyPrint();
                    outFile.write(shortWebApp.xmlText(opts));
                    outFile.flush();
                    outFile.close();
                }
                catch (Exception e) {
                    throw new DeploymentException((Throwable)e);
                }
            }
            if (!module.isStandAlone()) {
                ConfigurationData moduleConfigurationData = moduleContext.getConfigurationData();
                earContext.addChildConfiguration(module.getTargetPath(), moduleConfigurationData);
            }
        }
        catch (DeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to initialize GBean for web app " + module.getName(), (Throwable)e);
        }
    }

    public String getSchemaNamespace() {
        return TOMCAT_NAMESPACE;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(TomcatModuleBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("tomcatContainerName", AbstractNameQuery.class, true, true);
        infoBuilder.addReference("WebServiceBuilder", WebServiceBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("SecurityBuilders", NamespaceDrivenBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("ServiceBuilders", NamespaceDrivenBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("NamingBuilders", NamingBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("ModuleBuilderExtensions", ModuleBuilderExtension.class, "ModuleBuilder");
        infoBuilder.addReference("ResourceEnvironmentSetter", ResourceEnvironmentSetter.class, "ModuleBuilder");
        infoBuilder.addAttribute("kernel", Kernel.class, false);
        infoBuilder.addInterface(ModuleBuilder.class);
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "tomcatContainerName", "WebServiceBuilder", "SecurityBuilders", "ServiceBuilders", "NamingBuilders", "ModuleBuilderExtensions", "ResourceEnvironmentSetter", "kernel"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

