/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.realm;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.catalina.realm.JAASCallbackHandler;
import org.apache.catalina.realm.JAASRealm;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.tomcat.JAASTomcatPrincipal;

public class TomcatJAASRealm
extends JAASRealm
implements Cloneable {
    private static final Log log = LogFactory.getLog((Class)TomcatJAASRealm.class);
    private static final String DEFAULT_NAME = "tomcat";
    protected static final String info = "org.apache.geronimo.tomcat.realm.TomcatJAASRealm/1.0";
    protected static final String name = "TomcatJAASRealm";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Principal authenticate(String username, String credentials) {
        try {
            Principal principal;
            LoginContext loginContext = null;
            if (this.appName == null) {
                this.appName = DEFAULT_NAME;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("jaasRealm.beginLogin", (Object)username, (Object)this.appName));
            }
            ClassLoader ocl = null;
            if (this.isUseContextClassLoader()) {
                ocl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            }
            try {
                loginContext = new LoginContext(this.appName, (CallbackHandler)new JAASCallbackHandler((JAASRealm)this, username, credentials));
            }
            catch (Throwable e) {
                log.error((Object)sm.getString("jaasRealm.unexpectedError"), e);
                Principal principal2 = null;
                return principal2;
            }
            finally {
                if (this.isUseContextClassLoader()) {
                    Thread.currentThread().setContextClassLoader(ocl);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Login context created " + username));
            }
            Subject subject = null;
            try {
                loginContext.login();
                Subject tempSubject = loginContext.getSubject();
                if (tempSubject == null) {
                    if (!log.isDebugEnabled()) return null;
                    log.debug((Object)sm.getString("jaasRealm.failedLogin", (Object)username));
                    return null;
                }
                subject = ContextManager.getServerSideSubject((Subject)tempSubject);
                if (subject == null) {
                    if (!log.isDebugEnabled()) return null;
                    log.debug((Object)sm.getString("jaasRealm.failedLogin", (Object)username));
                    return null;
                }
            }
            catch (AccountExpiredException e) {
                if (!log.isDebugEnabled()) return null;
                log.debug((Object)sm.getString("jaasRealm.accountExpired", (Object)username));
                return null;
            }
            catch (CredentialExpiredException e) {
                if (!log.isDebugEnabled()) return null;
                log.debug((Object)sm.getString("jaasRealm.credentialExpired", (Object)username));
                return null;
            }
            catch (FailedLoginException e) {
                if (!log.isDebugEnabled()) return null;
                log.debug((Object)sm.getString("jaasRealm.failedLogin", (Object)username));
                return null;
            }
            catch (LoginException e) {
                log.warn((Object)sm.getString("jaasRealm.loginException", (Object)username), (Throwable)e);
                return null;
            }
            catch (Throwable e) {
                log.error((Object)sm.getString("jaasRealm.unexpectedError"), e);
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("jaasRealm.loginContextCreated", (Object)username));
            }
            if ((principal = this.createPrincipal(username, subject)) == null) {
                log.debug((Object)sm.getString("jaasRealm.authenticateFailure", (Object)username));
                return null;
            }
            if (!log.isDebugEnabled()) return principal;
            log.debug((Object)sm.getString("jaasRealm.authenticateSuccess", (Object)username));
            return principal;
        }
        catch (Throwable t) {
            log.error((Object)"error ", t);
            return null;
        }
    }

    protected Principal createPrincipal(String username, Subject subject) {
        Object password = null;
        ArrayList<String> roles = new ArrayList<String>();
        Principal userPrincipal = null;
        Iterator<Principal> principals = subject.getPrincipals().iterator();
        while (principals.hasNext()) {
            Principal principal = principals.next();
            String principalClass = principal.getClass().getName();
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("jaasRealm.checkPrincipal", (Object)principal, (Object)principalClass));
            }
            if (userPrincipal == null && this.userClasses.contains(principalClass)) {
                userPrincipal = principal;
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("jaasRealm.userPrincipalSuccess", (Object)principal.getName()));
                }
            }
            if (!this.roleClasses.contains(principalClass)) continue;
            roles.add(principal.getName());
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)sm.getString("jaasRealm.rolePrincipalAdd", (Object)principal.getName()));
        }
        if (userPrincipal == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("jaasRealm.userPrincipalFailure"));
                log.debug((Object)sm.getString("jaasRealm.rolePrincipalFailure"));
            }
        } else if (roles.size() == 0 && log.isDebugEnabled()) {
            log.debug((Object)sm.getString("jaasRealm.rolePrincipalFailure"));
        }
        JAASTomcatPrincipal jaasPrincipal = new JAASTomcatPrincipal(username);
        jaasPrincipal.setSubject(subject);
        jaasPrincipal.setRoles(roles);
        return jaasPrincipal;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean hasRole(Principal principal, String role) {
        if (principal == null || role == null || !(principal instanceof JAASTomcatPrincipal)) {
            return false;
        }
        JAASTomcatPrincipal jtp = (JAASTomcatPrincipal)principal;
        return jtp.getRoles().contains(role);
    }
}

