/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.tomcat.ConnectorGBean;
import org.apache.geronimo.tomcat.TomcatContainer;
import org.apache.geronimo.tomcat.TomcatSecureConnector;

public class HttpsConnectorGBean
extends ConnectorGBean
implements TomcatSecureConnector {
    private final ServerInfo serverInfo;
    private String keystoreFileName;
    private String truststoreFileName;
    private String algorithm;
    public static final GBeanInfo GBEAN_INFO;

    public HttpsConnectorGBean(String name, String protocol, String host, int port, TomcatContainer container, ServerInfo serverInfo) throws Exception {
        super(name, protocol, host, port, container);
        if (serverInfo == null) {
            throw new IllegalArgumentException("serverInfo cannot be null.");
        }
        this.serverInfo = serverInfo;
    }

    protected void initializeParams(String protocol, Map params) {
        super.initializeParams(protocol, params);
        params.put("scheme", "https");
        params.put("secure", "true");
    }

    protected void validateProtocol(String protocol) {
        if (protocol != null && !protocol.equals("HTTPS")) {
            throw new IllegalStateException("HttpsConnectorGBean only supports HTTPS");
        }
    }

    public String getKeystoreFileName() {
        return this.keystoreFileName;
    }

    public void setKeystoreFileName(String name) {
        this.keystoreFileName = name;
        this.connector.setAttribute("keystoreFile", (Object)this.serverInfo.resolveServerPath(this.keystoreFileName));
    }

    public String getTruststoreFileName() {
        return this.truststoreFileName;
    }

    public void setTruststoreFileName(String name) {
        this.truststoreFileName = name;
        this.connector.setAttribute("truststoreFile", (Object)this.serverInfo.resolveServerPath(this.truststoreFileName));
    }

    public void setKeystorePassword(String password) {
        this.connector.setAttribute("keystorePass", (Object)password);
    }

    public void setTruststorePassword(String password) {
        this.connector.setAttribute("truststorePass", (Object)password);
    }

    public String getKeystoreType() {
        return (String)this.connector.getAttribute("keystoreType");
    }

    public void setKeystoreType(String type) {
        this.connector.setAttribute("keystoreType", (Object)type);
    }

    public String getTruststoreType() {
        return (String)this.connector.getAttribute("truststoreType");
    }

    public void setTruststoreType(String type) {
        this.connector.setAttribute("truststoreType", (Object)type);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        if ("default".equalsIgnoreCase(algorithm)) {
            algorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        this.connector.setAttribute("algorithm", (Object)algorithm);
    }

    public String getSecureProtocol() {
        return (String)this.connector.getAttribute("sslProtocol");
    }

    public void setSecureProtocol(String protocol) {
        this.connector.setAttribute("sslProtocol", (Object)protocol);
    }

    public boolean isClientAuthRequired() {
        Object value = this.connector.getAttribute("clientAuth");
        return value == null ? false : new Boolean(value.toString());
    }

    public void setClientAuthRequired(boolean clientCert) {
        this.connector.setAttribute("clientAuth", (Object)new Boolean(clientCert));
    }

    public String getCiphers() {
        return (String)this.connector.getAttribute("ciphers");
    }

    public void setCiphers(String ciphers) {
        this.connector.setAttribute("ciphers", (Object)ciphers);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"Tomcat Connector", (Class)HttpsConnectorGBean.class, (GBeanInfo)ConnectorGBean.GBEAN_INFO);
        infoFactory.addAttribute("keystoreFileName", String.class, true, true);
        infoFactory.addAttribute("truststoreFileName", String.class, true, true);
        infoFactory.addAttribute("algorithm", String.class, true, true);
        infoFactory.addAttribute("keystorePassword", String.class, true, true);
        infoFactory.addAttribute("truststorePassword", String.class, true, true);
        infoFactory.addAttribute("secureProtocol", String.class, true, true);
        infoFactory.addAttribute("keystoreType", String.class, true, true);
        infoFactory.addAttribute("truststoreType", String.class, true, true);
        infoFactory.addAttribute("clientAuthRequired", Boolean.TYPE, true, true);
        infoFactory.addAttribute("ciphers", String.class, true, true);
        infoFactory.addInterface(TomcatSecureConnector.class);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.setConstructor(new String[]{"name", "protocol", "host", "port", "TomcatContainer", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

