/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.tools.loader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.exceptions.DDBeanCreateException;
import javax.enterprise.deploy.shared.ModuleType;
import org.apache.geronimo.deployment.tools.DDBeanRootImpl;
import org.osgi.framework.Bundle;

public abstract class AbstractDeployable
implements DeployableObject {
    private final Bundle bundle;
    private final ModuleType type;
    private final DDBeanRoot root;
    private final List<String> entries;

    protected AbstractDeployable(ModuleType type, Bundle bundle, String rootDD) throws DDBeanCreateException {
        this.type = type;
        this.bundle = bundle;
        URL dd = bundle.getResource(rootDD);
        this.root = new DDBeanRootImpl(this, dd);
        this.entries = new ArrayList<String>();
        Enumeration paths = bundle.getEntryPaths("/");
        if (paths.hasMoreElements()) {
            String entry = (String)paths.nextElement();
            while (paths.hasMoreElements()) {
                this.entries.add(entry);
            }
        }
    }

    public ModuleType getType() {
        return this.type;
    }

    public DDBeanRoot getDDBeanRoot() {
        return this.root;
    }

    public DDBeanRoot getDDBeanRoot(String filename) throws FileNotFoundException, DDBeanCreateException {
        URL resource = this.bundle.getResource(filename);
        if (resource == null) {
            throw new DDBeanCreateException("Unable to construct URL for " + filename);
        }
        return new DDBeanRootImpl(null, resource);
    }

    public DDBean[] getChildBean(String xpath) {
        return this.root.getChildBean(xpath);
    }

    public String[] getText(String xpath) {
        return this.root.getText(xpath);
    }

    public Enumeration entries() {
        return Collections.enumeration(this.entries);
    }

    public InputStream getEntry(String name) {
        try {
            URL resource = this.bundle.getResource(name);
            if (resource == null) {
                return null;
            }
            return resource.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    protected Bundle getModuleBundle() {
        return this.bundle;
    }

    public Class getClassFromScope(String className) {
        try {
            return this.bundle.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public String getModuleDTDVersion() {
        throw new UnsupportedOperationException();
    }
}

