/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.sharedlib;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.config.MultiParentClassLoader;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class SharedLib {
    public static final GBeanInfo GBEAN_INFO;

    public SharedLib(ClassLoader classLoader, String[] classesDirs, String[] libDirs, ServerInfo serverInfo) throws MalformedURLException {
        File dir;
        int i;
        MultiParentClassLoader multiParentClassLoader = (MultiParentClassLoader)classLoader;
        HashSet<URL> currentUrls = new HashSet<URL>(Arrays.asList(multiParentClassLoader.getURLs()));
        int size = 0;
        if (classesDirs != null) {
            size += classesDirs.length;
        }
        if (libDirs != null) {
            size += libDirs.length;
        }
        LinkedHashSet<URL> newUrls = new LinkedHashSet<URL>(size);
        if (classesDirs != null) {
            for (i = 0; i < classesDirs.length; ++i) {
                String classesDir = classesDirs[i];
                dir = serverInfo.resolveServer(classesDir);
                if (!dir.exists() && !dir.mkdirs()) {
                    throw new IllegalArgumentException("Failed to create classes dir: " + dir);
                }
                if (!dir.isDirectory()) {
                    throw new IllegalArgumentException("Shared classes dir is not a directory: " + dir);
                }
                URL location = dir.toURL();
                if (currentUrls.contains(location)) continue;
                newUrls.add(location);
            }
        }
        if (libDirs != null) {
            for (i = 0; i < libDirs.length; ++i) {
                String libDir = libDirs[i];
                dir = serverInfo.resolveServer(libDir);
                if (!dir.exists() && !dir.mkdirs()) {
                    throw new IllegalArgumentException("Failed to create lib dir: " + dir);
                }
                if (!dir.isDirectory()) {
                    throw new IllegalArgumentException("Shared lib dir is not a directory: " + dir);
                }
                File[] files = dir.listFiles();
                for (int j = 0; j < files.length; ++j) {
                    URL location;
                    File file = files[j];
                    if (!file.canRead() || !file.getName().endsWith(".jar") && !file.getName().endsWith(".zip") || currentUrls.contains(location = file.toURL())) continue;
                    newUrls.add(location);
                }
            }
        }
        for (URL url : newUrls) {
            multiParentClassLoader.addURL(url);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(SharedLib.class);
        infoFactory.addAttribute("classLoader", ClassLoader.class, false, false);
        infoFactory.addAttribute("classesDirs", String[].class, true, true);
        infoFactory.addAttribute("libDirs", String[].class, true, true);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.setConstructor(new String[]{"classLoader", "classesDirs", "libDirs", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

