/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.jmx;

import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.NoSuchAttributeException;
import org.apache.geronimo.kernel.NoSuchOperationException;
import org.apache.geronimo.kernel.lifecycle.LifecycleAdapter;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;
import org.apache.geronimo.system.jmx.JMXUtil;

public class KernelMBeanServer
implements MBeanServer {
    private static final AbstractNameQuery ALL = new AbstractNameQuery(null, Collections.EMPTY_MAP, Collections.EMPTY_SET);
    private final HashMap objetNameToAbstractName = new HashMap();
    private final Kernel kernel;

    public KernelMBeanServer(Kernel kernel) {
        this.kernel = kernel;
    }

    public void doStart() {
        this.kernel.getLifecycleMonitor().addLifecycleListener((LifecycleListener)new GBeanRegistrationListener(), ALL);
        Set allNames = this.kernel.listGBeans(ALL);
        for (AbstractName abstractName : allNames) {
            this.register(abstractName);
        }
    }

    public synchronized AbstractName getAbstractNameFor(ObjectName objectName) {
        return (AbstractName)this.objetNameToAbstractName.get(objectName);
    }

    private synchronized void register(AbstractName abstractName) {
        this.objetNameToAbstractName.put(abstractName.getObjectName(), abstractName);
    }

    private synchronized void unregister(AbstractName abstractName) {
        this.objetNameToAbstractName.remove(abstractName.getObjectName());
    }

    public void doFail() {
        this.doStop();
    }

    public synchronized void doStop() {
        this.objetNameToAbstractName.clear();
    }

    public AbstractName toAbstractName(ObjectName objectName) throws InstanceNotFoundException {
        AbstractName abstractName = this.getAbstractNameFor(objectName);
        if (abstractName == null) {
            throw new InstanceNotFoundException(objectName.getCanonicalName());
        }
        return abstractName;
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        AbstractName abstractName = this.toAbstractName(name);
        try {
            return this.kernel.getAttribute(abstractName, attribute);
        }
        catch (NoSuchAttributeException e) {
            throw (AttributeNotFoundException)new AttributeNotFoundException(attribute).initCause(e);
        }
        catch (GBeanNotFoundException e) {
            throw (InstanceNotFoundException)new InstanceNotFoundException(name.getCanonicalName()).initCause(e);
        }
        catch (InternalKernelException e) {
            throw new MBeanException(KernelMBeanServer.unwrapInternalKernelException(e));
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        AbstractName abstractName = this.toAbstractName(name);
        AttributeList attributeList = new AttributeList(attributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            String attribute = attributes[i];
            try {
                Object value = this.kernel.getAttribute(abstractName, attribute);
                attributeList.add(i, new Attribute(attribute, value));
                continue;
            }
            catch (NoSuchAttributeException e) {
                continue;
            }
            catch (GBeanNotFoundException e) {
                throw (InstanceNotFoundException)new InstanceNotFoundException(name.getCanonicalName()).initCause(e);
            }
            catch (InternalKernelException e) {
                throw new ReflectionException(KernelMBeanServer.unwrapInternalKernelException(e));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return attributeList;
    }

    public String getDefaultDomain() {
        return this.kernel.getKernelName();
    }

    public Integer getMBeanCount() {
        return new Integer(this.kernel.listGBeans((AbstractNameQuery)null).size());
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, ReflectionException {
        GBeanInfo gbeanInfo;
        AbstractName abstractName = this.toAbstractName(name);
        try {
            gbeanInfo = this.kernel.getGBeanInfo(abstractName);
        }
        catch (GBeanNotFoundException e) {
            throw (InstanceNotFoundException)new InstanceNotFoundException(name.getCanonicalName()).initCause(e);
        }
        catch (InternalKernelException e) {
            throw new ReflectionException(KernelMBeanServer.unwrapInternalKernelException(e));
        }
        return JMXUtil.toMBeanInfo(gbeanInfo);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        AbstractName abstractName = this.toAbstractName(name);
        try {
            return this.kernel.invoke(abstractName, operationName, params, signature);
        }
        catch (NoSuchOperationException e) {
            throw new ReflectionException((NoSuchMethodException)new NoSuchMethodException(e.getMessage()).initCause(e));
        }
        catch (GBeanNotFoundException e) {
            if (name.equals(e.getGBeanName())) {
                throw (InstanceNotFoundException)new InstanceNotFoundException(name.getCanonicalName()).initCause(e);
            }
            throw new MBeanException((Exception)((Object)e));
        }
        catch (InternalKernelException e) {
            throw new MBeanException(KernelMBeanServer.unwrapInternalKernelException(e));
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public boolean isRegistered(ObjectName name) {
        AbstractName abstractName = this.getAbstractNameFor(name);
        if (abstractName == null) {
            return false;
        }
        return this.kernel.isLoaded(abstractName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set queryNames(ObjectName pattern, QueryExp query) {
        LinkedHashSet names;
        if (pattern != null && pattern.getDomain().length() == 0) {
            try {
                pattern = new ObjectName(this.kernel.getKernelName(), pattern.getKeyPropertyList());
            }
            catch (MalformedObjectNameException e) {
                throw new AssertionError((Object)e);
            }
        }
        KernelMBeanServer kernelMBeanServer = this;
        synchronized (kernelMBeanServer) {
            names = new LinkedHashSet(this.objetNameToAbstractName.keySet());
        }
        HashSet<ObjectName> result = new HashSet<ObjectName>(names.size());
        for (ObjectName name : names) {
            if (pattern != null && !pattern.apply(name)) continue;
            if (query != null) {
                query.setMBeanServer(this);
                try {
                    if (!query.apply(name)) continue;
                    result.add(name);
                }
                catch (Exception e) {}
                continue;
            }
            result.add(name);
        }
        return result;
    }

    public Set queryMBeans(ObjectName pattern, QueryExp query) {
        Set names = this.queryNames(pattern, query);
        HashSet<ObjectInstance> objectInstances = new HashSet<ObjectInstance>(names.size());
        for (ObjectName name : names) {
            try {
                objectInstances.add(this.getObjectInstance(name));
            }
            catch (InstanceNotFoundException e) {}
        }
        return objectInstances;
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException {
        AbstractName abstractName = this.toAbstractName(name);
        String attributeName = attribute.getName();
        Object attributeValue = attribute.getValue();
        try {
            this.kernel.setAttribute(abstractName, attributeName, attributeValue);
        }
        catch (NoSuchAttributeException e) {
            throw (AttributeNotFoundException)new AttributeNotFoundException(attributeName).initCause(e);
        }
        catch (GBeanNotFoundException e) {
            throw (InstanceNotFoundException)new InstanceNotFoundException(name.getCanonicalName()).initCause(e);
        }
        catch (InternalKernelException e) {
            throw new MBeanException(KernelMBeanServer.unwrapInternalKernelException(e));
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        AbstractName abstractName = this.toAbstractName(name);
        AttributeList set = new AttributeList(attributes.size());
        for (Attribute attribute : attributes) {
            String attributeName = attribute.getName();
            Object attributeValue = attribute.getValue();
            try {
                this.kernel.setAttribute(abstractName, attributeName, attributeValue);
                set.add(attribute);
            }
            catch (NoSuchAttributeException e) {
            }
            catch (GBeanNotFoundException e) {
                throw (InstanceNotFoundException)new InstanceNotFoundException(name.getCanonicalName()).initCause(e);
            }
            catch (InternalKernelException e) {
                throw new ReflectionException(KernelMBeanServer.unwrapInternalKernelException(e));
            }
            catch (Exception e) {
            }
        }
        return set;
    }

    public String[] getDomains() {
        HashSet<String> domains = new HashSet<String>();
        Set names = this.kernel.listGBeans((AbstractNameQuery)null);
        for (ObjectName objectName : names) {
            domains.add(objectName.getDomain());
        }
        return domains.toArray(new String[domains.size()]);
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        AbstractName abstractName = this.toAbstractName(objectName);
        try {
            GBeanInfo gbeanInfo = this.kernel.getGBeanInfo(abstractName);
            return new ObjectInstance(objectName, gbeanInfo.getClassName());
        }
        catch (GBeanNotFoundException e) {
            throw (InstanceNotFoundException)new InstanceNotFoundException(objectName.getCanonicalName()).initCause(e);
        }
    }

    public ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        AbstractName abstractName = this.toAbstractName(objectName);
        try {
            return this.kernel.getClassLoaderFor(abstractName);
        }
        catch (GBeanNotFoundException e) {
            throw (InstanceNotFoundException)new InstanceNotFoundException(objectName.getCanonicalName()).initCause(e);
        }
    }

    private static Exception unwrapInternalKernelException(InternalKernelException e) {
        if (e.getCause() instanceof Exception) {
            return (Exception)e.getCause();
        }
        return e;
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object o) throws InstanceNotFoundException {
        throw new SecurityException("Operation not allowed");
    }

    public void addNotificationListener(ObjectName objectName, ObjectName objectName1, NotificationFilter notificationFilter, Object o) throws InstanceNotFoundException {
        throw new SecurityException("Operation not allowed");
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName1) throws InstanceNotFoundException, ListenerNotFoundException {
        throw new SecurityException("Operation not allowed");
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        throw new SecurityException("Operation not allowed");
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName1, NotificationFilter notificationFilter, Object o) throws InstanceNotFoundException, ListenerNotFoundException {
        throw new SecurityException("Operation not allowed");
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object o) throws InstanceNotFoundException, ListenerNotFoundException {
        throw new SecurityException("Operation not allowed");
    }

    public boolean isInstanceOf(ObjectName objectName, String s) throws InstanceNotFoundException {
        throw new SecurityException("Operation not allowed");
    }

    public ObjectInstance createMBean(String s, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        throw new SecurityException("Operation not allowed");
    }

    public ObjectInstance createMBean(String s, ObjectName objectName, ObjectName objectName1) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        throw new SecurityException("Operation not allowed");
    }

    public ObjectInstance createMBean(String s, ObjectName objectName, Object[] objects, String[] strings) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        throw new SecurityException("Operation not allowed");
    }

    public ObjectInstance createMBean(String s, ObjectName objectName, ObjectName objectName1, Object[] objects, String[] strings) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        throw new SecurityException("Operation not allowed");
    }

    public Object instantiate(String s) throws ReflectionException, MBeanException {
        throw new SecurityException("Operation not allowed");
    }

    public Object instantiate(String s, ObjectName objectName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        throw new SecurityException("Operation not allowed");
    }

    public Object instantiate(String s, Object[] objects, String[] strings) throws ReflectionException, MBeanException {
        throw new SecurityException("Operation not allowed");
    }

    public Object instantiate(String s, ObjectName objectName, Object[] objects, String[] strings) throws ReflectionException, MBeanException, InstanceNotFoundException {
        throw new SecurityException("Operation not allowed");
    }

    public ObjectInstance registerMBean(Object o, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        throw new SecurityException("Operation not allowed");
    }

    public ObjectInputStream deserialize(String s, ObjectName objectName, byte[] bytes) throws InstanceNotFoundException, OperationsException, ReflectionException {
        throw new SecurityException("Operation not allowed");
    }

    public ObjectInputStream deserialize(String s, byte[] bytes) throws OperationsException, ReflectionException {
        throw new SecurityException("Operation not allowed");
    }

    public ObjectInputStream deserialize(ObjectName objectName, byte[] bytes) throws InstanceNotFoundException, OperationsException {
        throw new SecurityException("Operation not allowed");
    }

    public ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        throw new SecurityException("Operation not allowed");
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        return new ClassLoaderRepository(){

            public Class loadClass(String className) throws ClassNotFoundException {
                throw new ClassNotFoundException(className);
            }

            public Class loadClassWithout(ClassLoader loader, String className) throws ClassNotFoundException {
                throw new ClassNotFoundException(className);
            }

            public Class loadClassBefore(ClassLoader loader, String className) throws ClassNotFoundException {
                throw new ClassNotFoundException(className);
            }
        };
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        throw new SecurityException("Operation not allowed");
    }

    private class GBeanRegistrationListener
    extends LifecycleAdapter {
        private GBeanRegistrationListener() {
        }

        public void loaded(AbstractName abstractName) {
            KernelMBeanServer.this.register(abstractName);
        }

        public void unloaded(AbstractName abstractName) {
            KernelMBeanServer.this.unregister(abstractName);
        }
    }
}

