/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.ObjectNameUtil;
import org.apache.geronimo.kernel.config.ConfigurationAlreadyExistsException;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationInfo;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.IOUtil;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.FileWriteMonitor;
import org.apache.geronimo.kernel.repository.WritableListableRepository;
import org.apache.geronimo.system.configuration.ConfigurationStoreUtil;
import org.apache.geronimo.system.configuration.ExecutableConfigurationUtil;
import org.apache.geronimo.system.configuration.InPlaceConfigurationUtil;

public class RepositoryConfigurationStore
implements ConfigurationStore {
    private static final Log log = LogFactory.getLog(RepositoryConfigurationStore.class);
    private final Kernel kernel;
    private final ObjectName objectName;
    protected final WritableListableRepository repository;
    private final InPlaceConfigurationUtil inPlaceConfUtil;
    public static final GBeanInfo GBEAN_INFO;

    public RepositoryConfigurationStore(WritableListableRepository repository) {
        this(null, null, repository);
    }

    public RepositoryConfigurationStore(Kernel kernel, String objectName, WritableListableRepository repository) {
        this.kernel = kernel;
        this.objectName = objectName == null ? null : ObjectNameUtil.getObjectName((String)objectName);
        this.repository = repository;
        this.inPlaceConfUtil = new InPlaceConfigurationUtil();
    }

    public String getObjectName() {
        return this.objectName.getCanonicalName();
    }

    public AbstractName getAbstractName() {
        return this.kernel == null ? null : this.kernel.getAbstractNameFor((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationData loadConfiguration(Artifact configId) throws NoSuchConfigException, IOException, InvalidConfigException {
        ConfigurationData configurationData;
        File location;
        block13: {
            if (!configId.isResolved()) {
                throw new IllegalArgumentException("Artifact " + configId + " is not fully resolved");
            }
            location = this.repository.getLocation(configId);
            if (this.existsReadable(location)) {
                throw new NoSuchConfigException(configId);
            }
            try {
                if (location.isDirectory()) {
                    File serFile = new File(location, "META-INF");
                    if (!(serFile = new File(serFile, "config.ser")).exists()) {
                        throw new InvalidConfigException("Configuration does not contain a META-INF/config.ser file: " + serFile);
                    }
                    if (!serFile.canRead()) {
                        throw new InvalidConfigException("Can not read configuration META-INF/config.ser file: " + serFile);
                    }
                    ConfigurationStoreUtil.verifyChecksum(serFile);
                    FileInputStream in = new FileInputStream(serFile);
                    try {
                        configurationData = ConfigurationUtil.readConfigurationData((InputStream)in);
                        break block13;
                    }
                    finally {
                        IOUtil.close((InputStream)in);
                    }
                }
                JarFile jarFile = new JarFile(location);
                InputStream in = null;
                try {
                    ZipEntry entry = jarFile.getEntry("META-INF/config.ser");
                    in = jarFile.getInputStream(entry);
                    configurationData = ConfigurationUtil.readConfigurationData((InputStream)in);
                }
                catch (Throwable throwable) {
                    IOUtil.close(in);
                    IOUtil.close((JarFile)jarFile);
                    throw throwable;
                }
                IOUtil.close((InputStream)in);
                IOUtil.close((JarFile)jarFile);
            }
            catch (ClassNotFoundException e) {
                throw new InvalidConfigException("Unable to load class from config: " + configId, (Throwable)e);
            }
        }
        configurationData.setConfigurationDir(location);
        configurationData.setConfigurationStore((ConfigurationStore)this);
        if (this.kernel != null) {
            configurationData.setNaming(this.kernel.getNaming());
        }
        return configurationData;
    }

    private boolean existsReadable(File location) {
        return !location.exists() || !location.canRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsConfiguration(Artifact configId) {
        boolean bl;
        if (!configId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configId + " is not fully resolved");
        }
        File location = this.repository.getLocation(configId);
        if (location.isDirectory()) {
            location = new File(location, "META-INF");
            return (location = new File(location, "config.ser")).isFile() && location.canRead();
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(location);
            ZipEntry entry = jarFile.getEntry("META-INF/config.ser");
            bl = entry != null && !entry.isDirectory();
        }
        catch (IOException e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtil.close(jarFile);
                throw throwable;
            }
            IOUtil.close((JarFile)jarFile);
            return bl2;
        }
        IOUtil.close((JarFile)jarFile);
        return bl;
    }

    public File createNewConfigurationDir(Artifact configId) throws ConfigurationAlreadyExistsException {
        if (!configId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configId + " is not fully resolved");
        }
        File location = this.repository.getLocation(configId);
        if (location.exists()) {
            throw new ConfigurationAlreadyExistsException("Configuration already exists: " + configId);
        }
        location.mkdirs();
        if (!location.exists()) {
            throw new ConfigurationAlreadyExistsException("Could not create configuration directory: " + location);
        }
        return location;
    }

    public Set resolve(Artifact configId, String moduleName, String path) throws NoSuchConfigException, MalformedURLException {
        if (!configId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configId + " is not fully resolved");
        }
        File location = this.repository.getLocation(configId);
        if (location.isDirectory()) {
            File inPlaceLocation = null;
            try {
                inPlaceLocation = this.inPlaceConfUtil.readInPlaceLocation(location);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (null != inPlaceLocation) {
                location = inPlaceLocation;
            }
            if (moduleName != null) {
                location = new File(location, moduleName);
            }
            if (path == null) {
                return Collections.singleton(location.toURL());
            }
            if (location.isDirectory()) {
                Set matches = IOUtil.search((File)location, (String)path);
                return matches;
            }
            Set matches = IOUtil.search((File)location, (String)path);
            return matches;
        }
        Set matches = IOUtil.search((File)location, (String)(moduleName + "/" + path));
        return matches;
    }

    public void exportConfiguration(Artifact configId, OutputStream output) throws IOException, NoSuchConfigException {
        if (!configId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configId + " is not fully resolved");
        }
        File dir = this.repository.getLocation(configId);
        if (dir == null) {
            throw new NoSuchConfigException(configId);
        }
        if (this.existsReadable(dir)) {
            throw new IOException("Cannot read config store directory for " + configId + " (" + dir.getAbsolutePath() + ")");
        }
        ZipOutputStream out = new ZipOutputStream(output);
        byte[] buf = new byte[10240];
        this.writeToZip(dir, out, "", buf);
        if (this.inPlaceConfUtil.isInPlaceConfiguration(dir)) {
            dir = this.inPlaceConfUtil.readInPlaceLocation(dir);
            this.writeToZip(dir, out, "", buf);
        }
        out.closeEntry();
        out.finish();
        out.flush();
    }

    private void writeToZip(File dir, ZipOutputStream out, String prefix, byte[] buf) throws IOException {
        File[] all = dir.listFiles();
        for (int i = 0; i < all.length; ++i) {
            File file = all[i];
            if (file.isDirectory()) {
                this.writeToZip(file, out, prefix + file.getName() + "/", buf);
                continue;
            }
            ZipEntry entry = new ZipEntry(prefix + file.getName());
            out.putNextEntry(entry);
            this.writeToZipStream(file, out, buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToZipStream(File file, OutputStream out, byte[] buf) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            int count;
            while ((count = in.read(buf, 0, buf.length)) > -1) {
                out.write(buf, 0, count);
            }
        }
        finally {
            in.close();
        }
    }

    public void install(InputStream in, int size, Artifact configId, FileWriteMonitor fileWriteMonitor) throws IOException {
        try {
            this.repository.copyToRepository(in, size, configId, fileWriteMonitor);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            IOUtil.close((InputStream)in);
        }
    }

    public boolean isInPlaceConfiguration(Artifact configId) throws NoSuchConfigException, IOException {
        if (!configId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configId + " is not fully resolved");
        }
        File location = this.repository.getLocation(configId);
        if (location.isDirectory()) {
            return this.inPlaceConfUtil.isInPlaceConfiguration(location);
        }
        return false;
    }

    public void install(ConfigurationData configurationData) throws IOException, InvalidConfigException {
        File source = configurationData.getConfigurationDir();
        if (!source.exists()) {
            throw new InvalidConfigException("Source does not exist " + source);
        }
        if (!source.canRead()) {
            throw new InvalidConfigException("Source is not readable " + source);
        }
        Artifact configId = configurationData.getId();
        File destination = this.repository.getLocation(configId);
        if (!source.equals(destination)) {
            if (destination.exists()) {
                throw new ConfigurationAlreadyExistsException(configId.toString());
            }
            if (source.isFile()) {
                this.repository.copyToRepository(source, configId, null);
            } else if (source.isDirectory()) {
                IOUtil.recursiveCopy((File)source, (File)destination);
            } else {
                throw new InvalidConfigException("Unable to install configuration from " + source);
            }
        }
        ExecutableConfigurationUtil.writeConfiguration(configurationData, destination);
        this.inPlaceConfUtil.writeInPlaceLocation(configurationData, destination);
    }

    public void uninstall(Artifact configId) throws NoSuchConfigException, IOException {
        if (!configId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configId + " is not fully resolved");
        }
        ConfigurationInfo configurationInfo = null;
        try {
            configurationInfo = this.loadConfigurationInfo(configId);
        }
        catch (IOException e) {
            // empty catch block
        }
        File location = this.repository.getLocation(configId);
        IOUtil.recursiveDelete((File)location);
        int dirDepth = 0;
        boolean m2repo = true;
        if (m2repo) {
            dirDepth = 3;
        }
        File temp = location;
        for (int i = 0; i < dirDepth && (temp = temp.getParentFile()).listFiles().length == 0; ++i) {
            temp.delete();
        }
        if (configurationInfo != null) {
            IOException ioException = null;
            for (Artifact ownedConfiguration : configurationInfo.getOwnedConfigurations()) {
                block10: {
                    try {
                        this.uninstall(ownedConfiguration);
                    }
                    catch (NoSuchConfigException e) {
                    }
                    catch (IOException e) {
                        if (ioException == null) break block10;
                        ioException = e;
                    }
                }
                if (ioException == null) continue;
                throw ioException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listConfigurations() {
        ArrayList<ConfigurationInfo> configs;
        SortedSet artifacts = this.repository.list();
        RepositoryConfigurationStore repositoryConfigurationStore = this;
        synchronized (repositoryConfigurationStore) {
            configs = new ArrayList<ConfigurationInfo>();
            for (Artifact configId : artifacts) {
                File ser;
                File dir = this.repository.getLocation(configId);
                File meta = new File(dir, "META-INF");
                if (!meta.isDirectory() || !meta.canRead() || !(ser = new File(meta, "config.ser")).isFile() || !ser.canRead() || ser.length() == 0L) continue;
                try {
                    ConfigurationInfo configurationInfo = this.loadConfigurationInfo(configId);
                    configs.add(configurationInfo);
                }
                catch (NoSuchConfigException e) {
                    log.error((Object)("Unexpected error: found META-INF/config.ser for " + configId + " but couldn't load ConfigurationInfo"), (Throwable)e);
                }
                catch (IOException e) {
                    log.error((Object)("Unable to load ConfigurationInfo for " + configId), (Throwable)e);
                }
            }
        }
        return configs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConfigurationInfo loadConfigurationInfo(Artifact configId) throws NoSuchConfigException, IOException {
        ConfigurationInfo configurationInfo;
        File location = this.repository.getLocation(configId);
        if (!location.exists() && !location.canRead()) {
            throw new NoSuchConfigException(configId);
        }
        File inPlaceLocation = this.inPlaceConfUtil.readInPlaceLocation(location);
        if (location.isDirectory()) {
            File infoFile = new File(location, "META-INF");
            infoFile = new File(infoFile, "config.info");
            FileInputStream in2 = new FileInputStream(infoFile);
            try {
                configurationInfo = ConfigurationUtil.readConfigurationInfo((InputStream)in2, (AbstractName)this.getAbstractName(), (File)inPlaceLocation);
                return configurationInfo;
            }
            finally {
                IOUtil.close((InputStream)in2);
            }
        }
        JarFile jarFile = new JarFile(location);
        InputStream in = null;
        try {
            ZipEntry entry = jarFile.getEntry("META-INF/config.info");
            in = jarFile.getInputStream(entry);
            configurationInfo = ConfigurationUtil.readConfigurationInfo((InputStream)in, (AbstractName)this.getAbstractName(), (File)inPlaceLocation);
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            IOUtil.close((JarFile)jarFile);
            throw throwable;
        }
        IOUtil.close((InputStream)in);
        IOUtil.close((JarFile)jarFile);
        return configurationInfo;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder builder = GBeanInfoBuilder.createStatic(RepositoryConfigurationStore.class, (String)"ConfigurationStore");
        builder.addAttribute("kernel", Kernel.class, false);
        builder.addAttribute("objectName", String.class, false);
        builder.addReference("Repository", WritableListableRepository.class, "Repository");
        builder.setConstructor(new String[]{"kernel", "objectName", "Repository"});
        GBEAN_INFO = builder.getBeanInfo();
    }
}

