/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.sharedlib;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.OsgiService;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.hook.BundleHelper;
import org.apache.geronimo.hook.SharedLibraryRegistry;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.configuration.DependencyManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OsgiService
@GBean(j2eeType="ShareLibExtender")
public class SharedLibExtender
implements SynchronousBundleListener,
SharedLibraryRegistry,
GBeanLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(SharedLibExtender.class);
    private DependencyManager dependencyManager;
    private BundleContext bundleContext;
    private ConfigurationManager configurationManager;
    private Map<Artifact, List<Bundle>> configruationSharedLibBundlesMap = new ConcurrentHashMap<Artifact, List<Bundle>>();
    private Map<Long, List<Bundle>> applicationBundleIdSharedLibBundlesMap = new ConcurrentHashMap<Long, List<Bundle>>();
    private final ReentrantLock registerLock = new ReentrantLock();

    public SharedLibExtender(@ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext, @ParamReference(name="DependencyManager") DependencyManager dependencyManager, @ParamReference(name="ConfigurationManager", namingType="ConfigurationManager") ConfigurationManager configurationManager) {
        this.dependencyManager = dependencyManager;
        this.bundleContext = bundleContext;
        this.configurationManager = configurationManager;
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 2) {
            this.installSharedLibs(event.getBundle());
        } else if (event.getType() == 4) {
            this.uninstallSharedLibs(event.getBundle());
        }
    }

    public List<Bundle> getDependentSharedLibBundles(Long applicationId) {
        return this.applicationBundleIdSharedLibBundlesMap.get(applicationId);
    }

    private void uninstallSharedLibs(Bundle appBundle) {
        this.unregisterDependentSharedLibBundles(appBundle.getBundleId());
    }

    public List<Bundle> registerDependentSharedLibBundles(Long bundleId, List<Bundle> bundles) {
        return this.applicationBundleIdSharedLibBundlesMap.put(bundleId, bundles);
    }

    public List<Bundle> unregisterDependentSharedLibBundles(Long bundleId) {
        return this.applicationBundleIdSharedLibBundlesMap.remove(bundleId);
    }

    private void installSharedLibs(Bundle appBundle) {
        Artifact artifact = this.dependencyManager.getArtifact(appBundle.getBundleId());
        if (artifact == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to recongnize the artifact id for the bundle " + appBundle.getSymbolicName());
            }
            return;
        }
        if (!this.configurationManager.isConfiguration(artifact)) {
            return;
        }
        Configuration configuration = this.configurationManager.getConfiguration(artifact);
        ArrayList<Bundle> dependentSharedLibBundles = new ArrayList<Bundle>();
        for (Artifact parentArtifact : configuration.getDependencyNode().getParents()) {
            List<Bundle> sharedLibBundles = this.configruationSharedLibBundlesMap.get(parentArtifact);
            if (sharedLibBundles == null) continue;
            dependentSharedLibBundles.addAll(sharedLibBundles);
        }
        if (dependentSharedLibBundles.size() > 0) {
            this.registerDependentSharedLibBundles(appBundle.getBundleId(), dependentSharedLibBundles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSharedLibBundle(Artifact artifact, Bundle bundle) {
        this.registerLock.lock();
        try {
            List<Bundle> shareLibBundles = this.configruationSharedLibBundlesMap.get(artifact);
            if (shareLibBundles == null) {
                shareLibBundles = new LinkedList<Bundle>();
                this.configruationSharedLibBundlesMap.put(artifact, shareLibBundles);
            }
            shareLibBundles.add(bundle);
        }
        finally {
            this.registerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterSharedLibBundle(Artifact artifact, Bundle bundle) {
        this.registerLock.lock();
        try {
            List<Bundle> shareLibBundles = this.configruationSharedLibBundlesMap.get(artifact);
            if (shareLibBundles == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = shareLibBundles.remove(bundle);
            return bl;
        }
        finally {
            this.registerLock.unlock();
        }
    }

    public void doStart() throws Exception {
        this.bundleContext.addBundleListener((BundleListener)this);
        BundleHelper.setSharedLibraryRegistry((SharedLibraryRegistry)this);
    }

    public void doStop() throws Exception {
        this.bundleContext.removeBundleListener((BundleListener)this);
        BundleHelper.setSharedLibraryRegistry(null);
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

