/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.GeronimoSecurityException;
import org.apache.geronimo.security.realm.providers.CertificateCallback;
import org.apache.geronimo.security.realm.providers.GeronimoGroupPrincipal;
import org.apache.geronimo.security.realm.providers.GeronimoUserPrincipal;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class CertificatePropertiesFileLoginModule
implements LoginModule {
    private static Log log = LogFactory.getLog(CertificatePropertiesFileLoginModule.class);
    public static final String USERS_URI = "usersURI";
    public static final String GROUPS_URI = "groupsURI";
    private final Map users = new HashMap();
    final Map groups = new HashMap();
    private Subject subject;
    private CallbackHandler handler;
    private X500Principal principal;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.handler = callbackHandler;
        try {
            ServerInfo serverInfo = (ServerInfo)options.get("org.apache.geronimo.security.realm.GenericSecurityRealm.SERVERINFO");
            URI usersURI = new URI((String)options.get(USERS_URI));
            URI groupsURI = new URI((String)options.get(GROUPS_URI));
            this.loadProperties(serverInfo, usersURI, groupsURI);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new IllegalArgumentException("Unable to configure properties file login module: " + e.getMessage(), e);
        }
    }

    public void loadProperties(ServerInfo serverInfo, URI usersURI, URI groupURI) throws GeronimoSecurityException {
        try {
            URI userFile = serverInfo.resolve(usersURI);
            URI groupFile = serverInfo.resolve(groupURI);
            InputStream stream = userFile.toURL().openStream();
            Properties tmpUsers = new Properties();
            tmpUsers.load(stream);
            stream.close();
            for (Map.Entry<Object, Object> entry : tmpUsers.entrySet()) {
                this.users.put(entry.getValue(), entry.getKey());
            }
            Properties temp = new Properties();
            stream = groupFile.toURL().openStream();
            temp.load(stream);
            stream.close();
            Enumeration<Object> e = temp.keys();
            while (e.hasMoreElements()) {
                String groupName = (String)e.nextElement();
                String[] userList = ((String)temp.get(groupName)).split(",");
                HashSet<String> userset = (HashSet<String>)this.groups.get(groupName);
                if (userset == null) {
                    userset = new HashSet<String>();
                    this.groups.put(groupName, userset);
                }
                for (int i = 0; i < userList.length; ++i) {
                    String userName = userList[i];
                    userset.add(userName);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Properties File Login Module - data load failed", (Throwable)e);
            throw new GeronimoSecurityException((Throwable)e);
        }
    }

    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new CertificateCallback()};
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw (LoginException)new LoginException().initCause(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw (LoginException)new LoginException().initCause(uce);
        }
        assert (callbacks.length == 1);
        X509Certificate certificate = ((CertificateCallback)callbacks[0]).getCertificate();
        if (certificate == null) {
            throw new FailedLoginException();
        }
        this.principal = certificate.getSubjectX500Principal();
        if (!this.users.containsKey(this.principal.getName())) {
            throw new FailedLoginException();
        }
        return true;
    }

    public boolean commit() throws LoginException {
        Set<Principal> principals = this.subject.getPrincipals();
        principals.add(this.principal);
        String userName = (String)this.users.get(this.principal.getName());
        principals.add(new GeronimoUserPrincipal(userName));
        block0: for (String groupName : this.groups.keySet()) {
            Set users = (Set)this.groups.get(groupName);
            for (String user : users) {
                if (!userName.equals(user)) continue;
                principals.add(new GeronimoGroupPrincipal(groupName));
                continue block0;
            }
        }
        return true;
    }

    public boolean abort() throws LoginException {
        this.principal = null;
        return true;
    }

    public boolean logout() throws LoginException {
        this.principal = null;
        return true;
    }
}

