/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.util;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.common.GeronimoSecurityException;
import org.apache.geronimo.security.DomainPrincipal;
import org.apache.geronimo.security.PrimaryDomainPrincipal;
import org.apache.geronimo.security.PrimaryPrincipal;
import org.apache.geronimo.security.PrimaryRealmPrincipal;
import org.apache.geronimo.security.RealmPrincipal;
import org.apache.geronimo.security.deploy.DefaultDomainPrincipal;
import org.apache.geronimo.security.deploy.DefaultPrincipal;
import org.apache.geronimo.security.deploy.DefaultRealmPrincipal;
import org.apache.geronimo.security.deploy.PrincipalInfo;

public class ConfigurationUtil {
    static /* synthetic */ Class class$java$lang$String;

    public static X500Principal generateX500Principal(String name) {
        return new X500Principal(name);
    }

    public static Principal generatePrincipal(PrincipalInfo principalInfo, ClassLoader classLoader) {
        return ConfigurationUtil.generatePrincipal(principalInfo.getClassName(), principalInfo.getPrincipalName(), classLoader);
    }

    public static Principal generatePrincipal(final String className, final String principalName, final ClassLoader classLoader) {
        try {
            return (Principal)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Class<?> clazz = classLoader.loadClass(className);
                    Constructor<?> constructor = clazz.getDeclaredConstructor(class$java$lang$String == null ? (class$java$lang$String = ConfigurationUtil.class$("java.lang.String")) : class$java$lang$String);
                    return (Principal)constructor.newInstance(principalName);
                }
            });
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace();
            if (e.getException() != null) {
                e.getException().printStackTrace();
            }
            return null;
        }
    }

    public static RealmPrincipal generateRealmPrincipal(String realm, String loginDomain, PrincipalInfo principalInfo, ClassLoader classLoader) {
        return ConfigurationUtil.generateRealmPrincipal(realm, loginDomain, principalInfo.getClassName(), principalInfo.getPrincipalName(), classLoader);
    }

    public static RealmPrincipal generateRealmPrincipal(String realm, String loginDomain, String className, String principalName, ClassLoader classLoader) {
        return new RealmPrincipal(realm, loginDomain, ConfigurationUtil.generatePrincipal(className, principalName, classLoader));
    }

    public static DomainPrincipal generateDomainPrincipal(String loginDomain, PrincipalInfo principalInfo, ClassLoader classLoader) {
        return ConfigurationUtil.generateDomainPrincipal(loginDomain, principalInfo.getClassName(), principalInfo.getPrincipalName(), classLoader);
    }

    public static DomainPrincipal generateDomainPrincipal(String loginDomain, String className, String principalName, ClassLoader classLoader) {
        return new DomainPrincipal(loginDomain, ConfigurationUtil.generatePrincipal(className, principalName, classLoader));
    }

    public static PrimaryRealmPrincipal generatePrimaryRealmPrincipal(String realm, String domain, PrincipalInfo principalInfo, ClassLoader classLoader) throws DeploymentException {
        return ConfigurationUtil.generatePrimaryRealmPrincipal(realm, domain, principalInfo.getClassName(), principalInfo.getPrincipalName(), classLoader);
    }

    public static PrimaryRealmPrincipal generatePrimaryRealmPrincipal(final String realm, final String domain, final String className, final String principalName, final ClassLoader classLoader) throws DeploymentException {
        try {
            return (PrimaryRealmPrincipal)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Principal p = null;
                    Class<?> clazz = classLoader.loadClass(className);
                    Constructor<?> constructor = clazz.getDeclaredConstructor(class$java$lang$String == null ? (class$java$lang$String = ConfigurationUtil.class$("java.lang.String")) : class$java$lang$String);
                    p = (Principal)constructor.newInstance(principalName);
                    return new PrimaryRealmPrincipal(realm, domain, p);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new DeploymentException("Unable to create realm principal", (Throwable)pae.getException());
        }
    }

    public static PrimaryDomainPrincipal generatePrimaryDomainPrincipal(String domain, PrincipalInfo principalInfo, ClassLoader classLoader) throws DeploymentException {
        return ConfigurationUtil.generatePrimaryDomainPrincipal(domain, principalInfo.getClassName(), principalInfo.getPrincipalName(), classLoader);
    }

    public static PrimaryDomainPrincipal generatePrimaryDomainPrincipal(final String domain, final String className, final String principalName, final ClassLoader classLoader) throws DeploymentException {
        try {
            return (PrimaryDomainPrincipal)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Principal p = null;
                    Class<?> clazz = classLoader.loadClass(className);
                    Constructor<?> constructor = clazz.getDeclaredConstructor(class$java$lang$String == null ? (class$java$lang$String = ConfigurationUtil.class$("java.lang.String")) : class$java$lang$String);
                    p = (Principal)constructor.newInstance(principalName);
                    return new PrimaryDomainPrincipal(domain, p);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new DeploymentException("Unable to create domain principal", (Throwable)pae.getException());
        }
    }

    public static PrimaryPrincipal generatePrimaryPrincipal(PrincipalInfo principalInfo, ClassLoader classLoader) throws DeploymentException {
        return ConfigurationUtil.generatePrimaryPrincipal(principalInfo.getClassName(), principalInfo.getPrincipalName(), classLoader);
    }

    public static PrimaryPrincipal generatePrimaryPrincipal(final String className, final String principalName, final ClassLoader classLoader) throws DeploymentException {
        try {
            return (PrimaryPrincipal)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Principal p = null;
                    Class<?> clazz = classLoader.loadClass(className);
                    Constructor<?> constructor = clazz.getDeclaredConstructor(class$java$lang$String == null ? (class$java$lang$String = ConfigurationUtil.class$("java.lang.String")) : class$java$lang$String);
                    p = (Principal)constructor.newInstance(principalName);
                    return new PrimaryPrincipal(p);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new DeploymentException("Unable to create principal", (Throwable)pae.getException());
        }
    }

    public static Subject generateDefaultSubject(DefaultPrincipal defaultPrincipal, ClassLoader classLoader) throws DeploymentException {
        Principal primaryPrincipal;
        Principal principal;
        if (defaultPrincipal == null) {
            throw new GeronimoSecurityException("No DefaultPrincipal configuration supplied");
        }
        Subject defaultSubject = new Subject();
        if (defaultPrincipal instanceof DefaultRealmPrincipal) {
            DefaultRealmPrincipal defaultRealmPrincipal = (DefaultRealmPrincipal)defaultPrincipal;
            principal = ConfigurationUtil.generateRealmPrincipal(defaultRealmPrincipal.getRealm(), defaultRealmPrincipal.getDomain(), defaultRealmPrincipal.getPrincipal(), classLoader);
            primaryPrincipal = ConfigurationUtil.generatePrimaryRealmPrincipal(defaultRealmPrincipal.getRealm(), defaultRealmPrincipal.getDomain(), defaultRealmPrincipal.getPrincipal(), classLoader);
        } else if (defaultPrincipal instanceof DefaultDomainPrincipal) {
            DefaultDomainPrincipal defaultDomainPrincipal = (DefaultDomainPrincipal)defaultPrincipal;
            principal = ConfigurationUtil.generateDomainPrincipal(defaultDomainPrincipal.getDomain(), defaultDomainPrincipal.getPrincipal(), classLoader);
            primaryPrincipal = ConfigurationUtil.generatePrimaryDomainPrincipal(defaultDomainPrincipal.getDomain(), defaultDomainPrincipal.getPrincipal(), classLoader);
        } else {
            principal = ConfigurationUtil.generatePrincipal(defaultPrincipal.getPrincipal(), classLoader);
            primaryPrincipal = ConfigurationUtil.generatePrimaryPrincipal(defaultPrincipal.getPrincipal(), classLoader);
        }
        defaultSubject.getPrincipals().add(principal);
        defaultSubject.getPrincipals().add(primaryPrincipal);
        Set namedUserPasswordCredentials = defaultPrincipal.getNamedUserPasswordCredentials();
        if (namedUserPasswordCredentials != null) {
            defaultSubject.getPrivateCredentials().addAll(namedUserPasswordCredentials);
        }
        return defaultSubject;
    }

    public static void registerPolicyContextHandler(PolicyContextHandler handler, boolean replace) throws PolicyContextException {
        String[] keys = handler.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            PolicyContext.registerHandler((String)keys[i], (PolicyContextHandler)handler, (boolean)replace);
        }
    }
}

