/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security;

import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Subject;
import javax.security.jacc.EJBRoleRefPermission;
import org.apache.geronimo.security.Callers;
import org.apache.geronimo.security.GeronimoSecurityPermission;
import org.apache.geronimo.security.IdentificationPrincipal;
import org.apache.geronimo.security.PrimaryRealmPrincipal;
import org.apache.geronimo.security.RealmPrincipal;
import org.apache.geronimo.security.SubjectId;
import org.apache.geronimo.security.realm.providers.GeronimoCallerPrincipal;

public class ContextManager {
    private static ThreadLocal currentCallerId;
    private static final ThreadLocal callers;
    private static Map subjectContexts;
    private static Map subjectIds;
    private static long nextSubjectId;
    private static SecretKey key;
    private static String algorithm;
    private static String password;
    public static final GeronimoSecurityPermission GET_CONTEXT;
    public static final GeronimoSecurityPermission SET_CONTEXT;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Subject getServerSideSubject(Subject clientSideSubject) {
        Set set = clientSideSubject.getPrincipals(IdentificationPrincipal.class);
        if (set == null || set.size() == 0) {
            return null;
        }
        IdentificationPrincipal idp = (IdentificationPrincipal)set.iterator().next();
        return ContextManager.getRegisteredSubject(idp.getId());
    }

    public static void setCurrentCallerId(Serializable id) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONTEXT);
        }
        currentCallerId.set(id);
    }

    public static Serializable getCurrentCallerId() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONTEXT);
        }
        return (Serializable)currentCallerId.get();
    }

    public static void setCallers(Subject currentCaller, Subject nextCaller) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONTEXT);
        }
        if (!$assertionsDisabled && currentCaller == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && nextCaller == null) {
            throw new AssertionError();
        }
        Callers newCallers = new Callers(currentCaller, nextCaller);
        callers.set(newCallers);
    }

    public static void clearCallers() {
        callers.set(null);
    }

    public static Callers getCallers() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONTEXT);
        }
        return (Callers)callers.get();
    }

    public static Callers setNextCaller(Subject nextCaller) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONTEXT);
        }
        if (!$assertionsDisabled && nextCaller == null) {
            throw new AssertionError();
        }
        Callers oldCallers = (Callers)callers.get();
        if (!$assertionsDisabled && oldCallers == null) {
            throw new AssertionError();
        }
        Callers newCallers = new Callers(oldCallers.getNextCaller(), nextCaller);
        callers.set(newCallers);
        return oldCallers;
    }

    public static Callers pushNextCaller(Subject nextCaller) {
        Callers oldCallers;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONTEXT);
        }
        Subject oldNextCaller = (oldCallers = (Callers)callers.get()) == null ? null : oldCallers.getNextCaller();
        Subject newNextCaller = nextCaller == null ? oldNextCaller : nextCaller;
        Callers newCallers = new Callers(oldNextCaller, newNextCaller);
        callers.set(newCallers);
        return oldCallers;
    }

    public static void popCallers(Callers oldCallers) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONTEXT);
        }
        callers.set(oldCallers);
    }

    public static Subject getCurrentCaller() {
        Callers callers;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONTEXT);
        }
        return (callers = (Callers)ContextManager.callers.get()) == null ? null : callers.getCurrentCaller();
    }

    public static Subject getNextCaller() {
        Callers callers;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONTEXT);
        }
        return (callers = (Callers)ContextManager.callers.get()) == null ? null : callers.getNextCaller();
    }

    public static AccessControlContext getCurrentContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONTEXT);
        }
        Callers threadLocalCallers = (Callers)callers.get();
        if (!$assertionsDisabled && threadLocalCallers == null) {
            throw new AssertionError((Object)"No current callers");
        }
        Subject currentSubject = threadLocalCallers.getCurrentCaller();
        if (!$assertionsDisabled && currentSubject == null) {
            throw new AssertionError((Object)"No current caller");
        }
        Context context = (Context)subjectContexts.get(currentSubject);
        if (!$assertionsDisabled && context == null) {
            throw new AssertionError((Object)"No registered context");
        }
        return context.context;
    }

    public static Principal getCurrentPrincipal(Subject callerSubject) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONTEXT);
        }
        if (callerSubject == null) {
            return new Principal(){

                public String getName() {
                    return "";
                }
            };
        }
        Context context = (Context)subjectContexts.get(callerSubject);
        if (!$assertionsDisabled && context == null) {
            throw new AssertionError((Object)"No registered context");
        }
        return context.principal;
    }

    public static SubjectId getCurrentId() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONTEXT);
        }
        Callers threadLocalCallers = (Callers)callers.get();
        if (!$assertionsDisabled && threadLocalCallers == null) {
            throw new AssertionError((Object)"No current callers");
        }
        Subject currentSubject = threadLocalCallers.getCurrentCaller();
        if (!$assertionsDisabled && currentSubject == null) {
            throw new AssertionError((Object)"No current caller");
        }
        Context context = (Context)subjectContexts.get(currentSubject);
        if (!$assertionsDisabled && context == null) {
            throw new AssertionError((Object)"No registered context");
        }
        return context.id;
    }

    public static SubjectId getSubjectId(Subject subject) {
        Context context;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONTEXT);
        }
        return (context = (Context)subjectContexts.get(subject)) != null ? context.id : null;
    }

    public static boolean isCallerInRole(String EJBName, String role) {
        if (EJBName == null) {
            throw new IllegalArgumentException("EJBName must not be null");
        }
        if (role == null) {
            throw new IllegalArgumentException("Role must not be null");
        }
        try {
            Callers currentCallers = (Callers)callers.get();
            if (currentCallers == null) {
                return false;
            }
            Subject currentSubject = currentCallers.getCurrentCaller();
            if (currentSubject == null) {
                return false;
            }
            Context context = (Context)subjectContexts.get(currentSubject);
            if (!$assertionsDisabled && context == null) {
                throw new AssertionError((Object)"No registered context");
            }
            context.context.checkPermission((Permission)new EJBRoleRefPermission(EJBName, role));
        }
        catch (AccessControlException e) {
            return false;
        }
        return true;
    }

    public static Subject getRegisteredSubject(SubjectId id) {
        return (Subject)subjectIds.get(id);
    }

    public static synchronized SubjectId registerSubject(Subject subject) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONTEXT);
        }
        if (subject == null) {
            throw new IllegalArgumentException("Subject must not be null");
        }
        AccessControlContext acc = (AccessControlContext)Subject.doAsPrivileged(subject, new PrivilegedAction(){

            public Object run() {
                return AccessController.getContext();
            }
        }, null);
        Context context = new Context();
        context.subject = subject;
        context.context = acc;
        Set<Object> principals = subject.getPrincipals(GeronimoCallerPrincipal.class);
        if (!principals.isEmpty()) {
            context.principal = (Principal)principals.iterator().next();
        } else {
            principals = subject.getPrincipals(PrimaryRealmPrincipal.class);
            if (!principals.isEmpty()) {
                context.principal = (PrimaryRealmPrincipal)principals.iterator().next();
            } else {
                principals = subject.getPrincipals(RealmPrincipal.class);
                if (!principals.isEmpty()) {
                    context.principal = (RealmPrincipal)principals.iterator().next();
                } else {
                    principals = subject.getPrincipals();
                    if (!principals.isEmpty()) {
                        context.principal = (Principal)principals.iterator().next();
                    }
                }
            }
        }
        Long id = new Long(nextSubjectId++);
        context.id = new SubjectId(id, ContextManager.hash(id));
        subjectIds.put(context.id, subject);
        subjectContexts.put(subject, context);
        return context.id;
    }

    public static synchronized void unregisterSubject(Subject subject) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONTEXT);
        }
        if (subject == null) {
            throw new IllegalArgumentException("Subject must not be null");
        }
        Context context = (Context)subjectContexts.get(subject);
        if (context == null) {
            return;
        }
        subjectIds.remove(context.id);
        subjectContexts.remove(subject);
    }

    public static IdentificationPrincipal getThreadPrincipal() {
        Set set;
        Subject subject;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONTEXT);
        }
        if ((subject = Subject.getSubject(AccessController.getContext())) != null && !(set = subject.getPrincipals(IdentificationPrincipal.class)).isEmpty()) {
            return (IdentificationPrincipal)set.iterator().next();
        }
        return null;
    }

    public static String getAlgorithm() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONTEXT);
        }
        return algorithm;
    }

    public static void setAlgorithm(String algorithm) {
        block5: {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(SET_CONTEXT);
            }
            ContextManager.algorithm = algorithm;
            key = new SecretKeySpec(password.getBytes(), algorithm);
            try {
                Mac mac = Mac.getInstance(algorithm);
                mac.init(key);
            }
            catch (NoSuchAlgorithmException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Should never have reached here");
                }
            }
            catch (InvalidKeyException e) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)"Should never have reached here");
            }
        }
    }

    public static String getPassword() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONTEXT);
        }
        return password;
    }

    public static void setPassword(String password) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONTEXT);
        }
        ContextManager.password = password;
        key = new SecretKeySpec(password.getBytes(), algorithm);
    }

    private static byte[] hash(Long id) {
        long n = id;
        byte[] bytes = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bytes[i] = (byte)n;
            n >>>= 8;
        }
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(key);
            mac.update(bytes);
            return mac.doFinal();
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (InvalidKeyException e) {
            // empty catch block
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Should never have reached here");
        }
        return null;
    }

    static {
        $assertionsDisabled = !ContextManager.class.desiredAssertionStatus();
        currentCallerId = new ThreadLocal();
        callers = new ThreadLocal();
        subjectContexts = new IdentityHashMap();
        subjectIds = new Hashtable();
        nextSubjectId = System.currentTimeMillis();
        GET_CONTEXT = new GeronimoSecurityPermission("getContext");
        SET_CONTEXT = new GeronimoSecurityPermission("setContext");
        password = "secret";
        ContextManager.setAlgorithm("HmacSHA1");
    }

    private static class Context {
        SubjectId id;
        AccessControlContext context;
        Subject subject;
        Principal principal;

        private Context() {
        }
    }
}

